<?php

namespace Tests\Unit;

use PHPUnit\Framework\TestCase;

use App\Rules\UniqueToMultipleFieldsWithIgnore;
use Illuminate\Support\Facades\DB;
// use Tests\TestCase;
class UniqueToMultipleFieldsWithIgnoreTest extends TestCase
{
    public function test_validation_passes()
    {
        // Arrange
        DB::shouldReceive('table')
            ->with('table_name')
            ->andReturnSelf()
            ->shouldReceive('where')
            ->with(function ($closure) {
                $closure->shouldReceive('orWhere')
                    ->with('field_1', 'test')
                    ->shouldReceive('orWhere')
                    ->with('field_2', 'test');
            })
            ->andReturnSelf()
            ->shouldReceive('count')
            ->andReturn(0);

        $rule = new UniqueToMultipleFieldsWithIgnore('table_name', true, null, 'field_1', 'field_2');

        // Act
        $result = $rule->passes('attribute', 'test');

        // Assert
        $this->assertTrue($result);
    }

    public function test_validation_fails()
    {
        // Arrange
        DB::shouldReceive('table')
            ->with('table_name')
            ->andReturnSelf()
            ->shouldReceive('where')
            ->with(function ($closure) {
                $closure->shouldReceive('orWhere')
                    ->with('field_1', 'test')
                    ->shouldReceive('orWhere')
                    ->with('field_2', 'test');
            })
            ->andReturnSelf()
            ->shouldReceive('where')
            ->with('id', '<>', 1)
            ->andReturnSelf()
            ->shouldReceive('count')
            ->andReturn(1);

        $rule = new UniqueToMultipleFieldsWithIgnore('table_name', true, ['field' => 'id', 'value' => 1], 'field_1', 'field_2');

        // Act
        $result = $rule->passes('attribute', 'test');

        // Assert
        $this->assertFalse($result);
    }
}
