<div>
    <section class="py-6 px-4 text-gray-600 body-font  h-6/5">
        <?php echo $__env->make('components.loading-spinner-full-page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <h2>Products </h2>
        <div class="p-2">

            <ol class="relative border-l border-gray-200 dark:border-gray-700">
                <?php $__currentLoopData = $task->taskProductRequestLogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $evt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li class="mb-10 ml-6" v-for="(tEvt, index) in taskTimelines">
                        <span
                            class="flex absolute -left-3 justify-center items-center w-6 h-6 bg-blue-200 rounded-full ring-8 ring-white dark:ring-gray-900 dark:bg-blue-900">
                            <svg aria-hidden="true" class="w-3 h-3 text-blue-600 dark:text-blue-400" fill="currentColor"
                                viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd"
                                    d="M6 2a1 1 0 00-1 1v1H4a2 2 0 00-2 2v10a2 2 0 002 2h12a2 2 0 002-2V6a2 2 0 00-2-2h-1V3a1 1 0 10-2 0v1H7V3a1 1 0 00-1-1zm0 5a1 1 0 000 2h8a1 1 0 100-2H6z"
                                    clip-rule="evenodd"></path>
                            </svg>
                        </span>
                        <h3 class="mb-1 text-lg font-semibold text-gray-900 "><?php echo e($evt->event_type_label); ?></h3>
                        <time
                            class="block mb-2 text-sm font-normal leading-none text-gray-400 dark:text-gray-500"><?php echo e($evt->created_at); ?></time>
                        <p class="text-base font-normal text-gray-500 dark:text-gray-400"><?php echo e($evt->description); ?></p>
                        <?php if($evt->loggedBy): ?>
                            <time
                                class="block mb-2 text-xs font-normal leading-none text-gray-400 dark:text-gray-500">by
                                <?php echo e($evt->loggedBy->name_role ?? ''); ?></time>
                        <?php endif; ?>
                        <?php if(count($evt->all_products) > 0): ?>
                            <?php if(false): ?>
                                <div id="<?php echo e($accordion1Id); ?>-wrapper">
                                    <div id="<?php echo e($accordion1Id); ?>" data-accordion="collapse">

                                        <?php $__currentLoopData = $evt->all_products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <h2 id="<?php echo e($accordion1Id); ?>-heading-1">
                                                <button type="button"
                                                    class="flex items-center justify-between w-full p-5 font-medium text-left text-gray-500 border border-b-0 border-gray-200 rounded-t-xl focus:ring-4 focus:ring-gray-200 dark:focus:ring-gray-800 dark:border-gray-700 dark:text-gray-400 hover:bg-gray-100 dark:hover:bg-gray-800"
                                                    data-accordion-target="#<?php echo e($accordion1Id); ?>-body-1"
                                                    aria-expanded="true" aria-controls="<?php echo e($accordion1Id); ?>-body-1">
                                                    <span>What is Flowbite?</span>
                                                    <svg data-accordion-icon class="w-6 h-6 rotate-180 shrink-0"
                                                        fill="currentColor" viewBox="0 0 20 20"
                                                        xmlns="http://www.w3.org/2000/svg">
                                                        <path fill-rule="evenodd"
                                                            d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z"
                                                            clip-rule="evenodd"></path>
                                                    </svg>
                                                </button>
                                            </h2>
                                            <div id="<?php echo e($accordion1Id); ?>-body-1" class="hidden"
                                                aria-labelledby="<?php echo e($accordion1Id); ?>-heading-1">
                                                <div
                                                    class="p-5 font-light border border-b-0 border-gray-200 dark:border-gray-700 dark:bg-gray-900">
                                                    <p class="mb-2 text-gray-500 dark:text-gray-400">Flowbite is an
                                                        open-source
                                                        library of
                                                        interactive components built on top of Tailwind CSS including
                                                        buttons,
                                                        dropdowns,
                                                        modals,
                                                        navbars, and more.</p>
                                                    <p class="text-gray-500 dark:text-gray-400">Check out this guide to
                                                        learn how to
                                                        <a href="/docs/getting-started/introduction/"
                                                            class="text-blue-600 dark:text-blue-500 hover:underline">get
                                                            started</a>
                                                        and start
                                                        developing websites even faster with components on top of
                                                        Tailwind
                                                        CSS.
                                                    </p>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            <?php endif; ?>
                            <table class="table table-index w-full">
                                <thead>
                                    <tr>
                                        <th>Name</th>
                                        <th>Description</th>
                                        <th>Qty Requested</th>
                                        <th>Current Qty. (Circle)</th>
                                        <th>Status</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>

                                    <?php $__currentLoopData = $evt->all_products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $stockAvailable = $cStock($item->product_id);
                                            $canAccept = $stockAvailable >= $item->quantity;
                                            $needAccept = $stockAvailable >= $item->quantity;
                                            $needQuantity = $item->quantity - $stockAvailable;

                                        ?>
                                        <tr>
                                            <td class="px-1">
                                                <code before="#"
                                                    class="before:content-[attr(before)]"><?php echo e($item->id); ?></code>
                                                <?php echo e($item->product_name); ?>

                                                <?php if(!empty($item->product_model)): ?>
                                                    <br>Model: <?php echo e($item->product_model); ?>

                                                <?php endif; ?>
                                            </td>
                                            <td class="px-1"><?php echo e($item->product_description); ?></td>
                                            <td class="px-1"><?php echo e($item->quantity); ?></td>
                                            <td class="px-1"><?php echo e($stockAvailable); ?></td>
                                            <td class="px-1"><?php echo e($item->status_label); ?></td>
                                            <td class="px-1">
                                                <?php if(auth()->user()->isCircleOfficer()): ?>
                                                    <?php if($canAccept): ?>
                                                        <?php if($item->status == 'accepted'): ?>
                                                            <span class="text-sm">Product Sent</span>
                                                        <?php else: ?>
                                                            <button type="button" class="btn btn-primary btn-sm"
                                                                wire:click="acceptProductRequest('<?php echo e($item->product_id); ?>','<?php echo e($item->id); ?>')">Accept
                                                                And Send</button>
                                                        <?php endif; ?>
                                                    <?php else: ?>
                                                        
                                                        <?php if($item->status == 'requested'): ?>
                                                            <span class="text-sm">Already Requested</span>
                                                        <?php else: ?>
                                                            <button type="button" class="btn btn-primary btn-sm"
                                                                wire:click="requestProductToZonal('<?php echo e($item->product_id); ?>','<?php echo e($needQuantity); ?>',<?php echo e(json_encode($item)); ?>)">Request
                                                                to Zonal Office</button>
                                                        <?php endif; ?>
                                                    <?php endif; ?>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                        
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        <?php endif; ?>
                        
                    </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ol>


            <div id="<?php echo e($accordion1Id); ?>-wrapper" class="hidden">
                <div id="<?php echo e($accordion1Id); ?>" data-accordion="collapse">
                    <h2 id="<?php echo e($accordion1Id); ?>-heading-1">
                        <button type="button"
                            class="flex items-center justify-between w-full p-5 font-medium text-left text-gray-500 border border-b-0 border-gray-200 rounded-t-xl focus:ring-4 focus:ring-gray-200 dark:focus:ring-gray-800 dark:border-gray-700 dark:text-gray-400 hover:bg-gray-100 dark:hover:bg-gray-800"
                            data-accordion-target="#<?php echo e($accordion1Id); ?>-body-1" aria-expanded="true"
                            aria-controls="<?php echo e($accordion1Id); ?>-body-1">
                            <span>What is Flowbite?</span>
                            <svg data-accordion-icon class="w-6 h-6 rotate-180 shrink-0" fill="currentColor"
                                viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd"
                                    d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z"
                                    clip-rule="evenodd"></path>
                            </svg>
                        </button>
                    </h2>
                    <div id="<?php echo e($accordion1Id); ?>-body-1" class="hidden"
                        aria-labelledby="<?php echo e($accordion1Id); ?>-heading-1">
                        <div
                            class="p-5 font-light border border-b-0 border-gray-200 dark:border-gray-700 dark:bg-gray-900">
                            <p class="mb-2 text-gray-500 dark:text-gray-400">Flowbite is an open-source library of
                                interactive components built on top of Tailwind CSS including buttons, dropdowns,
                                modals,
                                navbars, and more.</p>
                            <p class="text-gray-500 dark:text-gray-400">Check out this guide to learn how to <a
                                    href="/docs/getting-started/introduction/"
                                    class="text-blue-600 dark:text-blue-500 hover:underline">get started</a> and start
                                developing websites even faster with components on top of Tailwind CSS.</p>
                        </div>
                    </div>
                    <h2 id="<?php echo e($accordion1Id); ?>-heading-2">
                        <button type="button"
                            class="flex items-center justify-between w-full p-5 font-medium text-left text-gray-500 border border-b-0 border-gray-200 focus:ring-4 focus:ring-gray-200 dark:focus:ring-gray-800 dark:border-gray-700 dark:text-gray-400 hover:bg-gray-100 dark:hover:bg-gray-800"
                            data-accordion-target="#<?php echo e($accordion1Id); ?>-body-2" aria-expanded="false"
                            aria-controls="<?php echo e($accordion1Id); ?>-body-2">
                            <span>Is there a Figma file available?</span>
                            <svg data-accordion-icon class="w-6 h-6 shrink-0" fill="currentColor" viewBox="0 0 20 20"
                                xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd"
                                    d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z"
                                    clip-rule="evenodd"></path>
                            </svg>
                        </button>
                    </h2>
                    <div id="<?php echo e($accordion1Id); ?>-body-2" class="hidden"
                        aria-labelledby="<?php echo e($accordion1Id); ?>-heading-2">
                        <div class="p-5 font-light border border-b-0 border-gray-200 dark:border-gray-700">
                            <p class="mb-2 text-gray-500 dark:text-gray-400">Flowbite is first conceptualized and
                                designed
                                using the Figma software so everything you see in the library has a design equivalent in
                                our
                                Figma file.</p>
                            <p class="text-gray-500 dark:text-gray-400">Check out the <a
                                    href="https://flowbite.com/figma/"
                                    class="text-blue-600 dark:text-blue-500 hover:underline">Figma design system</a>
                                based
                                on the utility classes from Tailwind CSS and components from Flowbite.</p>
                        </div>
                    </div>
                    <h2 id="<?php echo e($accordion1Id); ?>-heading-3">
                        <button type="button"
                            class="flex items-center justify-between w-full p-5 font-medium text-left text-gray-500 border border-gray-200 focus:ring-4 focus:ring-gray-200 dark:focus:ring-gray-800 dark:border-gray-700 dark:text-gray-400 hover:bg-gray-100 dark:hover:bg-gray-800"
                            data-accordion-target="#<?php echo e($accordion1Id); ?>-body-3" aria-expanded="false"
                            aria-controls="<?php echo e($accordion1Id); ?>-body-3">
                            <span>What are the differences between Flowbite and Tailwind UI?</span>
                            <svg data-accordion-icon class="w-6 h-6 shrink-0" fill="currentColor" viewBox="0 0 20 20"
                                xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd"
                                    d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z"
                                    clip-rule="evenodd"></path>
                            </svg>
                        </button>
                    </h2>
                    <div id="<?php echo e($accordion1Id); ?>-body-3" class="hidden"
                        aria-labelledby="<?php echo e($accordion1Id); ?>-heading-3">
                        <div class="p-5 font-light border border-t-0 border-gray-200 dark:border-gray-700">
                            <p class="mb-2 text-gray-500 dark:text-gray-400">The main difference is that the core
                                components
                                from Flowbite are open source under the MIT license, whereas Tailwind UI is a paid
                                product.
                                Another difference is that Flowbite relies on smaller and standalone components, whereas
                                Tailwind UI offers sections of pages.</p>
                            <p class="mb-2 text-gray-500 dark:text-gray-400">However, we actually recommend using both
                                Flowbite, Flowbite Pro, and even Tailwind UI as there is no technical reason stopping
                                you
                                from using the best of two worlds.</p>
                            <p class="mb-2 text-gray-500 dark:text-gray-400">Learn more about these technologies:</p>
                            <ul class="pl-5 text-gray-500 list-disc dark:text-gray-400">
                                <li><a href="https://flowbite.com/pro/"
                                        class="text-blue-600 dark:text-blue-500 hover:underline">Flowbite Pro</a></li>
                                <li><a href="https://tailwindui.com/" rel="nofollow"
                                        class="text-blue-600 dark:text-blue-500 hover:underline">Tailwind UI</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </section>
    <script>
        // alert(<?php echo json_encode(uniqid(), 15, 512) ?>);
        window.accordion1 = document.querySelector("#<?php echo e($accordion1Id); ?>-wrapper");

        window.lwModalInitialized.push({
            call: () => {
                initiateFlowBiteAccordion(document.querySelector("#<?php echo e($accordion1Id); ?>"));
            },
            calledCount: 0,
            callOnce: false,
            isCalled: false
        });
        // setTimeout(() => {
        //     initiateFlowBiteAccordion(document.querySelector("#<?php echo e($accordion1Id); ?>"))
        // }, 1000);
    </script>
</div>
<?php /**PATH /home/u918047115/.tmp/unix/przo/po/bms/repo/resources/views/livewire/task/co-task-products-modal-component.blade.php ENDPATH**/ ?>