<div>
    <div class="card-controls sm:flex">
        <div class="w-full sm:w-1/2">
            Per page:
            <select wire:model="perPage" class="form-select w-full sm:w-1/6">
                <?php $__currentLoopData = $paginationOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($value); ?>"><?php echo e($value); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('visit_reimbursement_delete')): ?>
                <button class="btn btn-rose ml-3 disabled:opacity-50 disabled:cursor-not-allowed" type="button" wire:click="confirm('deleteSelected')" wire:loading.attr="disabled" <?php echo e($this->selectedCount ? '' : 'disabled'); ?>>
                    <?php echo e(__('Delete Selected')); ?>

                </button>
            <?php endif; ?>

            <?php if(file_exists(app_path('Http/Livewire/ExcelExport.php'))): ?>
                <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('excel-export', ['model' => 'VisitReimbursement','format' => 'csv'])->html();
} elseif ($_instance->childHasBeenRendered('vl9M3vs')) {
    $componentId = $_instance->getRenderedChildComponentId('vl9M3vs');
    $componentTag = $_instance->getRenderedChildComponentTagName('vl9M3vs');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('vl9M3vs');
} else {
    $response = \Livewire\Livewire::mount('excel-export', ['model' => 'VisitReimbursement','format' => 'csv']);
    $html = $response->html();
    $_instance->logRenderedChild('vl9M3vs', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
                <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('excel-export', ['model' => 'VisitReimbursement','format' => 'xlsx'])->html();
} elseif ($_instance->childHasBeenRendered('NOwmuPb')) {
    $componentId = $_instance->getRenderedChildComponentId('NOwmuPb');
    $componentTag = $_instance->getRenderedChildComponentTagName('NOwmuPb');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('NOwmuPb');
} else {
    $response = \Livewire\Livewire::mount('excel-export', ['model' => 'VisitReimbursement','format' => 'xlsx']);
    $html = $response->html();
    $_instance->logRenderedChild('NOwmuPb', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
                <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('excel-export', ['model' => 'VisitReimbursement','format' => 'pdf'])->html();
} elseif ($_instance->childHasBeenRendered('6o64ES6')) {
    $componentId = $_instance->getRenderedChildComponentId('6o64ES6');
    $componentTag = $_instance->getRenderedChildComponentTagName('6o64ES6');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('6o64ES6');
} else {
    $response = \Livewire\Livewire::mount('excel-export', ['model' => 'VisitReimbursement','format' => 'pdf']);
    $html = $response->html();
    $_instance->logRenderedChild('6o64ES6', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
            <?php endif; ?>




        </div>
        <div class="w-full sm:w-1/2 sm:text-right">
            Search:
            <input type="text" wire:model.debounce.300ms="search" class="w-full sm:w-1/3 inline-block" />
        </div>
    </div>
    <div wire:loading.delay>
        Loading...
    </div>

    <div class="overflow-hidden">
        <div class="overflow-x-auto">
            <table class="table table-index w-full">
                <thead>
                    <tr>
                        <th class="w-9">
                        </th>
                        <th class="w-28">
                            <?php echo e(trans('cruds.visitReimbursement.fields.id')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'id'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.visitReimbursement.fields.user')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'user.name'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.visitReimbursement.fields.task')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'task.name'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.visitReimbursement.fields.approved_by')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'approved_by.name'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.visitReimbursement.fields.approved_at')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'approved_at'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.visitReimbursement.fields.amount')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'amount'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.visitReimbursement.fields.visit')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'visit.date'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.visitReimbursement.fields.status')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'status'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                        </th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $visitReimbursements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $visitReimbursement): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td>
                                <input type="checkbox" value="<?php echo e($visitReimbursement->id); ?>" wire:model="selected">
                            </td>
                            <td>
                                <?php echo e($visitReimbursement->id); ?>

                            </td>
                            <td>
                                <?php if($visitReimbursement->user): ?>
                                    <span class="badge badge-relationship"><?php echo e($visitReimbursement->user->name ?? ''); ?></span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($visitReimbursement->task): ?>
                                    <span class="badge badge-relationship"><?php echo e($visitReimbursement->task->name ?? ''); ?></span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($visitReimbursement->approvedBy): ?>
                                    <span class="badge badge-relationship"><?php echo e($visitReimbursement->approvedBy->name ?? ''); ?></span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php echo e($visitReimbursement->approved_at); ?>

                            </td>
                            <td>
                                <?php echo e($visitReimbursement->amount); ?>

                            </td>
                            <td>
                                <?php if($visitReimbursement->visit): ?>
                                    <span class="badge badge-relationship"><?php echo e($visitReimbursement->visit->date ?? ''); ?></span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php echo e($visitReimbursement->status_label); ?>

                            </td>
                            <td>
                                <div class="flex justify-end">
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('visit_reimbursement_show')): ?>
                                        <a class="btn btn-sm btn-info mr-2" href="<?php echo e(route('admin.visit-reimbursements.show', $visitReimbursement)); ?>">
                                            <?php echo e(trans('global.view')); ?>

                                        </a>
                                    <?php endif; ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('visit_reimbursement_edit')): ?>
                                        <a class="btn btn-sm btn-success mr-2" href="<?php echo e(route('admin.visit-reimbursements.edit', $visitReimbursement)); ?>">
                                            <?php echo e(trans('global.edit')); ?>

                                        </a>
                                    <?php endif; ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('visit_reimbursement_delete')): ?>
                                        <button class="btn btn-sm btn-rose mr-2" type="button" wire:click="confirm('delete', <?php echo e($visitReimbursement->id); ?>)" wire:loading.attr="disabled">
                                            <?php echo e(trans('global.delete')); ?>

                                        </button>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="10">No entries found.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <div class="card-body">
        <div class="pt-3">
            <?php if($this->selectedCount): ?>
                <p class="text-sm leading-5">
                    <span class="font-medium">
                        <?php echo e($this->selectedCount); ?>

                    </span>
                    <?php echo e(__('Entries selected')); ?>

                </p>
            <?php endif; ?>
            <?php echo e($visitReimbursements->links()); ?>

        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
    <script>
        Livewire.on('confirm', e => {
    if (!confirm("<?php echo e(trans('global.areYouSure')); ?>")) {
        return
    }
window.livewire.find('<?php echo e($_instance->id); ?>')[e.callback](...e.argv)
})
    </script>
<?php $__env->stopPush(); ?><?php /**PATH /home/u918047115/.tmp/unix/przo/po/bms/repo/resources/views/livewire/visit-reimbursement/index.blade.php ENDPATH**/ ?>