<div>
    <div class="w-full">
        <?php if(isset($attributes['multiple'])): ?>
            <div id="<?php echo e($attributes['id']); ?>-btn-container" class="mb-3">
                <button type="button"
                    class="btn btn-info btn-sm select-all-button"><?php echo e(trans('global.select_all')); ?></button>
                <button type="button"
                    class="btn btn-info btn-sm deselect-all-button"><?php echo e(trans('global.deselect_all')); ?></button>
            </div>
        <?php endif; ?>

        <select class="select2 form-control" data-placeholder="<?php echo e(__('Select your option')); ?>" <?php echo e($attributes); ?>>
            <?php if(!isset($attributes['multiple'])): ?>
                <option></option>
            <?php endif; ?>
            <?php $__currentLoopData = $options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                <option value="<?php echo e($isAssoc?$key:$value); ?>"><?php echo e($value); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
        <div class="select2_container_main" id="<?php echo e($attributes['id']); ?>-select2-container-main" wire:ignore>

        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
    <script>
        window.lwSelect2 = window.lwSelect2 ?? {};

        document.addEventListener("livewire:load", () => {
            let el = $('#<?php echo e($attributes['id']); ?>')
            let buttonsId = '#<?php echo e($attributes['id']); ?>-btn-container'
            let container = $('#<?php echo e($attributes['id']); ?>-select2-container-main')
            lwSelect2['<?php echo e($attributes['id']); ?>'] = el;

            function initButtons() {
                $(buttonsId + ' .select-all-button').click(function(e) {
                    el.val(_.map(el.find('option'), opt => $(opt).attr('value')))
                    el.trigger('change')
                })

                $(buttonsId + ' .deselect-all-button').click(function(e) {
                    el.val([])
                    el.trigger('change')
                })
            }

            function initSelect(re = false) {
                // console.log(el);
                initButtons()
                if (re) {
                    try {
                        el.select2('destroy');
                    } catch (error) {
                        console.log('nothing to destroy');
                    }
                }
                el.select2({
                    placeholder: '<?php echo e(__('Select your option')); ?>',
                    allowClear: !el.attr('required'),
                    dropdownParent: container,
                })
            }

            initSelect()

            Livewire.hook('message.processed', (message, component) => {
                initSelect(true)
            });

            el.on('change', function(e) {
                let data = $(this).select2("val")
                if (data === "") {
                    data = null
                }
                window.livewire.find('<?php echo e($_instance->id); ?>').set('<?php echo e($attributes['wire:model']); ?>', data)
            });
        });
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/u918047115/.tmp/unix/przo/po/bms/repo/resources/views/components/select-list.blade.php ENDPATH**/ ?>