<div>
    <div class="card-controls sm:flex">
        <div class="w-full sm:w-1/2">
            Per page:
            <select wire:model="perPage" class="form-select w-full sm:w-1/6">
                <?php $__currentLoopData = $paginationOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($value); ?>"><?php echo e($value); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('crm_customer_delete')): ?>
                <button class="btn btn-rose ml-3 disabled:opacity-50 disabled:cursor-not-allowed" type="button" wire:click="confirm('deleteSelected')" wire:loading.attr="disabled" <?php echo e($this->selectedCount ? '' : 'disabled'); ?>>
                    <?php echo e(__('Delete Selected')); ?>

                </button>
            <?php endif; ?>

            <?php if(file_exists(app_path('Http/Livewire/ExcelExport.php'))): ?>
                <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('excel-export', ['model' => 'CrmCustomer','format' => 'csv'])->html();
} elseif ($_instance->childHasBeenRendered('Yvnx9hL')) {
    $componentId = $_instance->getRenderedChildComponentId('Yvnx9hL');
    $componentTag = $_instance->getRenderedChildComponentTagName('Yvnx9hL');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('Yvnx9hL');
} else {
    $response = \Livewire\Livewire::mount('excel-export', ['model' => 'CrmCustomer','format' => 'csv']);
    $html = $response->html();
    $_instance->logRenderedChild('Yvnx9hL', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
                <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('excel-export', ['model' => 'CrmCustomer','format' => 'xlsx'])->html();
} elseif ($_instance->childHasBeenRendered('i2Tnq35')) {
    $componentId = $_instance->getRenderedChildComponentId('i2Tnq35');
    $componentTag = $_instance->getRenderedChildComponentTagName('i2Tnq35');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('i2Tnq35');
} else {
    $response = \Livewire\Livewire::mount('excel-export', ['model' => 'CrmCustomer','format' => 'xlsx']);
    $html = $response->html();
    $_instance->logRenderedChild('i2Tnq35', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
                <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('excel-export', ['model' => 'CrmCustomer','format' => 'pdf'])->html();
} elseif ($_instance->childHasBeenRendered('Te0awdE')) {
    $componentId = $_instance->getRenderedChildComponentId('Te0awdE');
    $componentTag = $_instance->getRenderedChildComponentTagName('Te0awdE');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('Te0awdE');
} else {
    $response = \Livewire\Livewire::mount('excel-export', ['model' => 'CrmCustomer','format' => 'pdf']);
    $html = $response->html();
    $_instance->logRenderedChild('Te0awdE', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
            <?php endif; ?>




        </div>
        <div class="w-full sm:w-1/2 sm:text-right">
            Search:
            <input type="text" wire:model.debounce.300ms="search" class="w-full sm:w-1/3 inline-block" />
        </div>
    </div>
    <?php echo $__env->make('components.loading-spinner-full-page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


    <div class="overflow-hidden">
        <div class="overflow-x-auto">
            <table class="table table-index w-full">
                <thead>
                    <tr>
                        <th class="w-9">
                        </th>
                        <th class="w-28">
                            <?php echo e(trans('cruds.crmCustomer.fields.id')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'id'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.crmCustomer.fields.first_name')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'first_name'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.crmCustomer.fields.last_name')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'last_name'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.crmCustomer.fields.status')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'status.name'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.crmCustomer.fields.email')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'email'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.crmCustomer.fields.phone')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'phone'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.crmCustomer.fields.address')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'address'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.crmCustomer.fields.skype')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'skype'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.crmCustomer.fields.website')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'website'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.crmCustomer.fields.description')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'description'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                        </th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $crmCustomers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $crmCustomer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td>
                                <input type="checkbox" value="<?php echo e($crmCustomer->id); ?>" wire:model="selected">
                            </td>
                            <td>
                                <?php echo e($crmCustomer->id); ?>

                            </td>
                            <td>
                                <?php echo e($crmCustomer->first_name); ?>

                            </td>
                            <td>
                                <?php echo e($crmCustomer->last_name); ?>

                            </td>
                            <td>
                                <?php if($crmCustomer->status): ?>
                                    <span class="badge badge-relationship"><?php echo e($crmCustomer->status->name ?? ''); ?></span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <a class="link-light-blue" href="mailto:<?php echo e($crmCustomer->email); ?>">
                                    <i class="far fa-envelope fa-fw">
                                    </i>
                                    <?php echo e($crmCustomer->email); ?>

                                </a>
                            </td>
                            <td>
                                <?php echo e($crmCustomer->phone); ?>

                            </td>
                            <td>
                                <?php echo e($crmCustomer->address); ?>

                            </td>
                            <td>
                                <?php echo e($crmCustomer->skype); ?>

                            </td>
                            <td>
                                <?php echo e($crmCustomer->website); ?>

                            </td>
                            <td>
                                <?php echo e($crmCustomer->description); ?>

                            </td>
                            <td>
                                <div class="flex justify-end">
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('crm_customer_show')): ?>
                                        <a class="btn btn-sm btn-info mr-2" href="<?php echo e(route('admin.crm-customers.show', $crmCustomer)); ?>">
                                            <?php echo e(trans('global.view')); ?>

                                        </a>
                                    <?php endif; ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('crm_customer_edit')): ?>
                                        <a class="btn btn-sm btn-success mr-2" href="<?php echo e(route('admin.crm-customers.edit', $crmCustomer)); ?>">
                                            <?php echo e(trans('global.edit')); ?>

                                        </a>
                                    <?php endif; ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('crm_customer_delete')): ?>
                                        <button class="btn btn-sm btn-rose mr-2" type="button" wire:click="confirm('delete', <?php echo e($crmCustomer->id); ?>)" wire:loading.attr="disabled">
                                            <?php echo e(trans('global.delete')); ?>

                                        </button>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="10">No entries found.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <div class="card-body">
        <div class="pt-3">
            <?php if($this->selectedCount): ?>
                <p class="text-sm leading-5">
                    <span class="font-medium">
                        <?php echo e($this->selectedCount); ?>

                    </span>
                    <?php echo e(__('Entries selected')); ?>

                </p>
            <?php endif; ?>
            <?php echo e($crmCustomers->links()); ?>

        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
    <script>
        Livewire.on('confirm', e => {
    if (!confirm("<?php echo e(trans('global.areYouSure')); ?>")) {
        return
    }
window.livewire.find('<?php echo e($_instance->id); ?>')[e.callback](...e.argv)
})
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/u918047115/.tmp/unix/przo/po/bms/repo/resources/views/livewire/crm-customer/index.blade.php ENDPATH**/ ?>