<?php $__env->startSection('content'); ?>

<div class="card bg-white">
    <div class="card-header">
        <div class="card-header-container">
            <h6 class="card-title">
                CSV Import
            </h6>
        </div>
    </div>

    <form action="<?php echo e($route); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>
        <input type="hidden" name="filename" value=<?php echo e($filename); ?>>
        <input type="hidden" name="redirectTo" value=<?php echo e($redirectTo); ?>>
        <input type="hidden" name="has_header" value=<?php echo e($csvHasHeader); ?>>

        <div class="overflow-hidden">
            <div class="overflow-x-auto">
                <table class="table table-index w-full">
                    <?php if($csvHasHeader): ?>
                        <thead>
                            <tr>
                                <?php $__currentLoopData = $csvHeader; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $header): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <th><?php echo e($header); ?></th>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tr>
                        </thead>
                    <?php endif; ?>
                    <tbody>
                        <?php $__currentLoopData = $csvPreviewLines; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $entries): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <?php $__currentLoopData = $entries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $entry): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <td><?php echo e($entry); ?></td>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <?php $__currentLoopData = $csvHeader; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $entry): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <td>
                                    <select name="fields[<?php echo e($key); ?>]" id="<?php echo e($key); ?>">
                                        <option value="">Please select</option>
                                        <?php $__currentLoopData = $fillables; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $field): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($field); ?>" <?php echo e(strtolower($entry) === strtolower($field) ? 'selected' : ''); ?>>
                                                <?php echo e($field); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </td>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tr>
                    </tbody>
                </table>

                <div class="card-body mt-3">
                    <div class="form-group">
                        <button type="submit" class="btn btn-indigo mr-2">
                            import
                        </button>
                        <a href="<?php echo e(url()->previous()); ?>" class="btn btn-secondary">
                            <?php echo e(trans('global.cancel')); ?>

                        </a>
                    </div>
                </div>
            </div>
        </div>
    </form>

</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u918047115/.tmp/unix/przo/po/bms/repo/resources/views/admin/csv-import.blade.php ENDPATH**/ ?>