<div>
    <?php
        // $groupId = $attributes['id'];
        $multiple = $attributes->has('multiple');
        $inputAttributes = $attributes->whereStartsWith(['wire:model']);
        $wireModelAttr = $attributes->whereStartsWith(['wire:model']);
    ?>
    <div class="w-full" tags-list-group="<?php echo e($groupId); ?>">
        <?php if(isset($attributes['multiple'])): ?>
            <div id="<?php echo e($attributes['id']); ?>-btn-container" class="mb-3">
                <button type="button"
                    class="btn btn-info btn-xs text-2xs select-all-button"><?php echo e(trans('global.select_all')); ?></button>
                <button type="button"
                    class="btn btn-info btn-xs text-2xs deselect-all-button"><?php echo e(trans('global.deselect_all')); ?></button>
            </div>
        <?php endif; ?>
        <ul class="x-grid w-full gap-2 x-md:grid-cols-6">

            <?php $__currentLoopData = $options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                

                <span class="text-xs inline-flex items-center font-bold leading-sm  px-1 py-1 rounded-full">
                    <input type="<?php echo e($multiple ? 'checkbox' : 'radio'); ?>" id="<?php echo e($groupId); ?>-<?php echo e($key); ?>"
                        name="<?php echo e($attributes['id']); ?>" value="<?php echo e($key); ?>" class="hidden peer"
                        <?php echo e($inputAttributes); ?>>
                    <label for="<?php echo e($groupId); ?>-<?php echo e($key); ?>"
                        class="inline-flex items-center justify-between w-full p-2 text-gray-500 bg-white border border-gray-200 rounded-lg cursor-pointer dark:hover:text-gray-300 dark:border-gray-700 dark:peer-checked:text-blue-500 peer-checked:border-blue-600 peer-checked:text-blue-600 hover:text-gray-600 hover:bg-gray-100 dark:text-gray-400 dark:bg-gray-800 dark:hover:bg-gray-700">
                        <div class="block">
                            
                            <div class="w-full"><?php echo e($value); ?></div>
                        </div>
                        
                    </label>
                </span>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
        
        
        <div class="select2_container_main" id="<?php echo e($attributes['id']); ?>-select2-container-main" wire:ignore>

        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
    <script>
        // window.lwSelect2 = window.lwSelect2 ?? {};

        document.addEventListener("livewire:load", () => {
            // let el = $('#<?php echo e($attributes['id']); ?>')
            let els = $('[tags-list-group="<?php echo e($groupId); ?>"] :radio,:checkbox');
            let buttonsId = '#<?php echo e($attributes['id']); ?>-btn-container'
            let container = $('#<?php echo e($attributes['id']); ?>-select2-container-main')
            // lwSelect2['<?php echo e($attributes['id']); ?>'] = el;

            function initButtons() {
                $(buttonsId + ' .select-all-button').click(function(e) {
                    els.prop('checked', true);
                    <?php $__currentLoopData = $wireModelAttr; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attrName => $attrValue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        window.livewire.find('<?php echo e($_instance->id); ?>').set('<?php echo e($attrValue); ?>', els.get().map(v => v.value));
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                })

                $(buttonsId + ' .deselect-all-button').click(function(e) {
                    els.prop('checked', false);
                    <?php $__currentLoopData = $wireModelAttr; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attrName => $attrValue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        window.livewire.find('<?php echo e($_instance->id); ?>').set('<?php echo e($attrValue); ?>', []);
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                })
            }

            initButtons();
            // els.on('change', function(e) {
            //     let data = $(this).select2("val")
            //     if (data === "") {
            //         data = null
            //     }
            //     window.livewire.find('<?php echo e($_instance->id); ?>').set('<?php echo e($attributes['wire:model']); ?>', data)
            // });
        });
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/u918047115/.tmp/unix/przo/po/bms/repo/resources/views/components/tags-list.blade.php ENDPATH**/ ?>