<div>
    
    <div class="row">
        <div class="card bg-blueGray-100">
            <div class="card-header">
                <div class="card-header-container">
                    <h6 class="card-title">
                        <?php echo e(trans('global.view')); ?>

                        <?php echo e(trans('cruds.task.title_singular')); ?>:
                        <?php echo e(trans('cruds.task.fields.id')); ?>

                        <?php echo e($task->id); ?>

                    </h6>
                </div>
            </div>

            <div class="card-body">
                <div class="pt-3">
                    <table class="table table-view">
                        <tbody class="bg-white">
                            <tr>
                                <th>
                                    <?php echo e(trans('cruds.task.fields.id')); ?>

                                </th>
                                <td>
                                    <?php echo e($task->id); ?>

                                </td>
                            </tr>
                            <tr>
                                <th>
                                    <?php echo e(trans('cruds.task.fields.name')); ?>

                                </th>
                                <td>
                                    <?php echo e($task->name); ?>

                                </td>
                            </tr>
                            <tr>
                                <th>
                                    <?php echo e(trans('cruds.task.fields.description')); ?>

                                </th>
                                <td>
                                    <?php echo e($task->description); ?>

                                </td>
                            </tr>
                            <tr>
                                <th>
                                    <?php echo e(trans('cruds.task.fields.status')); ?>

                                </th>
                                <td>
                                    <?php if($task->status): ?>
                                        <span class="badge badge-relationship"><?php echo e($task->status->name ?? ''); ?></span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <tr>
                                <th>
                                    <?php echo e(trans('cruds.task.fields.tag')); ?>

                                </th>
                                <td>
                                    <?php $__currentLoopData = $task->tag; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $entry): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <span class="badge badge-relationship"><?php echo e($entry->name); ?></span>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </td>
                            </tr>
                            <tr>
                                <th>
                                    <?php echo e(trans('cruds.task.fields.attachment')); ?>

                                </th>
                                <td>
                                    <?php $__currentLoopData = $task->attachment; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $entry): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <a class="link-light-blue" href="<?php echo e($entry['url']); ?>">
                                            <i class="far fa-file">
                                            </i>
                                            <?php echo e($entry['file_name']); ?>

                                        </a>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </td>
                            </tr>
                            <tr>
                                <th>
                                    <?php echo e(trans('cruds.task.fields.due_date')); ?>

                                </th>
                                <td>
                                    <?php echo e($task->due_date); ?>

                                </td>
                            </tr>
                            <tr>
                                <th>
                                    <?php echo e(trans('cruds.task.fields.assigned_to')); ?>

                                </th>
                                <td>
                                    <?php if($task->assignedTo): ?>
                                        <span
                                            class="badge badge-relationship"><?php echo e($task->assignedTo->name ?? ''); ?></span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <tr>
                                <th>
                                    <?php echo e(trans('cruds.task.fields.client_group')); ?>

                                </th>
                                <td>
                                    <?php if($task->clientGroup): ?>
                                        <span
                                            class="badge badge-relationship"><?php echo e($task->clientGroup->name ?? ''); ?></span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <tr>
                                <th>
                                    <?php echo e(trans('cruds.task.fields.client')); ?>

                                </th>
                                <td>
                                    <?php if($task->client): ?>
                                        <span class="badge badge-relationship"><?php echo e($task->client->name ?? ''); ?></span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <tr>
                                <th>
                                    <?php echo e(trans('cruds.task.fields.client_branch')); ?>

                                </th>
                                <td>
                                    <?php if($task->clientBranch): ?>
                                        <span
                                            class="badge badge-relationship"><?php echo e($task->clientBranch->name ?? ''); ?></span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <tr>
                                <th>
                                    <?php echo e(trans('cruds.task.fields.call_type')); ?>

                                </th>
                                <td>
                                    <?php echo e($task->call_type_label); ?>

                                </td>
                            </tr>
                            <tr>
                                <th>
                                    <?php echo e(trans('cruds.task.fields.incode')); ?>

                                </th>
                                <td>
                                    <?php echo e($task->incode); ?>

                                </td>
                            </tr>
                            <?php if($task->isTaskClosed() && $task->taskClosedLogLatest && $task->taskClosedLogLatest->call_report_image_url): ?>
                                <tr>
                                    <th>
                                        Call Report
                                    </th>
                                    <td>

                                        <img src="<?php echo e($task->taskClosedLogLatest->call_report_image_url); ?>"
                                            alt="Call Report" class="square object-fit h-10 w-10">
                                        <button class="btn btn-primary mt-2 "
                                            onclick="viewLink('<?php echo e($task->taskClosedLogLatest->call_report_image_url); ?>')">View</button>
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                    
                </div>
                <div class="form-group">

                    <a wire:click="$emit('openModal', 'task.task-assign-engineer-modal-component', <?php echo e(json_encode(['taskId' => $task->id])); ?>)"
                        class="btn btn-indigo mr-2">
                        Assign Engineer
                    </a>
                    <?php if($can_assign_engineer): ?>
                    <?php endif; ?>
                    <?php if($can_change_status): ?>
                        <a wire:click="$emit('openModal', 'task.task-change-status-modal-component', <?php echo e(json_encode(['taskId' => $task->id])); ?>)"
                            class="btn btn-indigo mr-2">
                            Change Status
                        </a>
                    <?php endif; ?>
                    <?php if($can_change_status): ?>
                        <a wire:click="$emit('openModal', 'task.co-task-products-modal-component', <?php echo e(json_encode(['taskId' => $task->id])); ?>)"
                            class="btn btn-indigo mr-2">
                            Products Requested
                        </a>
                    <?php endif; ?>
                    <a wire:click="$emit('openModal', 'task.task-timeline-modal-component', <?php echo e(json_encode(['taskId' => $task->id])); ?>)"
                        class="btn btn-indigo mr-2">
                        Timeline
                    </a>
                    <?php if($task->isTaskClosed()): ?>
                        <a wire:click="$emit('openModal', 'task.task-billing-modal-component', <?php echo e(json_encode(['taskId' => $task->id])); ?>)"
                            class="btn btn-indigo mr-2">
                            Billing details
                        </a>
                    <?php endif; ?>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('task_edit')): ?>
                        <a href="<?php echo e(route('admin.tasks.edit', $task)); ?>" class="btn btn-indigo mr-2">
                            <?php echo e(trans('global.edit')); ?>

                        </a>
                    <?php endif; ?>
                    <a href="<?php echo e(route('admin.tasks.index')); ?>" class="btn btn-secondary">
                        <?php echo e(trans('global.back')); ?>

                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/u918047115/.tmp/unix/przo/po/bms/repo/resources/views/livewire/task/task-show-admin.blade.php ENDPATH**/ ?>