<div>

    <?php echo $__env->make('components.loading-spinner-full-page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div>

        <div class="min-w-screen min-h-screen bg-gray-200 flex justify-center items-start px-5 py-5">
            <div class="rounded shadow-xl w-full bg-white p-5 text-gray-700" style="max-width:900px">
                <h1 class="text-3xl font-semibold leading-tight text-indigo-500">Zones</h1>
                <span class="text-sm text-gray">
                    Zones > Circles > Branches
                </span>
                <hr class="my-5 -mx-5">
                <div class="-mx-5" x-data="fileTree()">
                    <ul>
                        <?php $__currentLoopData = $zones2; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $zone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $l1Ref = 'ref' . uniqid();
                                $l1HasChildren = $zone->circles->count() > 0;
                            ?>
                            <li class="" id="<?php echo e(uniqid()); ?>">

                                <div class="flex">
                                    <a href="#" x-class="block-x px-5 py-1 hover:text-gray-900 has-children"
                                        id="<?php echo e(uniqid()); ?>" class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                                            'block px-5 py-1 hover:text-gray-900',
                                            'has-children' => $l1HasChildren,
                                        ]) ?>"
                                        @click.prevent="toggleLevel($refs.<?php echo e($l1Ref); ?>)"><i
                                            class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                                                'mdi text-orange-500 ',
                                                'mdi-folder-outline' => $l1HasChildren,
                                                'mdi-file-outline' => !$l1HasChildren,
                                            ]) ?>"></i> <?php echo e($zone->name); ?></a>
                                    <a href="<?php echo e(route('zo.zones-wise.products', ['zone' => $zone->id])); ?>"
                                        class="block px-5 py-1 hover:text-indigo-600 text-xs">
                                        View Products</a>
                                    <a href="<?php echo e(route('zo.zones-wise.product-requests', ['zone' => $zone->id])); ?>"
                                        class="block px-5 py-1 hover:text-indigo-600 text-xs">
                                        View Product Requests</a>
                                </div>
                                <?php if($l1HasChildren): ?>
                                    <ul x-ref="<?php echo e($l1Ref); ?>" style="display: none;" id="<?php echo e(uniqid()); ?>"
                                        class="pl-5 pb-1 transition-all duration-1000 opacity-0 opacity-100">


                                        <?php $__currentLoopData = $zone->circles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $circle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php
                                                $l2Ref = 'ref' . uniqid();
                                                $l2HasChildren = $circle->client_branches->count() > 0;
                                            ?>
                                            <li id="<?php echo e(uniqid()); ?>">

                                                <div class="flex">
                                                    <a href="#" --x-class="block px-5 py-1 hover:text-gray-900"
                                                        class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                                                            'block px-5 py-1 hover:text-gray-900',
                                                            'has-children' => $l2HasChildren,
                                                        ]) ?>" id="<?php echo e(uniqid()); ?>"
                                                        @click.prevent="toggleLevel($refs.<?php echo e($l2Ref); ?>)">
                                                        <i class="<?php echo \Illuminate\Support\Arr::toCssClasses([
                                                            'mdi text-orange-500 ',
                                                            'mdi-folder-outline' => $l2HasChildren,
                                                            'mdi-file-outline' => !$l2HasChildren,
                                                        ]) ?>"></i><?php echo e($circle->name); ?></a>

                                                        <a href="<?php echo e(route('zo.tasks.index', ['zn[]' => $zone->id, 'cr[]' => $circle->id, ])); ?>"
                                                            class="block px-5 py-1 hover:text-indigo-600 text-xs">
                                                            View Tickets</a>
                                                </div>
                                                <?php if($l2HasChildren): ?>
                                                    <ul x-ref="<?php echo e($l2Ref); ?>" id="<?php echo e(uniqid()); ?>"
                                                        class="pl-5 pb-1 transition-all duration-1000 opacity-0 opacity-100"
                                                        style="display: none;">
                                                        <?php $__currentLoopData = $circle->client_branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <?php
                                                                $l3Ref = 'ref' . uniqid();
                                                            ?>
                                                            <li id="<?php echo e(uniqid()); ?>">
                                                                
                                                                <p class="px-2 py-2 ">
                                                                    <span
                                                                        class="px-2 py-2 text-blue-400">#<?php echo e($branch->id); ?>&nbsp;<?php echo e($branch->name); ?>

                                                                        (<?php echo e($branch->circle->name); ?>)
                                                                    </span> &nbsp;
                                                                    &nbsp;
                                                                    <a href="<?php echo e(route('zo.tasks.index', ['zn[]' => $zone->id, 'cr[]' => $circle->id, 'br[]' => $branch->id, ])); ?>"
                                                                        class="block px-5 py-1 hover:text-indigo-600 text-xs">
                                                                        View Tickets</a>
                                                                </p>
                                                            </li>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </ul>
                                                <?php endif; ?>

                                            </li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                <?php endif; ?>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            </div>
        </div>

    </div>
</div>

<?php $__env->startPush('scripts'); ?>
    <script>
        // const levels = <?php echo json_encode($zonesJson, 15, 512) ?>;
        let fileTree = function() {
            return {
                // levels: levels,
                renderLevel: function(obj, i) {
                    let ref = "l" + Math.random().toString(36).substring(7);
                    let html = `<a href="#" class="block px-5 py-1 hover:text-gray-900" :class="{'has-children':level.children}" x-html="(level.children?'<i class=\\'mdi mdi-folder-outline text-orange-500\\'></i>':'<i class=\\'mdi mdi-file-outline text-gray-600\\'></i>')+' '+level.title" ${
        obj.children ? `@click.prevent="toggleLevel($refs.${ref})"` : ""
      }></a>`;

                    if (obj.children) {
                        html += `<ul style="display:none;" x-ref="${ref}" class="pl-5 pb-1 transition-all duration-1000 opacity-0">
                            <template x-for='(level,i) in level.children'>
                                <li x-html="renderLevel(level,i)"></li>
                            </template>
                        </ul>`;
                    }

                    return html;
                },
                showLevel: function(el) {
                    if (el) {
                        if (el.style.length === 1 && el.style.display === "none") {
                            el.removeAttribute("style");
                        } else {
                            el.style.removeProperty("display");
                        }
                    }
                    setTimeout(() => {
                        el.previousElementSibling
                            .querySelector("i.mdi")
                            .classList.add("mdi-folder-open-outline");
                        el.previousElementSibling
                            .querySelector("i.mdi")
                            .classList.remove("mdi-folder-outline");
                        el.classList.add("opacity-100");
                    }, 10);
                },
                hideLevel: function(el) {
                    if (el) {
                        el.style.display = "none";
                        el.classList.remove("opacity-100");
                        el.previousElementSibling
                            .querySelector("i.mdi")
                            .classList.remove("mdi-folder-open-outline");
                        el.previousElementSibling
                            .querySelector("i.mdi")
                            .classList.add("mdi-folder-outline");

                        let refs = el.querySelectorAll("ul[x-ref]");
                        for (var i = 0; i < refs.length; i++) {
                            this.hideLevel(refs[i]);
                        }
                    }
                },
                toggleLevel: function(el) {
                    console.log(el)
                    if (el && el.style.length && el.style.display === "none") {
                        this.showLevel(el);
                    } else {
                        this.hideLevel(el);
                    }
                }
            };
        };
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/u918047115/.tmp/unix/przo/po/bms/repo/resources/views/livewire/zonal-officer/zone/my-zones.blade.php ENDPATH**/ ?>