<form wire:submit.prevent="submit" class="pt-3">

    <div class="form-group <?php echo e($errors->has('visitRoute.from') ? 'invalid' : ''); ?>">
        <label class="form-label" for="from"><?php echo e(trans('cruds.visitRoute.fields.from')); ?></label>
        <input class="form-control" type="text" name="from" id="from" wire:model.defer="visitRoute.from">
        <div class="validation-message">
            <?php echo e($errors->first('visitRoute.from')); ?>

        </div>
        <div class="help-block">
            <?php echo e(trans('cruds.visitRoute.fields.from_helper')); ?>

        </div>
    </div>
    <div class="form-group <?php echo e($errors->has('visitRoute.to') ? 'invalid' : ''); ?>">
        <label class="form-label" for="to"><?php echo e(trans('cruds.visitRoute.fields.to')); ?></label>
        <input class="form-control" type="text" name="to" id="to" wire:model.defer="visitRoute.to">
        <div class="validation-message">
            <?php echo e($errors->first('visitRoute.to')); ?>

        </div>
        <div class="help-block">
            <?php echo e(trans('cruds.visitRoute.fields.to_helper')); ?>

        </div>
    </div>
    <div class="form-group <?php echo e($errors->has('visitRoute.journey_distance') ? 'invalid' : ''); ?>">
        <label class="form-label" for="journey_distance"><?php echo e(trans('cruds.visitRoute.fields.journey_distance')); ?></label>
        <input class="form-control" type="number" name="journey_distance" id="journey_distance" wire:model.defer="visitRoute.journey_distance" step="0.01">
        <div class="validation-message">
            <?php echo e($errors->first('visitRoute.journey_distance')); ?>

        </div>
        <div class="help-block">
            <?php echo e(trans('cruds.visitRoute.fields.journey_distance_helper')); ?>

        </div>
    </div>
    <div class="form-group <?php echo e($errors->has('visitRoute.journey_fare') ? 'invalid' : ''); ?>">
        <label class="form-label" for="journey_fare"><?php echo e(trans('cruds.visitRoute.fields.journey_fare')); ?></label>
        <input class="form-control" type="number" name="journey_fare" id="journey_fare" wire:model.defer="visitRoute.journey_fare" step="0.01">
        <div class="validation-message">
            <?php echo e($errors->first('visitRoute.journey_fare')); ?>

        </div>
        <div class="help-block">
            <?php echo e(trans('cruds.visitRoute.fields.journey_fare_helper')); ?>

        </div>
    </div>
    <div class="form-group <?php echo e($errors->has('visitRoute.vehicle_type') ? 'invalid' : ''); ?>">
        <label class="form-label required"><?php echo e(trans('cruds.visitRoute.fields.vehicle_type')); ?></label>
        <?php $__currentLoopData = $this->listsForFields['vehicle_type']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <label class="radio-label"><input type="radio" name="vehicle_type" wire:model="visitRoute.vehicle_type" value="<?php echo e($key); ?>"><?php echo e($value); ?></label>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <div class="validation-message">
            <?php echo e($errors->first('visitRoute.vehicle_type')); ?>

        </div>
        <div class="help-block">
            <?php echo e(trans('cruds.visitRoute.fields.vehicle_type_helper')); ?>

        </div>
    </div>
    <div class="form-group <?php echo e($errors->has('visitRoute.journey_type') ? 'invalid' : ''); ?>">
        <label class="form-label"><?php echo e(trans('cruds.visitRoute.fields.journey_type')); ?></label>
        <?php $__currentLoopData = $this->listsForFields['journey_type']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <label class="radio-label"><input type="radio" name="journey_type" wire:model="visitRoute.journey_type" value="<?php echo e($key); ?>"><?php echo e($value); ?></label>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <div class="validation-message">
            <?php echo e($errors->first('visitRoute.journey_type')); ?>

        </div>
        <div class="help-block">
            <?php echo e(trans('cruds.visitRoute.fields.journey_type_helper')); ?>

        </div>
    </div>
    <div class="form-group <?php echo e($errors->has('visitRoute.note') ? 'invalid' : ''); ?>">
        <label class="form-label" for="note"><?php echo e(trans('cruds.visitRoute.fields.note')); ?></label>
        <textarea class="form-control" name="note" id="note" wire:model.defer="visitRoute.note" rows="4"></textarea>
        <div class="validation-message">
            <?php echo e($errors->first('visitRoute.note')); ?>

        </div>
        <div class="help-block">
            <?php echo e(trans('cruds.visitRoute.fields.note_helper')); ?>

        </div>
    </div>
    <div class="form-group <?php echo e($errors->has('visitRoute.route_cost') ? 'invalid' : ''); ?>">
        <label class="form-label" for="route_cost"><?php echo e(trans('cruds.visitRoute.fields.route_cost')); ?></label>
        <input class="form-control" type="number" name="route_cost" id="route_cost" wire:model.defer="visitRoute.route_cost" step="0.01">
        <div class="validation-message">
            <?php echo e($errors->first('visitRoute.route_cost')); ?>

        </div>
        <div class="help-block">
            <?php echo e(trans('cruds.visitRoute.fields.route_cost_helper')); ?>

        </div>
    </div>
    <div class="form-group <?php echo e($errors->has('visitRoute.user_id') ? 'invalid' : ''); ?>">
        <label class="form-label" for="user"><?php echo e(trans('cruds.visitRoute.fields.user')); ?></label>
        <?php if (isset($component)) { $__componentOriginal27a1460291975da05a1f6dc019a28acd246e95fa = $component; } ?>
<?php $component = $__env->getContainer()->make(App\View\Components\SelectList::class, ['options' => $this->listsForFields['user']]); ?>
<?php $component->withName('select-list'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes(['class' => 'form-control','id' => 'user','name' => 'user','wire:model' => 'visitRoute.user_id']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal27a1460291975da05a1f6dc019a28acd246e95fa)): ?>
<?php $component = $__componentOriginal27a1460291975da05a1f6dc019a28acd246e95fa; ?>
<?php unset($__componentOriginal27a1460291975da05a1f6dc019a28acd246e95fa); ?>
<?php endif; ?>
        <div class="validation-message">
            <?php echo e($errors->first('visitRoute.user_id')); ?>

        </div>
        <div class="help-block">
            <?php echo e(trans('cruds.visitRoute.fields.user_helper')); ?>

        </div>
    </div>
    <div class="form-group <?php echo e($errors->has('visitRoute.reimbursement_id') ? 'invalid' : ''); ?>">
        <label class="form-label" for="reimbursement"><?php echo e(trans('cruds.visitRoute.fields.reimbursement')); ?></label>
        <?php if (isset($component)) { $__componentOriginal27a1460291975da05a1f6dc019a28acd246e95fa = $component; } ?>
<?php $component = $__env->getContainer()->make(App\View\Components\SelectList::class, ['options' => $this->listsForFields['reimbursement']]); ?>
<?php $component->withName('select-list'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes(['class' => 'form-control','id' => 'reimbursement','name' => 'reimbursement','wire:model' => 'visitRoute.reimbursement_id']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal27a1460291975da05a1f6dc019a28acd246e95fa)): ?>
<?php $component = $__componentOriginal27a1460291975da05a1f6dc019a28acd246e95fa; ?>
<?php unset($__componentOriginal27a1460291975da05a1f6dc019a28acd246e95fa); ?>
<?php endif; ?>
        <div class="validation-message">
            <?php echo e($errors->first('visitRoute.reimbursement_id')); ?>

        </div>
        <div class="help-block">
            <?php echo e(trans('cruds.visitRoute.fields.reimbursement_helper')); ?>

        </div>
    </div>

    <div class="form-group">
        <button class="btn btn-indigo mr-2" type="submit">
            <?php echo e(trans('global.save')); ?>

        </button>
        <a href="<?php echo e(route('admin.visit-routes.index')); ?>" class="btn btn-secondary">
            <?php echo e(trans('global.cancel')); ?>

        </a>
    </div>
</form><?php /**PATH /home/u918047115/.tmp/unix/przo/po/bms/repo/resources/views/livewire/visit-route/create.blade.php ENDPATH**/ ?>