<div>
    <div class="card-controls sm:flex">
        <div class="w-full sm:w-1/2">
            Per page:
            <select wire:model="perPage" class="form-select w-full sm:w-1/6">
                <?php $__currentLoopData = $paginationOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($value); ?>"><?php echo e($value); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('job_designation_delete')): ?>
                <button class="btn btn-rose ml-3 disabled:opacity-50 disabled:cursor-not-allowed" type="button" wire:click="confirm('deleteSelected')" wire:loading.attr="disabled" <?php echo e($this->selectedCount ? '' : 'disabled'); ?>>
                    <?php echo e(__('Delete Selected')); ?>

                </button>
            <?php endif; ?>

            <?php if(file_exists(app_path('Http/Livewire/ExcelExport.php'))): ?>
                <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('excel-export', ['model' => 'JobDesignation','format' => 'csv'])->html();
} elseif ($_instance->childHasBeenRendered('XUv5iqG')) {
    $componentId = $_instance->getRenderedChildComponentId('XUv5iqG');
    $componentTag = $_instance->getRenderedChildComponentTagName('XUv5iqG');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('XUv5iqG');
} else {
    $response = \Livewire\Livewire::mount('excel-export', ['model' => 'JobDesignation','format' => 'csv']);
    $html = $response->html();
    $_instance->logRenderedChild('XUv5iqG', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
                <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('excel-export', ['model' => 'JobDesignation','format' => 'xlsx'])->html();
} elseif ($_instance->childHasBeenRendered('OZY9u2Q')) {
    $componentId = $_instance->getRenderedChildComponentId('OZY9u2Q');
    $componentTag = $_instance->getRenderedChildComponentTagName('OZY9u2Q');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('OZY9u2Q');
} else {
    $response = \Livewire\Livewire::mount('excel-export', ['model' => 'JobDesignation','format' => 'xlsx']);
    $html = $response->html();
    $_instance->logRenderedChild('OZY9u2Q', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
                <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('excel-export', ['model' => 'JobDesignation','format' => 'pdf'])->html();
} elseif ($_instance->childHasBeenRendered('qcFZxqc')) {
    $componentId = $_instance->getRenderedChildComponentId('qcFZxqc');
    $componentTag = $_instance->getRenderedChildComponentTagName('qcFZxqc');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('qcFZxqc');
} else {
    $response = \Livewire\Livewire::mount('excel-export', ['model' => 'JobDesignation','format' => 'pdf']);
    $html = $response->html();
    $_instance->logRenderedChild('qcFZxqc', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
            <?php endif; ?>




        </div>
        <div class="w-full sm:w-1/2 sm:text-right">
            Search:
            <input type="text" wire:model.debounce.300ms="search" class="w-full sm:w-1/3 inline-block" />
        </div>
    </div>
    <div wire:loading.delay>
        Loading...
    </div>

    <div class="overflow-hidden">
        <div class="overflow-x-auto">
            <table class="table table-index w-full">
                <thead>
                    <tr>
                        <th class="w-9">
                        </th>
                        <th class="w-28">
                            <?php echo e(trans('cruds.jobDesignation.fields.id')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'id'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.jobDesignation.fields.title')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'title'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.jobDesignation.fields.description')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'description'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.jobDesignation.fields.basic_salary')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'basic_salary'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.jobDesignation.fields.basic_salary_max')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'basic_salary_max'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                        </th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $jobDesignations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $jobDesignation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td>
                                <input type="checkbox" value="<?php echo e($jobDesignation->id); ?>" wire:model="selected">
                            </td>
                            <td>
                                <?php echo e($jobDesignation->id); ?>

                            </td>
                            <td>
                                <?php echo e($jobDesignation->title); ?>

                            </td>
                            <td>
                                <?php echo e($jobDesignation->description); ?>

                            </td>
                            <td>
                                <?php echo e($jobDesignation->basic_salary); ?>

                            </td>
                            <td>
                                <?php echo e($jobDesignation->basic_salary_max); ?>

                            </td>
                            <td>
                                <div class="flex justify-end">
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('job_designation_show')): ?>
                                        <a class="btn btn-sm btn-info mr-2" href="<?php echo e(route('admin.job-designations.show', $jobDesignation)); ?>">
                                            <?php echo e(trans('global.view')); ?>

                                        </a>
                                    <?php endif; ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('job_designation_edit')): ?>
                                        <a class="btn btn-sm btn-success mr-2" href="<?php echo e(route('admin.job-designations.edit', $jobDesignation)); ?>">
                                            <?php echo e(trans('global.edit')); ?>

                                        </a>
                                    <?php endif; ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('job_designation_delete')): ?>
                                        <button class="btn btn-sm btn-rose mr-2" type="button" wire:click="confirm('delete', <?php echo e($jobDesignation->id); ?>)" wire:loading.attr="disabled">
                                            <?php echo e(trans('global.delete')); ?>

                                        </button>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="10">No entries found.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <div class="card-body">
        <div class="pt-3">
            <?php if($this->selectedCount): ?>
                <p class="text-sm leading-5">
                    <span class="font-medium">
                        <?php echo e($this->selectedCount); ?>

                    </span>
                    <?php echo e(__('Entries selected')); ?>

                </p>
            <?php endif; ?>
            <?php echo e($jobDesignations->links()); ?>

        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
    <script>
        Livewire.on('confirm', e => {
    if (!confirm("<?php echo e(trans('global.areYouSure')); ?>")) {
        return
    }
window.livewire.find('<?php echo e($_instance->id); ?>')[e.callback](...e.argv)
})
    </script>
<?php $__env->stopPush(); ?><?php /**PATH /home/u918047115/.tmp/unix/przo/po/bms/repo/resources/views/livewire/job-designation/index.blade.php ENDPATH**/ ?>