<div wire:submit.prevent="submit" class="pt-3">
    <?php echo $__env->make('components.loading-spinner-full-page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="grid grid-cols-1 lg:grid-cols-5 gap-2 mb-2">

        <div class="form-group <?php echo e($errors->has('zone_id') ? 'invalid' : ''); ?>">
            <label class="form-label" for="zone"><?php echo e(trans('cruds.productZonePivot.fields.zone')); ?></label>
            <?php if (isset($component)) { $__componentOriginal27a1460291975da05a1f6dc019a28acd246e95fa = $component; } ?>
<?php $component = $__env->getContainer()->make(App\View\Components\SelectList::class, ['options' => $this->listsForFields['zone']]); ?>
<?php $component->withName('select-list'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes(['class' => 'form-control','id' => 'zone','name' => 'zone','wire:model' => 'zone_id']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal27a1460291975da05a1f6dc019a28acd246e95fa)): ?>
<?php $component = $__componentOriginal27a1460291975da05a1f6dc019a28acd246e95fa; ?>
<?php unset($__componentOriginal27a1460291975da05a1f6dc019a28acd246e95fa); ?>
<?php endif; ?>
            <div class="validation-message">
                <?php echo e($errors->first('zone_id')); ?>

            </div>
            <div class="help-block">
                Select a zone to load circles
            </div>
        </div>
        <div class="form-group <?php echo e($errors->has('circle_id') ? 'invalid' : ''); ?>">
            <label class="form-label" for="circle">Circle</label>
            <?php if (isset($component)) { $__componentOriginal27a1460291975da05a1f6dc019a28acd246e95fa = $component; } ?>
<?php $component = $__env->getContainer()->make(App\View\Components\SelectList::class, ['options' => $this->listsForFields['circle']]); ?>
<?php $component->withName('select-list'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes(['class' => 'form-control','id' => 'circle','name' => 'circle','wire:model' => 'circle_id']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal27a1460291975da05a1f6dc019a28acd246e95fa)): ?>
<?php $component = $__componentOriginal27a1460291975da05a1f6dc019a28acd246e95fa; ?>
<?php unset($__componentOriginal27a1460291975da05a1f6dc019a28acd246e95fa); ?>
<?php endif; ?>
            <div class="validation-message">
                <?php echo e($errors->first('circle_id')); ?>

            </div>
            <div class="help-block">
                Select a circle to update products
            </div>
        </div>
        <?php if(0): ?>
            <div class="form-group">
                <label class="form-label " for="">&nbsp;</label>
                <button class="btn btn-indigo mr-2 mt-2" type="button" wire:click="loadProducts">
                    Proceed
                </button>
            </div>
        <?php endif; ?>
    </div>

    
    <?php if($zone && $circle): ?>
        <div class="relative">

            <div class="hidden x-flex items-center w-full mb-2">
                <label for="simple-search" class="sr-only">Search</label>
                <div class="relative  w-full">
                    <div class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none">
                        <svg aria-hidden="true" class="w-5 h-5 text-gray-500 dark:text-gray-400" fill="currentColor"
                            viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd"
                                d="M8 4a4 4 0 100 8 4 4 0 000-8zM2 8a6 6 0 1110.89 3.476l4.817 4.817a1 1 0 01-1.414 1.414l-4.816-4.816A6 6 0 012 8z"
                                clip-rule="evenodd"></path>
                        </svg>
                    </div>
                    <input type="text" id="simpleSearchInput"
                        class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full pl-10 p-2.5  dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500"
                        placeholder="Search" required>
                </div>
                <button type="button" onclick="simpleSearchInput.value=''"
                    class="p-2.5 ml-2 text-sm font-medium text-white bg-blue-700 rounded-lg border border-blue-700 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                        stroke="currentColor" class="w-5 h-5">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12" />
                    </svg>
                    <span class="sr-only">Search</span>
                </button>
            </div>
            <div class="overflow-x-auto mb-3">
                <table class="table table-index w-full">
                    <thead>
                        <tr>
                            <th>Product Name/Description</th>
                            <th>Price</th>
                            <th>Current Zone Stock</th>
                            <th>Current Circle Stock</th>
                            <?php if($stockMode == 'add'): ?>
                                <th>Stock To Add to circle</th>
                            <?php else: ?>
                                <th>Stock To Reduce from circle</th>
                            <?php endif; ?>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr class="" id="<?php echo e(uniqid()); ?>">
                                <td>
                                    <code>#<?php echo e($p->id); ?></code>
                                    <span> <?php echo e($p->name); ?> </span>
                                    <span class="text-2xs block"> <?php echo e($p->description); ?> </span>
                                </td>
                                <td>
                                    ₹<?php echo e($p->price); ?>

                                </td>
                                <td>
                                    <?php echo e($p->zoneStock); ?>

                                </td>
                                <td>
                                    <?php echo e($p->circleStock); ?>

                                </td>
                                <td>
                                    <?php if($stockMode == 'add'): ?>
                                        <?php if($p->zoneStock > 0): ?>
                                            <div
                                                class="form-group <?php echo e($errors->has("state.stock.{$p->id}.add") ? 'invalid' : ''); ?>">
                                                <input type="number" class="w-[150px]"
                                                    wire:model.defer="state.stock.<?php echo e($p->id); ?>.add"
                                                    min="0" max="<?php echo e($p->zoneStock); ?>" />
                                                <div class="validation-message text-xs">
                                                    <?php echo e($errors->first("state.stock.{$p->id}.add")); ?>

                                                </div>
                                            </div>
                                        <?php endif; ?>
                                    <?php else: ?>
                                        <?php if($p->circleStock > 0): ?>
                                            <div
                                                class="form-group <?php echo e($errors->has("state.stock.{$p->id}.reduce") ? 'invalid' : ''); ?>">
                                                <input type="number" class="w-[150px]"
                                                    wire:model.defer="state.stock.<?php echo e($p->id); ?>.reduce"
                                                    min="0" max="<?php echo e($p->circleStock); ?>" />
                                                <div class="validation-message text-xs">
                                                    <?php echo e($errors->first("state.stock.{$p->id}.reduce")); ?>

                                                </div>
                                            </div>
                                        <?php endif; ?>
                                    <?php endif; ?>

                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php if($products->count() == 0): ?>
                            <tr>
                                <td class="text-center py-2" colspan="4">
                                    No products found
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <?php if($products->count() > 0): ?>
                <div class="bg-gray-100 text-3xl text-white sticky inset-x-0 bottom-5 p-4 shadow-lg drop-shadow-lg">
                    <div class="grid grid-cols-2 gap-2 items-center">
                        <div class="text-left">

                            <label class="relative inline-flex items-center cursor-pointer">
                                <input type="checkbox" value="add" class="sr-only peer" checked
                                    onchange="window.livewire.find('<?php echo e($_instance->id); ?>').setStockMode(this.checked?'add':'reduce')">
                                <div
                                    class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-blue-300 dark:peer-focus:ring-blue-800 rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all dark:border-gray-600 peer-checked:bg-blue-600">
                                </div>
                                <?php if($stockMode == 'add'): ?>
                                    <span class="ml-3 text-sm font-medium text-gray-900 dark:text-gray-300">Add
                                        stock</span>
                                <?php else: ?>
                                    <span class="ml-3 text-sm font-medium text-gray-900 dark:text-gray-300">Reduce
                                        stock</span>
                                <?php endif; ?>
                            </label>
                        </div>
                        <div class="text-right">


                            <?php if($stockMode == 'add'): ?>
                                <button class="btn btn-indigo mr-2" wire:click="addStocks" type="button">
                                    Add Stocks
                                </button>
                            <?php else: ?>
                                <button class="btn btn-danger mr-2" wire:click="reduceStocks" type="button">
                                    Reduce Stocks
                            <?php endif; ?>
                        </div>
                    </div>


                </div>
            <?php endif; ?>
        </div>
    <?php endif; ?>

    
    
</div>

<?php $__env->startPush('scripts'); ?>
    <script>
        $.ready(function() {
            $(document).on('input', "#simpleSearchInput", function() {
                var value = $(this).val().toLowerCase();
                console.log("value", value)
                $("#simpleSearchTable tr").filter(function() {
                    $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
                });
            })
        })
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/u918047115/.tmp/unix/przo/po/bms/repo/resources/views/livewire/admin/product/zone-to-circle-stock-mover-component.blade.php ENDPATH**/ ?>