<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="card bg-blueGray-100">
        <div class="card-header">
            <div class="card-header-container">
                <h6 class="card-title">
                    <?php echo e(trans('global.view')); ?>

                    <?php echo e(trans('cruds.product.title_singular')); ?>:
                    <?php echo e(trans('cruds.product.fields.id')); ?>

                    <?php echo e($product->id); ?>

                </h6>
            </div>
        </div>

        <div class="card-body">
            <div class="pt-3">
                <table class="table table-view">
                    <tbody class="bg-white">
                        <tr>
                            <th>
                                <?php echo e(trans('cruds.product.fields.id')); ?>

                            </th>
                            <td>
                                <?php echo e($product->id); ?>

                            </td>
                        </tr>
                        <tr>
                            <th>
                                <?php echo e(trans('cruds.product.fields.name')); ?>

                            </th>
                            <td>
                                <?php echo e($product->name); ?>

                            </td>
                        </tr>
                        <tr>
                            <th>
                                <?php echo e(trans('cruds.product.fields.description')); ?>

                            </th>
                            <td>
                                <?php echo e($product->description); ?>

                            </td>
                        </tr>
                        <tr>
                            <th>
                                <?php echo e(trans('cruds.product.fields.category')); ?>

                            </th>
                            <td>
                                <?php $__currentLoopData = $product->category; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $entry): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <span class="badge badge-relationship"><?php echo e($entry->name); ?></span>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <?php echo e(trans('cruds.product.fields.tag')); ?>

                            </th>
                            <td>
                                <?php $__currentLoopData = $product->tag; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $entry): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <span class="badge badge-relationship"><?php echo e($entry->name); ?></span>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <?php echo e(trans('cruds.product.fields.photo')); ?>

                            </th>
                            <td>
                                <?php $__currentLoopData = $product->photo; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $entry): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <a class="link-photo" href="<?php echo e($entry['url']); ?>">
                                        <img src="<?php echo e($entry['preview_thumbnail']); ?>" alt="<?php echo e($entry['name']); ?>" title="<?php echo e($entry['name']); ?>">
                                    </a>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </td>
                        </tr>

                        <tr>
                            <th><?php echo e(trans('cruds.product.fields.hsn_code')); ?></th>
                            <td><?php echo e($product->hsn_code); ?></td>
                        </tr>
                        <tr>
                            <th><?php echo e(trans('cruds.product.fields.gst_rate')); ?></th>
                            <td><?php echo e($product->gst_rate); ?></td>
                        </tr>
                        <tr>
                            <th><?php echo e(trans('cruds.product.fields.cgst_rate')); ?></th>
                            <td><?php echo e($product->cgst_rate); ?></td>
                        </tr>
                        <tr>
                            <th><?php echo e(trans('cruds.product.fields.sgst_rate')); ?></th>
                            <td><?php echo e($product->sgst_rate); ?></td>
                        </tr>
                        <tr>
                            <th><?php echo e(trans('cruds.product.fields.igst_rate')); ?></th>
                            <td><?php echo e($product->igst_rate); ?></td>
                        </tr>
                        <tr>
                            <th><?php echo e(trans('cruds.product.fields.taxable_price')); ?></th>
                            <td><?php echo e($product->taxable_price); ?></td>
                        </tr>
                        <tr>
                            <th>
                                <?php echo e(trans('cruds.product.fields.price')); ?>

                            </th>
                            <td>
                                <?php echo e($product->price); ?>

                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="form-group">
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('product_edit')): ?>
                    <a href="<?php echo e(route('admin.products.edit', $product)); ?>" class="btn btn-indigo mr-2">
                        <?php echo e(trans('global.edit')); ?>

                    </a>
                <?php endif; ?>
                <a href="<?php echo e(route('admin.products.index')); ?>" class="btn btn-secondary">
                    <?php echo e(trans('global.back')); ?>

                </a>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u918047115/.tmp/unix/przo/po/bms/repo/resources/views/admin/product/show.blade.php ENDPATH**/ ?>