<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="card bg-blueGray-100">
        <div class="card-header">
            <div class="card-header-container">
                <h6 class="card-title">
                    <?php echo e(trans('global.view')); ?>

                    <?php echo e(trans('cruds.client.title_singular')); ?>:
                    <?php echo e(trans('cruds.client.fields.id')); ?>

                    <?php echo e($client->id); ?>

                </h6>
            </div>
        </div>

        <div class="card-body">
            <div class="pt-3">
                <table class="table table-view">
                    <tbody class="bg-white">
                        <tr>
                            <th>
                                <?php echo e(trans('cruds.client.fields.id')); ?>

                            </th>
                            <td>
                                <?php echo e($client->id); ?>

                            </td>
                        </tr>
                        <tr>
                            <th>
                                <?php echo e(trans('cruds.client.fields.client_group')); ?>

                            </th>
                            <td>
                                <?php if($client->clientGroup): ?>
                                    <span class="badge badge-relationship"><?php echo e($client->clientGroup->business_name ?? ''); ?></span>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <?php echo e(trans('cruds.client.fields.state')); ?>

                            </th>
                            <td>
                                <?php if($client->state): ?>
                                    <span class="badge badge-relationship"><?php echo e($client->state->name ?? ''); ?></span>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <?php echo e(trans('cruds.client.fields.name')); ?>

                            </th>
                            <td>
                                <?php echo e($client->name); ?>

                            </td>
                        </tr>
                        <tr>
                            <th>
                                <?php echo e(trans('cruds.client.fields.rhq_address')); ?>

                            </th>
                            <td>
                                <?php echo e($client->rhq_address); ?>

                            </td>
                        </tr>
                        <tr>
                            <th>
                                <?php echo e(trans('cruds.client.fields.rhq_phone')); ?>

                            </th>
                            <td>
                                <?php echo e($client->rhq_phone); ?>

                            </td>
                        </tr>
                        <tr>
                            <th>
                                <?php echo e(trans('cruds.client.fields.rhq_email')); ?>

                            </th>
                            <td>
                                <?php echo e($client->rhq_email); ?>

                            </td>
                        </tr>
                        <tr>
                            <th>
                                <?php echo e(trans('cruds.client.fields.gstin')); ?>

                            </th>
                            <td>
                                <?php echo e($client->gstin); ?>

                            </td>
                        </tr>
                        <tr>
                            <th>
                                <?php echo e(trans('cruds.client.fields.gst_reg_type')); ?>

                            </th>
                            <td>
                                <?php echo e($client->gst_reg_type_label); ?>

                            </td>
                        </tr>
                        <tr>
                            <th>
                                <?php echo e(trans('cruds.client.fields.is_active')); ?>

                            </th>
                            <td>
                                <input class="disabled:opacity-50 disabled:cursor-not-allowed" type="checkbox" disabled <?php echo e($client->is_active ? 'checked' : ''); ?>>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="form-group">
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('client_edit')): ?>
                    <a href="<?php echo e(route('admin.clients.edit', $client)); ?>" class="btn btn-indigo mr-2">
                        <?php echo e(trans('global.edit')); ?>

                    </a>
                <?php endif; ?>
                <a href="<?php echo e(route('admin.clients.index')); ?>" class="btn btn-secondary">
                    <?php echo e(trans('global.back')); ?>

                </a>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u918047115/.tmp/unix/przo/po/bms/repo/resources/views/admin/client/show.blade.php ENDPATH**/ ?>