<div>
    <section class="py-12 px-4 text-gray-600 body-font  h-6/5">
        <?php echo $__env->make('components.loading-spinner-full-page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <h2>Billing Details</h2>
        <form wire:submit.prevent="submit" class="pt-3">
            <div class="form-group <?php echo e($errors->has('task.is_invoiceable') ? 'invalid' : ''); ?>">
                <label class="form-label required" for="is_invoiceable">Is Invoiceable</label>
                <input type="checkbox" id="is_invoiceable" name="task.is_invoiceable" wire:model="task.is_invoiceable">
                <div class="validation-message">
                    <?php echo e($errors->first('task.is_invoiceable')); ?>

                </div>
                <div class="help-block"></div>
            </div>
            <div class="relative ">
                <?php if(!$task->is_invoiceable): ?>
                    <div class="absolute w-full h-full z-2000 bg-gray-500/25"></div>
                <?php endif; ?>
                <div class="p-1 grid gap-2 sm:grid-cols-1 md:grid-cols-3">
                    <div class="form-group <?php echo e($errors->has('task.igst_rate') ? 'invalid' : ''); ?>">
                        <label class="form-label required" for="igst_rate">IGST Rate</label>
                        <input type="number" class="form-control" id="igst_rate" name="task.igst_rate"
                            wire:model.debounce.600ms="task.igst_rate" pattern="\d+(\.\d{1,2})?">
                        <div class="validation-message">
                            <?php echo e($errors->first('task.igst_rate')); ?>

                        </div>
                        <div class="help-block"></div>
                    </div>

                    <div class="form-group <?php echo e($errors->has('task.amount_wo_gst') ? 'invalid' : ''); ?>">
                        <label class="form-label required" for="amount_wo_gst">Amount without GST</label>
                        <input type="number" class="form-control" id="amount_wo_gst" name="task.amount_wo_gst"
                            wire:model.debounce.600ms="task.amount_wo_gst" step="0.01" pattern="\d+(\.\d{1,2})?">
                        <div class="validation-message">
                            <?php echo e($errors->first('task.amount_wo_gst')); ?>

                        </div>
                        <div class="help-block"></div>
                    </div>
                    <div class="form-group <?php echo e($errors->has('task.amount_w_gst') ? 'invalid' : ''); ?>">
                        <label class="form-label required" for="amount_w_gst">Amount with GST</label>
                        <input type="number" class="form-control" id="amount_w_gst" name="task.amount_w_gst"
                            wire:model.debounce.600ms="task.amount_w_gst" step="0.01" pattern="\d+(\.\d{1,2})?">
                        <div class="validation-message">
                            <?php echo e($errors->first('task.amount_w_gst')); ?>

                        </div>
                        <div class="help-block"></div>
                    </div>

                    <div class="form-group col-span-3">
                        <table class="text-sm w-full">
                            <tr>
                                <th class="text-right w-[30%]">IGST %</th>
                                <td class="text-left w-[20%]"><?php echo e(number_format($task->igst_rate, 2)); ?></td>
                                <th class="text-right w-[30%]">IGST Amount</th>
                                <td class="text-left w-[20%]"><?php echo e(number_format($task->igst_amount, 2)); ?></td>
                            </tr>
                            <tr>
                                <th class="text-right w-[30%]">CGST %</th>
                                <td class="text-left w-[20%]"><?php echo e(number_format($task->cgst_rate, 2)); ?></td>
                                <th class="text-right w-[30%]">CGST Amount</th>
                                <td class="text-left w-[20%]"><?php echo e(number_format($task->cgst_amount, 2)); ?></td>
                            </tr>
                            <tr>
                                <th class="text-right w-[30%]">SGST %</th>
                                <td class="text-left w-[20%]"><?php echo e(number_format($task->sgst_rate, 2)); ?></td>
                                <th class="text-right w-[30%]">SGST Amount</th>
                                <td class="text-left w-[20%]"><?php echo e(number_format($task->sgst_amount, 2)); ?></td>
                            </tr>


                        </table>
                    </div>



                </div>
            </div>


            <div class="form-group">
                <button class="btn btn-indigo mr-2" type="submit">
                    <?php echo e(trans('global.save')); ?>

                </button>
                <a wire:click.prevent="cancel" class="btn btn-secondary">
                    <?php echo e(trans('global.cancel')); ?>

                </a>
            </div>
        </form>
        
        <script>
            window.select2IdsToUpdate.push({
                selectId: "status_id",
                property: "task.status_id",
                lw: () => window.livewire.find('<?php echo e($_instance->id); ?>'),
            });
        </script>
    </section>
</div>
<?php /**PATH /home/u918047115/.tmp/unix/przo/po/bms/repo/resources/views/livewire/task/task-billing-modal-component.blade.php ENDPATH**/ ?>