<div>
    <div class="card-controls sm:flex">
        <div class="w-full sm:w-1/2">
            Per page:
            <select wire:model="perPage" class="form-select w-full sm:w-1/6">
                <?php $__currentLoopData = $paginationOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($value); ?>"><?php echo e($value); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('ledger_lg_attribute_value_delete')): ?>
                <button class="btn btn-rose ml-3 disabled:opacity-50 disabled:cursor-not-allowed" type="button" wire:click="confirm('deleteSelected')" wire:loading.attr="disabled" <?php echo e($this->selectedCount ? '' : 'disabled'); ?>>
                    <?php echo e(__('Delete Selected')); ?>

                </button>
            <?php endif; ?>

            <?php if(file_exists(app_path('Http/Livewire/ExcelExport.php'))): ?>
                <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('excel-export', ['model' => 'LedgerLgAttributeValue','format' => 'csv'])->html();
} elseif ($_instance->childHasBeenRendered('jbjCqiK')) {
    $componentId = $_instance->getRenderedChildComponentId('jbjCqiK');
    $componentTag = $_instance->getRenderedChildComponentTagName('jbjCqiK');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('jbjCqiK');
} else {
    $response = \Livewire\Livewire::mount('excel-export', ['model' => 'LedgerLgAttributeValue','format' => 'csv']);
    $html = $response->html();
    $_instance->logRenderedChild('jbjCqiK', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
                <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('excel-export', ['model' => 'LedgerLgAttributeValue','format' => 'xlsx'])->html();
} elseif ($_instance->childHasBeenRendered('ZNEpwqt')) {
    $componentId = $_instance->getRenderedChildComponentId('ZNEpwqt');
    $componentTag = $_instance->getRenderedChildComponentTagName('ZNEpwqt');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('ZNEpwqt');
} else {
    $response = \Livewire\Livewire::mount('excel-export', ['model' => 'LedgerLgAttributeValue','format' => 'xlsx']);
    $html = $response->html();
    $_instance->logRenderedChild('ZNEpwqt', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
                <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('excel-export', ['model' => 'LedgerLgAttributeValue','format' => 'pdf'])->html();
} elseif ($_instance->childHasBeenRendered('oYvgpzn')) {
    $componentId = $_instance->getRenderedChildComponentId('oYvgpzn');
    $componentTag = $_instance->getRenderedChildComponentTagName('oYvgpzn');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('oYvgpzn');
} else {
    $response = \Livewire\Livewire::mount('excel-export', ['model' => 'LedgerLgAttributeValue','format' => 'pdf']);
    $html = $response->html();
    $_instance->logRenderedChild('oYvgpzn', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
            <?php endif; ?>




        </div>
        <div class="w-full sm:w-1/2 sm:text-right">
            Search:
            <input type="text" wire:model.debounce.300ms="search" class="w-full sm:w-1/3 inline-block" />
        </div>
    </div>
    <div wire:loading.delay>
        Loading...
    </div>

    <div class="overflow-hidden">
        <div class="overflow-x-auto">
            <table class="table table-index w-full">
                <thead>
                    <tr>
                        <th class="w-9">
                        </th>
                        <th class="w-28">
                            <?php echo e(trans('cruds.ledgerLgAttributeValue.fields.id')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'id'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.ledgerLgAttributeValue.fields.ledger')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'ledger.name'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.ledgerLgAttributeValue.fields.lg_attribute')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'lg_attribute.title'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.ledgerLgAttributeValue.fields.lg_attribute_value')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'lg_attribute_value.value'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.ledgerLgAttributeValue.fields.value_text')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'value_text'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                        </th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $ledgerLgAttributeValues; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ledgerLgAttributeValue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td>
                                <input type="checkbox" value="<?php echo e($ledgerLgAttributeValue->id); ?>" wire:model="selected">
                            </td>
                            <td>
                                <?php echo e($ledgerLgAttributeValue->id); ?>

                            </td>
                            <td>
                                <?php if($ledgerLgAttributeValue->ledger): ?>
                                    <span class="badge badge-relationship"><?php echo e($ledgerLgAttributeValue->ledger->name ?? ''); ?></span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($ledgerLgAttributeValue->lgAttribute): ?>
                                    <span class="badge badge-relationship"><?php echo e($ledgerLgAttributeValue->lgAttribute->title ?? ''); ?></span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($ledgerLgAttributeValue->lgAttributeValue): ?>
                                    <span class="badge badge-relationship"><?php echo e($ledgerLgAttributeValue->lgAttributeValue->value ?? ''); ?></span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php echo e($ledgerLgAttributeValue->value_text); ?>

                            </td>
                            <td>
                                <div class="flex justify-end">
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('ledger_lg_attribute_value_show')): ?>
                                        <a class="btn btn-sm btn-info mr-2" href="<?php echo e(route('admin.ledger-lg-attribute-values.show', $ledgerLgAttributeValue)); ?>">
                                            <?php echo e(trans('global.view')); ?>

                                        </a>
                                    <?php endif; ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('ledger_lg_attribute_value_edit')): ?>
                                        <a class="btn btn-sm btn-success mr-2" href="<?php echo e(route('admin.ledger-lg-attribute-values.edit', $ledgerLgAttributeValue)); ?>">
                                            <?php echo e(trans('global.edit')); ?>

                                        </a>
                                    <?php endif; ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('ledger_lg_attribute_value_delete')): ?>
                                        <button class="btn btn-sm btn-rose mr-2" type="button" wire:click="confirm('delete', <?php echo e($ledgerLgAttributeValue->id); ?>)" wire:loading.attr="disabled">
                                            <?php echo e(trans('global.delete')); ?>

                                        </button>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="10">No entries found.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <div class="card-body">
        <div class="pt-3">
            <?php if($this->selectedCount): ?>
                <p class="text-sm leading-5">
                    <span class="font-medium">
                        <?php echo e($this->selectedCount); ?>

                    </span>
                    <?php echo e(__('Entries selected')); ?>

                </p>
            <?php endif; ?>
            <?php echo e($ledgerLgAttributeValues->links()); ?>

        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
    <script>
        Livewire.on('confirm', e => {
    if (!confirm("<?php echo e(trans('global.areYouSure')); ?>")) {
        return
    }
window.livewire.find('<?php echo e($_instance->id); ?>')[e.callback](...e.argv)
})
    </script>
<?php $__env->stopPush(); ?><?php /**PATH /home/u918047115/.tmp/unix/przo/po/bms/repo/resources/views/livewire/ledger-lg-attribute-value/index.blade.php ENDPATH**/ ?>