<div>
    <div class="card-controls sm:flex">
        <div class="w-full sm:w-1/2">
            Per page:
            <select wire:model="perPage" class="form-select w-full sm:w-1/6">
                <?php $__currentLoopData = $paginationOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($value); ?>"><?php echo e($value); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('contact_contact_delete')): ?>
                <button class="btn btn-rose ml-3 disabled:opacity-50 disabled:cursor-not-allowed" type="button" wire:click="confirm('deleteSelected')" wire:loading.attr="disabled" <?php echo e($this->selectedCount ? '' : 'disabled'); ?>>
                    <?php echo e(__('Delete Selected')); ?>

                </button>
            <?php endif; ?>

            <?php if(file_exists(app_path('Http/Livewire/ExcelExport.php'))): ?>
                <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('excel-export', ['model' => 'ContactContact','format' => 'csv'])->html();
} elseif ($_instance->childHasBeenRendered('sX98GkI')) {
    $componentId = $_instance->getRenderedChildComponentId('sX98GkI');
    $componentTag = $_instance->getRenderedChildComponentTagName('sX98GkI');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('sX98GkI');
} else {
    $response = \Livewire\Livewire::mount('excel-export', ['model' => 'ContactContact','format' => 'csv']);
    $html = $response->html();
    $_instance->logRenderedChild('sX98GkI', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
                <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('excel-export', ['model' => 'ContactContact','format' => 'xlsx'])->html();
} elseif ($_instance->childHasBeenRendered('oZZrnGa')) {
    $componentId = $_instance->getRenderedChildComponentId('oZZrnGa');
    $componentTag = $_instance->getRenderedChildComponentTagName('oZZrnGa');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('oZZrnGa');
} else {
    $response = \Livewire\Livewire::mount('excel-export', ['model' => 'ContactContact','format' => 'xlsx']);
    $html = $response->html();
    $_instance->logRenderedChild('oZZrnGa', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
                <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('excel-export', ['model' => 'ContactContact','format' => 'pdf'])->html();
} elseif ($_instance->childHasBeenRendered('x6wpGRR')) {
    $componentId = $_instance->getRenderedChildComponentId('x6wpGRR');
    $componentTag = $_instance->getRenderedChildComponentTagName('x6wpGRR');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('x6wpGRR');
} else {
    $response = \Livewire\Livewire::mount('excel-export', ['model' => 'ContactContact','format' => 'pdf']);
    $html = $response->html();
    $_instance->logRenderedChild('x6wpGRR', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
            <?php endif; ?>




        </div>
        <div class="w-full sm:w-1/2 sm:text-right">
            Search:
            <input type="text" wire:model.debounce.300ms="search" class="w-full sm:w-1/3 inline-block" />
        </div>
    </div>
    <?php echo $__env->make('components.loading-spinner-full-page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


    <div class="overflow-hidden">
        <div class="overflow-x-auto">
            <table class="table table-index w-full">
                <thead>
                    <tr>
                        <th class="w-9">
                        </th>
                        <th class="w-28">
                            <?php echo e(trans('cruds.contactContact.fields.id')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'id'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.contactContact.fields.company')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'company.company_name'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.contactContact.fields.contact_first_name')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'contact_first_name'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.contactContact.fields.contact_last_name')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'contact_last_name'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.contactContact.fields.contact_phone_1')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'contact_phone_1'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.contactContact.fields.contact_phone_2')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'contact_phone_2'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.contactContact.fields.contact_email')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'contact_email'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.contactContact.fields.contact_skype')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'contact_skype'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                            <?php echo e(trans('cruds.contactContact.fields.contact_address')); ?>

                            <?php echo $__env->make('components.table.sort', ['field' => 'contact_address'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </th>
                        <th>
                        </th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $contactContacts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $contactContact): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td>
                                <input type="checkbox" value="<?php echo e($contactContact->id); ?>" wire:model="selected">
                            </td>
                            <td>
                                <?php echo e($contactContact->id); ?>

                            </td>
                            <td>
                                <?php if($contactContact->company): ?>
                                    <span class="badge badge-relationship"><?php echo e($contactContact->company->company_name ?? ''); ?></span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php echo e($contactContact->contact_first_name); ?>

                            </td>
                            <td>
                                <?php echo e($contactContact->contact_last_name); ?>

                            </td>
                            <td>
                                <?php echo e($contactContact->contact_phone_1); ?>

                            </td>
                            <td>
                                <?php echo e($contactContact->contact_phone_2); ?>

                            </td>
                            <td>
                                <?php echo e($contactContact->contact_email); ?>

                            </td>
                            <td>
                                <?php echo e($contactContact->contact_skype); ?>

                            </td>
                            <td>
                                <?php echo e($contactContact->contact_address); ?>

                            </td>
                            <td>
                                <div class="flex justify-end">
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('contact_contact_show')): ?>
                                        <a class="btn btn-sm btn-info mr-2" href="<?php echo e(route('admin.contact-contacts.show', $contactContact)); ?>">
                                            <?php echo e(trans('global.view')); ?>

                                        </a>
                                    <?php endif; ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('contact_contact_edit')): ?>
                                        <a class="btn btn-sm btn-success mr-2" href="<?php echo e(route('admin.contact-contacts.edit', $contactContact)); ?>">
                                            <?php echo e(trans('global.edit')); ?>

                                        </a>
                                    <?php endif; ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('contact_contact_delete')): ?>
                                        <button class="btn btn-sm btn-rose mr-2" type="button" wire:click="confirm('delete', <?php echo e($contactContact->id); ?>)" wire:loading.attr="disabled">
                                            <?php echo e(trans('global.delete')); ?>

                                        </button>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="10">No entries found.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <div class="card-body">
        <div class="pt-3">
            <?php if($this->selectedCount): ?>
                <p class="text-sm leading-5">
                    <span class="font-medium">
                        <?php echo e($this->selectedCount); ?>

                    </span>
                    <?php echo e(__('Entries selected')); ?>

                </p>
            <?php endif; ?>
            <?php echo e($contactContacts->links()); ?>

        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
    <script>
        Livewire.on('confirm', e => {
    if (!confirm("<?php echo e(trans('global.areYouSure')); ?>")) {
        return
    }
window.livewire.find('<?php echo e($_instance->id); ?>')[e.callback](...e.argv)
})
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/u918047115/.tmp/unix/przo/po/bms/repo/resources/views/livewire/contact-contact/index.blade.php ENDPATH**/ ?>