<div class="row">
    <div class="card bg-blueGray-100">
        <div class="card-header">
            <div class="card-header-container">
                <h6 class="card-title">
                    <?php echo e(trans('global.view')); ?>

                    <?php echo e(trans('cruds.visitReimbursement.title_singular')); ?>:
                    <?php echo e(trans('cruds.visitReimbursement.fields.id')); ?>

                    <?php echo e($visitReimbursement->id); ?>

                </h6>
            </div>
        </div>

        <div class="card-body">
            <div class="pt-3">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-1">
                    <div>

                        <table class="table table-view">
                            <tbody class="bg-white">
                                <tr>
                                    <th>
                                        <?php echo e(trans('cruds.visitReimbursement.fields.id')); ?>

                                    </th>
                                    <td>
                                        <?php echo e($visitReimbursement->id); ?>

                                    </td>
                                </tr>
                                <tr>
                                    <th>
                                        <?php echo e(trans('cruds.visitReimbursement.fields.user')); ?>

                                    </th>
                                    <td>
                                        <?php if($visitReimbursement->user): ?>
                                            <span
                                                class="badge badge-relationship"><?php echo e($visitReimbursement->user->name ?? ''); ?></span>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <tr>
                                    <th>
                                        <?php echo e(trans('cruds.visitReimbursement.fields.task')); ?>

                                    </th>
                                    <td>
                                        <?php if($visitReimbursement->task): ?>
                                            <span
                                                class="badge badge-relationship"><?php echo e($visitReimbursement->task->name ?? ''); ?></span>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <tr>
                                    <th>
                                        <?php echo e(trans('cruds.visitReimbursement.fields.approved_by')); ?>

                                    </th>
                                    <td>
                                        <?php if($visitReimbursement->approvedBy): ?>
                                            <span
                                                class="badge badge-relationship"><?php echo e($visitReimbursement->approvedBy->name ?? ''); ?></span>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <tr>
                                    <th>
                                        <?php echo e(trans('cruds.visitReimbursement.fields.approved_at')); ?>

                                    </th>
                                    <td>
                                        <?php echo e($visitReimbursement->approved_at); ?>

                                    </td>
                                </tr>
                                <tr>
                                    <th>
                                        <?php echo e(trans('cruds.visitReimbursement.fields.amount')); ?>

                                    </th>
                                    <td>
                                        <?php echo e($visitReimbursement->amount); ?>

                                    </td>
                                </tr>
                                <tr>
                                    <th>
                                        <?php echo e(trans('cruds.visitReimbursement.fields.visit')); ?>

                                    </th>
                                    <td>
                                        <?php if($visitReimbursement->visit): ?>
                                            <span
                                                class="badge badge-relationship"><?php echo e($visitReimbursement->visit->date ?? ''); ?></span>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <tr>
                                    <th>
                                        <?php echo e(trans('cruds.visitReimbursement.fields.status')); ?>

                                    </th>
                                    <td>
                                        <?php echo e($visitReimbursement->status_label); ?>

                                    </td>
                                </tr>
                            </tbody>

                        </table>
                    </div>
                    <div class="p-1">
                        <table class="table table-bordered w-full table-fixed">
                            <caption>Routes</caption>
                            <thead>
                                <tr>
                                    <th class="!text-center p-1 !bg-gray-300/25">From</th>
                                    <th class="!text-center p-1 !bg-gray-300/25">To</th>
                                    <th class="!text-center p-1 !bg-gray-300/25">Transport <br>Mode</th>
                                    <th class="!text-center p-1 !bg-gray-300/25">Journe <br>Type</th>
                                    <th class="!text-center p-1 !bg-gray-300/25">Distance <br>(in Km)</th>
                                    <th class="!text-center p-1 !bg-gray-300/25">Rate</th>
                                    <th class="!text-center p-1 !bg-gray-300/25">Amount</th>
                                    <th class="!text-center p-1 !bg-gray-300/25">Note</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $visitReimbursement->routes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $route): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td class="capitalize p-1"><?php echo e($route->from); ?></td>
                                        <td class="capitalize p-1"><?php echo e($route->to); ?></td>
                                        <td class="capitalize p-1"><?php echo e($route->vehicle_type); ?></td>
                                        <td class="capitalize p-1"><?php echo e($route->journey_type); ?></td>
                                        <td class="capitalize p-1"><?php echo e($route->journey_distance); ?></td>
                                        <td class="capitalize p-1"><?php echo e($route->journey_fare); ?></td>
                                        <td class="capitalize p-1"><?php echo e($route->route_cost); ?></td>
                                        <td class="capitalize p-1"><?php echo e($route->note); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </table>
                    </div>

                </div>
            </div>
            <div class="form-group">
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('visit_reimbursement_edit')): ?>
                    <a href="<?php echo e(route('admin.visit-reimbursements.edit', $visitReimbursement)); ?>"
                        class="btn btn-indigo mr-2">
                        <?php echo e(trans('global.edit')); ?>

                    </a>
                <?php endif; ?>
                <a href="javascript:void(0)"
                    onclick="Livewire.emit('openModal','admin.visit-reimbursement.status-change-component',
                            <?php echo e(json_encode(['id' => $visitReimbursement->id])); ?>)"
                    class="btn btn-indigo mr-2">
                    Status Change
                </a>
                <a href="<?php echo e(route('admin.visit-reimbursements.index')); ?>" class="btn btn-secondary">
                    <?php echo e(trans('global.back')); ?>

                </a>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/u918047115/.tmp/unix/przo/po/bms/repo/resources/views/livewire/admin/visit-reimbursement/show.blade.php ENDPATH**/ ?>