<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="card bg-blueGray-100">
        <div class="card-header">
            <div class="card-header-container">
                <h6 class="card-title">
                    <?php echo e(trans('global.view')); ?>

                    <?php echo e(trans('cruds.employeeFamilyDetail.title_singular')); ?>:
                    <?php echo e(trans('cruds.employeeFamilyDetail.fields.id')); ?>

                    <?php echo e($employeeFamilyDetail->id); ?>

                </h6>
            </div>
        </div>

        <div class="card-body">
            <div class="pt-3">
                <table class="table table-view">
                    <tbody class="bg-white">
                        <tr>
                            <th>
                                <?php echo e(trans('cruds.employeeFamilyDetail.fields.id')); ?>

                            </th>
                            <td>
                                <?php echo e($employeeFamilyDetail->id); ?>

                            </td>
                        </tr>
                        <tr>
                            <th>
                                <?php echo e(trans('cruds.employeeFamilyDetail.fields.employee_info')); ?>

                            </th>
                            <td>
                                <?php if($employeeFamilyDetail->employeeInfo): ?>
                                    <span class="badge badge-relationship"><?php echo e($employeeFamilyDetail->employeeInfo->first_name ?? ''); ?></span>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <?php echo e(trans('cruds.employeeFamilyDetail.fields.relation')); ?>

                            </th>
                            <td>
                                <?php echo e($employeeFamilyDetail->relation_label); ?>

                            </td>
                        </tr>
                        <tr>
                            <th>
                                <?php echo e(trans('cruds.employeeFamilyDetail.fields.name')); ?>

                            </th>
                            <td>
                                <?php echo e($employeeFamilyDetail->name); ?>

                            </td>
                        </tr>
                        <tr>
                            <th>
                                <?php echo e(trans('cruds.employeeFamilyDetail.fields.is_dependent')); ?>

                            </th>
                            <td>
                                <input class="disabled:opacity-50 disabled:cursor-not-allowed" type="checkbox" disabled <?php echo e($employeeFamilyDetail->is_dependent ? 'checked' : ''); ?>>
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <?php echo e(trans('cruds.employeeFamilyDetail.fields.profession')); ?>

                            </th>
                            <td>
                                <?php echo e($employeeFamilyDetail->profession); ?>

                            </td>
                        </tr>
                        <tr>
                            <th>
                                <?php echo e(trans('cruds.employeeFamilyDetail.fields.office_name_address')); ?>

                            </th>
                            <td>
                                <?php echo e($employeeFamilyDetail->office_name_address); ?>

                            </td>
                        </tr>
                        <tr>
                            <th>
                                <?php echo e(trans('cruds.employeeFamilyDetail.fields.office_contact')); ?>

                            </th>
                            <td>
                                <?php echo e($employeeFamilyDetail->office_contact); ?>

                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="form-group">
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('employee_family_detail_edit')): ?>
                    <a href="<?php echo e(route('admin.employee-family-details.edit', $employeeFamilyDetail)); ?>" class="btn btn-indigo mr-2">
                        <?php echo e(trans('global.edit')); ?>

                    </a>
                <?php endif; ?>
                <a href="<?php echo e(route('admin.employee-family-details.index')); ?>" class="btn btn-secondary">
                    <?php echo e(trans('global.back')); ?>

                </a>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u918047115/.tmp/unix/przo/po/bms/repo/resources/views/admin/employee-family-detail/show.blade.php ENDPATH**/ ?>