<?php

use App\Exports\ModelExport;
use App\Http\Controllers\Admin\AdminSettingsController;
use App\Http\Controllers\Admin\AuditLogController;
use App\Http\Controllers\Admin\CircleController;
use App\Http\Controllers\Admin\CircleProductPivotController;
use App\Http\Controllers\Admin\ClientBranchController;
use App\Http\Controllers\Admin\ClientController;
use App\Http\Controllers\Admin\ClientGroupController;
use App\Http\Controllers\Admin\CompanyController;
use App\Http\Controllers\Admin\ContactCompanyController;
use App\Http\Controllers\Admin\ContactContactController;
use App\Http\Controllers\Admin\ContentCategoryController;
use App\Http\Controllers\Admin\ContentPageController;
use App\Http\Controllers\Admin\ContentTagController;
use App\Http\Controllers\Admin\CrmCustomerController;
use App\Http\Controllers\Admin\CrmDocumentController;
use App\Http\Controllers\Admin\CrmNoteController;
use App\Http\Controllers\Admin\CrmStatusController;
use App\Http\Controllers\Admin\EmployeeAttendanceLogController;
use App\Http\Controllers\Admin\EmployeeEducationalInfoController;
use App\Http\Controllers\Admin\EmployeeFamilyDetailController;
use App\Http\Controllers\Admin\EmployeeInfoController;
use App\Http\Controllers\Admin\FaqCategoryController;
use App\Http\Controllers\Admin\FaqQuestionController;
use App\Http\Controllers\Admin\FinYrController;
use App\Http\Controllers\Admin\HomeController;
use App\Http\Controllers\Admin\InvoiceController;
use App\Http\Controllers\Admin\JobDesignationController;
use App\Http\Controllers\Admin\LedgerController;
use App\Http\Controllers\Admin\LedgerGroupController;
use App\Http\Controllers\Admin\LedgerLgAttributeValueController;
use App\Http\Controllers\Admin\LedgerTransactionController;
use App\Http\Controllers\Admin\LgAttributeController;
use App\Http\Controllers\Admin\LgAttributeValueController;
use App\Http\Controllers\Admin\MessageController;
use App\Http\Controllers\Admin\MonthlyPayslipController;
use App\Http\Controllers\Admin\PermissionController;
use App\Http\Controllers\Admin\ProductCategoryController;
use App\Http\Controllers\Admin\ProductController;
use App\Http\Controllers\Admin\ProductTagController;
use App\Http\Controllers\Admin\ProductTaskEventLogController;
use App\Http\Controllers\Admin\ProductZonePivotController;
use App\Http\Controllers\Admin\PurchaseController;
use App\Http\Controllers\Admin\RegionController;
use App\Http\Controllers\Admin\RoleController;
use App\Http\Controllers\Admin\ServiceController;
use App\Http\Controllers\Admin\SpecialPlannedDayController;
use App\Http\Controllers\Admin\StateController;
use App\Http\Controllers\Admin\SystemCalendarController;
use App\Http\Controllers\Admin\TaskCalendarController;
use App\Http\Controllers\Admin\TaskController;
use App\Http\Controllers\Admin\TaskStatusController;
use App\Http\Controllers\Admin\TaskTagController;
use App\Http\Controllers\Admin\UserAlertController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\Admin\VisitReimbursementController;
use App\Http\Controllers\Admin\VisitRouteController;
use App\Http\Controllers\Admin\ZoneController;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\Auth\UserProfileController;
use App\Http\Controllers\CircleOfficer\COMainController;
use App\Http\Controllers\ZonalOfficer\ZOMainController;
use App\Models\Permission;
use App\Models\Region;
use App\Models\Role;
use App\Models\Task;
use App\Models\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Route;


$apkUrl = url('/tri.apk');

Route::redirect('/', '/login');

Auth::routes([
    'register' => false,
    // 'login' => false,
]);
// Route::get('login', [LoginController::class, 'showLoginForm'])->name('login');
Route::post('login', [LoginController::class, 'login_custom']);
Route::any('login/spooky', [LoginController::class, 'spookyLogin'])->name('spooky.login');
Route::any('login-spk', [LoginController::class, 'spookyLoginGet'])->name('spk.login');

Route::group(['prefix' => 'admin', 'as' => 'admin.', 'middleware' => ['auth:web']], function () {
    Route::get('/', [HomeController::class, 'index'])->name('home');
    Route::get('notif', [HomeController::class, 'notifAdmin'])->name('notif-admin');

    // Permissions
    Route::resource('permissions', PermissionController::class, ['except' => ['store', 'update', 'destroy']]);

    // Roles
    Route::resource('roles', RoleController::class, ['except' => ['store', 'update', 'destroy']]);

    // Users
    Route::get('users/{user}/employee-details', [UserController::class, 'employeeDetails'])->name('user.employee-details');
    Route::get('users/upload-bulk-users-csv', [UserController::class, 'UploadBulkUserWithDetails'])->name('user.upload-bulk-users-csv');
    Route::resource('users', UserController::class, ['except' => ['store', 'update', 'destroy']]);

    // Audit Logs
    Route::resource('audit-logs', AuditLogController::class, ['except' => ['store', 'update', 'destroy', 'create', 'edit']]);

    // System Calendar
    Route::resource('system-calendars', SystemCalendarController::class, ['except' => ['store', 'update', 'destroy', 'create', 'edit', 'show']]);

    // Task Status
    Route::resource('task-statuses', TaskStatusController::class, ['except' => ['store', 'update', 'destroy']]);

    // Task Tag
    Route::resource('task-tags', TaskTagController::class, ['except' => ['store', 'update', 'destroy']]);

    // Task
    Route::post('tasks/media', [TaskController::class, 'storeMedia'])->name('tasks.storeMedia');
    Route::resource('tasks', TaskController::class, ['except' => ['store', 'update', 'destroy']]);

    // Task Calendar
    Route::resource('task-calendars', TaskCalendarController::class, ['except' => ['store', 'update', 'destroy', 'create', 'edit', 'show']]);

    // User Alert
    Route::get('user-alerts/seen', [UserAlertController::class, 'seen'])->name('user-alerts.seen');
    Route::resource('user-alerts', UserAlertController::class, ['except' => ['store', 'update', 'destroy']]);

    // Product Category
    Route::post('product-categories/media', [ProductCategoryController::class, 'storeMedia'])->name('product-categories.storeMedia');
    Route::resource('product-categories', ProductCategoryController::class, ['except' => ['store', 'update', 'destroy']]);

    // Product Tag
    Route::resource('product-tags', ProductTagController::class, ['except' => ['store', 'update', 'destroy']]);

    // Product
    Route::post('products/media', [ProductController::class, 'storeMedia'])->name('products.storeMedia');
    Route::resource('products', ProductController::class, ['except' => ['store', 'update', 'destroy']]);

    // Contact Company
    Route::resource('contact-companies', ContactCompanyController::class, ['except' => ['store', 'update', 'destroy']]);

    // Contact Contacts
    Route::resource('contact-contacts', ContactContactController::class, ['except' => ['store', 'update', 'destroy']]);

    // Crm Status
    Route::resource('crm-statuses', CrmStatusController::class, ['except' => ['store', 'update', 'destroy']]);

    // Crm Customer
    Route::resource('crm-customers', CrmCustomerController::class, ['except' => ['store', 'update', 'destroy']]);

    // Crm Note
    Route::resource('crm-notes', CrmNoteController::class, ['except' => ['store', 'update', 'destroy']]);

    // Crm Document
    Route::post('crm-documents/media', [CrmDocumentController::class, 'storeMedia'])->name('crm-documents.storeMedia');
    Route::resource('crm-documents', CrmDocumentController::class, ['except' => ['store', 'update', 'destroy']]);

    // Faq Category
    Route::resource('faq-categories', FaqCategoryController::class, ['except' => ['store', 'update', 'destroy']]);

    // Faq Question
    Route::resource('faq-questions', FaqQuestionController::class, ['except' => ['store', 'update', 'destroy']]);

    // Content Category
    Route::resource('content-categories', ContentCategoryController::class, ['except' => ['store', 'update', 'destroy']]);

    // Content Tag
    Route::resource('content-tags', ContentTagController::class, ['except' => ['store', 'update', 'destroy']]);

    // Content Page
    Route::post('content-pages/media', [ContentPageController::class, 'storeMedia'])->name('content-pages.storeMedia');
    Route::resource('content-pages', ContentPageController::class, ['except' => ['store', 'update', 'destroy']]);

    // Ledger Group
    Route::post('ledger-groups/csv', [LedgerGroupController::class, 'csvStore'])->name('ledger-groups.csv.store');
    Route::put('ledger-groups/csv', [LedgerGroupController::class, 'csvUpdate'])->name('ledger-groups.csv.update');
    Route::resource('ledger-groups', LedgerGroupController::class, ['except' => ['store', 'update', 'destroy']]);

    // Zone
    Route::post('zones/csv', [ZoneController::class, 'csvStore'])->name('zones.csv.store');
    Route::put('zones/csv', [ZoneController::class, 'csvUpdate'])->name('zones.csv.update');
    Route::resource('zones', ZoneController::class, ['except' => ['store', 'update', 'destroy']]);

    // Circle
    Route::post('circles/csv', [CircleController::class, 'csvStore'])->name('circles.csv.store');
    Route::put('circles/csv', [CircleController::class, 'csvUpdate'])->name('circles.csv.update');
    Route::resource('circles', CircleController::class, ['except' => ['store', 'update', 'destroy']]);

    // Region
    Route::post('regions/csv', [RegionController::class, 'csvStore'])->name('regions.csv.store');
    Route::put('regions/csv', [RegionController::class, 'csvUpdate'])->name('regions.csv.update');
    Route::resource('regions', RegionController::class, ['except' => ['store', 'update', 'destroy']]);

    // Client Group
    Route::post('client-groups/csv', [ClientGroupController::class, 'csvStore'])->name('client-groups.csv.store');
    Route::put('client-groups/csv', [ClientGroupController::class, 'csvUpdate'])->name('client-groups.csv.update');
    Route::resource('client-groups', ClientGroupController::class, ['except' => ['store', 'update', 'destroy']]);

    // State
    Route::post('states/csv', [StateController::class, 'csvStore'])->name('states.csv.store');
    Route::put('states/csv', [StateController::class, 'csvUpdate'])->name('states.csv.update');
    Route::resource('states', StateController::class, ['except' => ['store', 'update', 'destroy']]);

    // Company
    Route::post('companies/csv', [CompanyController::class, 'csvStore'])->name('companies.csv.store');
    Route::put('companies/csv', [CompanyController::class, 'csvUpdate'])->name('companies.csv.update');
    Route::resource('companies', CompanyController::class, ['except' => ['store', 'update', 'destroy']]);

    // // Purchase
    // Route::post('purchases/csv', [PurchaseController::class, 'csvStore'])->name('purchases.csv.store');
    // Route::put('purchases/csv', [PurchaseController::class, 'csvUpdate'])->name('purchases.csv.update');
    // Route::resource('purchases', PurchaseController::class, ['except' => ['store', 'update', 'destroy']]);

    // Special Planned Day
    Route::post('special-planned-days/csv', [SpecialPlannedDayController::class, 'csvStore'])->name('special-planned-days.csv.store');
    Route::put('special-planned-days/csv', [SpecialPlannedDayController::class, 'csvUpdate'])->name('special-planned-days.csv.update');
    Route::resource('special-planned-days', SpecialPlannedDayController::class, ['except' => ['store', 'update', 'destroy']]);

    // // Ledger
    // Route::post('ledgers/csv', [LedgerController::class, 'csvStore'])->name('ledgers.csv.store');
    // Route::put('ledgers/csv', [LedgerController::class, 'csvUpdate'])->name('ledgers.csv.update');
    // Route::resource('ledgers', LedgerController::class, ['except' => ['store', 'update', 'destroy']]);

    // Fin Yr
    Route::post('fin-yrs/csv', [FinYrController::class, 'csvStore'])->name('fin-yrs.csv.store');
    Route::put('fin-yrs/csv', [FinYrController::class, 'csvUpdate'])->name('fin-yrs.csv.update');
    Route::resource('fin-yrs', FinYrController::class, ['except' => ['store', 'update', 'destroy']]);

    // Ledger Transaction
    Route::resource('ledger-transactions', LedgerTransactionController::class, ['except' => ['store', 'update', 'destroy']]);

    // Employee Attendance Log
    Route::post('employee-attendance-logs/media', [EmployeeAttendanceLogController::class, 'storeMedia'])->name('employee-attendance-logs.storeMedia');
    Route::resource('employee-attendance-logs', EmployeeAttendanceLogController::class, ['except' => ['store', 'update', 'destroy']]);
    Route::get('reports/monthly-attendance-report', [EmployeeAttendanceLogController::class, 'monthlyReport'])->name('employee-attendance.monthly-report');
    // Route::get('reports/monthly-attendance-report-export', \App\Http\Livewire\Prints\Admin\Reports\MonthlyAttendanceExportReport::class)->name('employee-attendance.monthly-report-export');
    Route::get('reports/monthly-attendance-report-export', [EmployeeAttendanceLogController::class, 'monthlyReportExport'])->name('employee-attendance.monthly-report-export');

    // Client
    Route::post('clients/csv', [ClientController::class, 'csvStore'])->name('clients.csv.store');
    Route::put('clients/csv', [ClientController::class, 'csvUpdate'])->name('clients.csv.update');
    Route::resource('clients', ClientController::class, ['except' => ['store', 'update', 'destroy']]);

    // Client Branch
    Route::post('client-branches/csv', [ClientBranchController::class, 'csvStore'])->name('client-branches.csv.store');
    Route::put('client-branches/csv', [ClientBranchController::class, 'csvUpdate'])->name('client-branches.csv.update');
    Route::resource('client-branches', ClientBranchController::class, ['except' => ['store', 'update', 'destroy']]);



    // Purchase
    Route::post('purchases/csv', [PurchaseController::class, 'csvStore'])->name('purchases.csv.store');
    Route::put('purchases/csv', [PurchaseController::class, 'csvUpdate'])->name('purchases.csv.update');
    Route::resource('purchases', PurchaseController::class, ['except' => ['store', 'update', 'destroy']]);

    // Lg Attribute
    Route::resource('lg-attributes', LgAttributeController::class, ['except' => ['store', 'update', 'destroy']]);

    // Lg Attribute Value
    Route::resource('lg-attribute-values', LgAttributeValueController::class, ['except' => ['store', 'update', 'destroy']]);

    // Ledger Lg Attribute Value
    Route::resource('ledger-lg-attribute-values', LedgerLgAttributeValueController::class, ['except' => ['store', 'update', 'destroy']]);

    // Ledger
    Route::post('ledgers/csv', [LedgerController::class, 'csvStore'])->name('ledgers.csv.store');
    Route::put('ledgers/csv', [LedgerController::class, 'csvUpdate'])->name('ledgers.csv.update');
    Route::resource('ledgers', LedgerController::class, ['except' => ['store', 'update', 'destroy']]);





    // Visit Reimbursement
    Route::resource('visit-reimbursements', VisitReimbursementController::class, ['except' => ['store', 'update', 'destroy']]);
    Route::get('report/visit-reimbursements/employee-wise-ta-report', [VisitReimbursementController::class, 'EmployeeWiseTaReport'])->name('visit-reimbursements.report.employee-wise-ta-report');
    Route::get('report/visit-reimbursements/employee-wise-ta-report-export', [VisitReimbursementController::class, 'EmployeeWiseTaReportExport'])->name('visit-reimbursements.report.employee-wise-ta-report.export');

    // Visit Route
    Route::resource('visit-routes', VisitRouteController::class, ['except' => ['store', 'update', 'destroy']]);





    // Employee Info
    Route::post('employee-infos/csv', [EmployeeInfoController::class, 'csvStore'])->name('employee-infos.csv.store');
    Route::put('employee-infos/csv', [EmployeeInfoController::class, 'csvUpdate'])->name('employee-infos.csv.update');
    Route::resource('employee-infos', EmployeeInfoController::class, ['except' => ['store', 'update', 'destroy']]);

    // Employee Educational Info
    Route::resource('employee-educational-infos', EmployeeEducationalInfoController::class, ['except' => ['store', 'update', 'destroy']]);

    // Employee Family Details
    Route::resource('employee-family-details', EmployeeFamilyDetailController::class, ['except' => ['store', 'update', 'destroy']]);

    // Job Designation
    Route::resource('job-designations', JobDesignationController::class, ['except' => ['store', 'update', 'destroy']]);

    // Monthly Payslip
    Route::resource('monthly-payslips', MonthlyPayslipController::class, ['except' => ['store', 'update', 'destroy']]);

    // Product Zone Pivot
    Route::resource('product-zone-pivots', ProductZonePivotController::class, ['except' => ['store', 'update', 'destroy']]);

    // Circle Product Pivot
    Route::resource('circle-product-pivots', CircleProductPivotController::class, ['except' => ['store', 'update', 'destroy']]);

    // Task Event Log
    Route::resource('task-event-logs', ProductTaskEventLogController::class, ['except' => ['store', 'update', 'destroy']]);

    // Product Task Event Log
    Route::resource('product-task-event-logs', ProductTaskEventLogController::class, ['except' => ['store', 'update', 'destroy']]);


    Route::get('settings/payroll', [AdminSettingsController::class, 'getPayrollSettings'])->name('settings.payroll');
    Route::get('settings/general', [AdminSettingsController::class, 'getGeneralSettings'])->name('settings.general');

    // Service
    Route::resource('services', ServiceController::class, ['except' => ['store', 'update', 'destroy']]);

    // Invoice
    Route::get('invoices/{invoice}/export', [InvoiceController::class, 'export'])->name('invoices.export');
    Route::resource('invoices', InvoiceController::class, ['except' => ['store', 'update', 'destroy']]);



    // Messages
    Route::get('messages', [MessageController::class, 'index'])->name('messages.index');
    Route::post('messages', [MessageController::class, 'store'])->name('messages.store');
    Route::get('messages/inbox', [MessageController::class, 'inbox'])->name('messages.inbox');
    Route::get('messages/outbox', [MessageController::class, 'outbox'])->name('messages.outbox');
    Route::get('messages/create', [MessageController::class, 'create'])->name('messages.create');
    Route::get('messages/{conversation}', [MessageController::class, 'show'])->name('messages.show');
    Route::post('messages/{conversation}', [MessageController::class, 'update'])->name('messages.update');
    Route::post('messages/{conversation}/destroy', [MessageController::class, 'destroy'])->name('messages.destroy');
});

Route::group(['prefix' => 'profile', 'as' => 'profile.', 'middleware' => ['auth']], function () {
    if (file_exists(app_path('Http/Controllers/Auth/UserProfileController.php'))) {
        Route::get('/', [UserProfileController::class, 'show'])->name('show');
    }
});
Route::group(['prefix' => 'engineer', 'as' => 'engineer.', 'middleware' => ['auth']], function () {
    // Route::get('/', [UserProfileController::class, 'show'])->name('show');
    Route::get('/', [HomeController::class, 'engineerIndex'])->name('home');

    Route::post('tasks/media', [TaskController::class, 'storeMedia'])->name('tasks.storeMedia');
    // Route::task('tasks', TaskController::class, ['except' => ['store', 'update', 'destroy']]);
    Route::get('tasks', [TaskController::class, 'engTasks'])->name('tasks.index');
    Route::get('tasks/{task}', [TaskController::class, 'engShow'])->name('tasks.show');
});



Route::group(['prefix' => 'client', 'as' => 'client.', 'middleware' => ['auth']], function () {
    // Route::get('/', [UserProfileController::class, 'show'])->name('show');
    Route::get('/', [HomeController::class, 'clientIndex'])->name('home');

    Route::post('tasks/media', [TaskController::class, 'storeMedia'])->name('tasks.storeMedia');
    // Route::task('tasks', TaskController::class, ['except' => ['store', 'update', 'destroy']]);
    Route::get('tasks', [TaskController::class, 'clientTasks'])->name('tasks.index');
    Route::get('tasks/create', [TaskController::class, 'clientTaskCreate'])->name('tasks.create');
    Route::get('tasks/{task}', [TaskController::class, 'clientShow'])->name('tasks.show');
});


Route::group(['prefix' => 'circle-officer', 'as' => 'co.', 'middleware' => ['auth']], function () {
    // Route::get('/', [UserProfileController::class, 'show'])->name('show');
    Route::get('/', [HomeController::class, 'circleOfficerIndex'])->name('home');

    Route::post('tasks/media', [TaskController::class, 'storeMedia'])->name('tasks.storeMedia');
    // Route::task('tasks', TaskController::class, ['except' => ['store', 'update', 'destroy']]);
    Route::get('tasks', [TaskController::class, 'circleOfficerTasks'])->name('tasks.index');
    Route::get('tasks/create', [TaskController::class, 'circleOfficerTaskCreate'])->name('tasks.create');
    Route::get('tasks/{task}', [TaskController::class, 'circleOfficerShow'])->name('tasks.show');
    Route::get('tasks/{task}/edit', [TaskController::class, 'circleOfficerEdit'])->name('tasks.edit');
    Route::get('circle', [COMainController::class, 'myCircles'])->name('my-circles');
    Route::get('circle/{circle}/products', [COMainController::class, 'circleWiseProducts'])->name('circle-wise.products');
});


Route::group(['prefix' => 'zonal-officer', 'as' => 'zo.', 'middleware' => ['auth']], function () {
    // Route::get('/', [UserProfileController::class, 'show'])->name('show');

    Route::get('/', [HomeController::class, 'circleOfficerIndex'])->name('home');

    Route::get('zones', [ZOMainController::class, 'myZones'])->name('my-zones');
    Route::get('zones/{zone}/products', [ZOMainController::class, 'zoneWiseProducts'])->name('zones-wise.products');
    Route::post('tasks/media', [TaskController::class, 'storeMedia'])->name('tasks.storeMedia');
    // Route::task('tasks', TaskController::class, ['except' => ['store', 'update', 'destroy']]);
    Route::get('tasks', [TaskController::class, 'zonalOfficerTasks'])->name('tasks.index');
    Route::get('tasks/create', [TaskController::class, 'zonalOfficerTaskCreate'])->name('tasks.create');
    Route::get('tasks/{task}', [TaskController::class, 'zonalOfficerShow'])->name('tasks.show');
    Route::get('tasks/{task}/edit', [TaskController::class, 'zonalOfficerEdit'])->name('tasks.edit');
    Route::get('zones/{zone}/product-requests', [ZOMainController::class, 'productRequests'])->name('zones-wise.product-requests');
    // Route::get('product-requests', [ZOMainController::class, 'productRequests'])->name('product-requests');
});


Route::view('/app/download', 'app-download')->name('app-download');

Route::get('reports/payslip/{user}/{payslip}', [MonthlyPayslipController::class, 'export'])->name('monthly-payslip.export');
// test routes
Route::get('user/engn', function (Request $request) {
    // $user = User::find(5);
    $user = User::find($request->get('uid', 5));

    // return $user->engineers()->toSql();
    // return $user->engineers;
    // return $user->regions;
    // return $user->regions;
    // return $user->client_branches()->get();
    return [
        'q' => $user->engineers()->toSql(),
        'us' => $user,
        'en' => $user->engineers,
        'tsk' => $user->tasks(),
    ];
});
Route::get('test/regions', function (Request $request) {
    $reg = Region::with([
        'states.zones.circles.clientBranches',
        'states.zones.circles.circleOfficer',
        // 'states.zones.circles.engineer2',
        'states.zones.circles.engineer',
    ])->get();
    return $reg;
});
Route::get('test/export', function (Request $request) {
    // $format = "pdf";
    // $format = "csv";
    $format = "csv";
    $formats = config('excel.extension_detector');

    $validatedFormat = $formats[$format];
    // $filename = "test-export-" . now()->format("YmdHis") . ".pdf";
    $filename = "test-export-" . now()->format("YmdHis") . "." . $format;

    return (new ModelExport(getModel(User::class)))->download($filename, $validatedFormat);
    // return (new ModelExport(getModel(User::class)))->raw($validatedFormat);
    // return (new ModelExport());
    $model =  getModel(User::class);
    // return getModel(User::class)->getFillable();



    // $headingRows = ($model->getFillable());
    // $headingRowsAssoc = collect($headingRows)->mapWithKeys(function ($h) {
    //     return  [$h => Str::title($h)];
    // })->toArray();

    // return (array)$headingRowsAssoc;
    // ->download($filename, $validatedFormat, [
    //     'Content-Disposition' => 'inline; filename=' . $filename,
    //     // 'Content-Disposition : inline; filename=' . $filename,
    // ]);
});


Route::get('test/tool-task', function (Request $request) {
    // (client_group_id is null or client_branch_id is null or client_id is null) and deleted_at is null
    $tttx = Task::where(function ($q) {
        $q->whereNull('client_group_id')
            ->orWhereNull('client_branch_id')
            ->orWhereNull('client_id');
    })
        ->whereNull('deleted_at')

        ->update([
            'deleted_at' => now()
        ]);

    return [
        'result' => $tttx,
    ];
});


Route::group(['prefix' => 'tools', 'as' => 'tools.'], function () {

    // Route::get('/cc', function () {
    //     Artisan::call('cache:clear');
    //     echo '<script>alert("cache clear Success")</script>';
    // });
    // Route::get('/ccc', function () {
    //     Artisan::call('config:cache');
    //     echo '<script>alert("config cache Success")</script>';
    // });
    // Route::get('/vc', function () {
    //     Artisan::call('view:clear');
    //     echo '<script>alert("view clear Success")</script>';
    // });
    // Route::get('/cr', function () {
    //     Artisan::call('route:cache');
    //     echo '<script>alert("route clear Success")</script>';
    // });
    // Route::get('/coc', function () {
    //     Artisan::call('config:clear');
    //     echo '<script>alert("config clear Success")</script>';
    // });
    Route::get('/storage123', function () {
        Artisan::call('storage:link');
        echo '<script>alert("linked")</script>';
    });
    Route::get('/phpinfo', function () {
        phpinfo();
    });
    Route::get('/clean', function () {
        Artisan::call('cache:clear');
        Artisan::call('view:clear');
        Artisan::call('config:clear');
        Artisan::call('config:cache');
        Artisan::call('route:cache');

        echo '<script>alert("cleaned")</script>';
    });
});
Route::get('/perm-seed', function () {
    DB::statement("SET FOREIGN_KEY_CHECKS=0;");
    Permission::truncate()->get();
    Artisan::call('db:seed --class=PermissionsTableSeeder');


    $admin_permissions = Permission::all();
    Role::findOrFail(1)->permissions()->sync($admin_permissions->pluck('id'));

    DB::statement("SET FOREIGN_KEY_CHECKS=1;");

    // echo '<script>alert("cleaned")</script>';

    return Artisan::output();
});
Route::get('/users-api', function () {
    return User::all()->groupBy('role_primary');
});
// Route::get('/test/t', function () {
//     return [
//         't' => now(),
//         't0' => now(config('app.timezone')),
//         't1' => now()->tz(config('app.timezone')),
//         't3' => \Carbon\Carbon::now(config('app.timezone')),
//         't4' => now()->tz('UTC')->format('d/m/Y h:i:s A'),
//         'tz' => config('app.timezone'),
//     ];
// });

Route::view('/test/invoice', 'prints.client-invoice-v1')->name('client-invoice-v1.test');


// view()->composer(['*'], function ($view) use ($apkUrl) {
//     view()->share('apk_url', $apkUrl);
//     view()->share('user', auth()->user());
// });

//require once core-web.ph
require_once __DIR__ . '/core-web.php';
