<form wire:submit.prevent="submit" class="pt-3">

    <div class="form-group {{ $errors->has('visitRoute.from') ? 'invalid' : '' }}">
        <label class="form-label" for="from">{{ trans('cruds.visitRoute.fields.from') }}</label>
        <input class="form-control" type="text" name="from" id="from" wire:model.defer="visitRoute.from">
        <div class="validation-message">
            {{ $errors->first('visitRoute.from') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.visitRoute.fields.from_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('visitRoute.to') ? 'invalid' : '' }}">
        <label class="form-label" for="to">{{ trans('cruds.visitRoute.fields.to') }}</label>
        <input class="form-control" type="text" name="to" id="to" wire:model.defer="visitRoute.to">
        <div class="validation-message">
            {{ $errors->first('visitRoute.to') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.visitRoute.fields.to_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('visitRoute.journey_distance') ? 'invalid' : '' }}">
        <label class="form-label" for="journey_distance">{{ trans('cruds.visitRoute.fields.journey_distance') }}</label>
        <input class="form-control" type="number" name="journey_distance" id="journey_distance" wire:model.defer="visitRoute.journey_distance" step="0.01">
        <div class="validation-message">
            {{ $errors->first('visitRoute.journey_distance') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.visitRoute.fields.journey_distance_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('visitRoute.journey_fare') ? 'invalid' : '' }}">
        <label class="form-label" for="journey_fare">{{ trans('cruds.visitRoute.fields.journey_fare') }}</label>
        <input class="form-control" type="number" name="journey_fare" id="journey_fare" wire:model.defer="visitRoute.journey_fare" step="0.01">
        <div class="validation-message">
            {{ $errors->first('visitRoute.journey_fare') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.visitRoute.fields.journey_fare_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('visitRoute.vehicle_type') ? 'invalid' : '' }}">
        <label class="form-label required">{{ trans('cruds.visitRoute.fields.vehicle_type') }}</label>
        @foreach($this->listsForFields['vehicle_type'] as $key => $value)
            <label class="radio-label"><input type="radio" name="vehicle_type" wire:model="visitRoute.vehicle_type" value="{{ $key }}">{{ $value }}</label>
        @endforeach
        <div class="validation-message">
            {{ $errors->first('visitRoute.vehicle_type') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.visitRoute.fields.vehicle_type_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('visitRoute.journey_type') ? 'invalid' : '' }}">
        <label class="form-label">{{ trans('cruds.visitRoute.fields.journey_type') }}</label>
        @foreach($this->listsForFields['journey_type'] as $key => $value)
            <label class="radio-label"><input type="radio" name="journey_type" wire:model="visitRoute.journey_type" value="{{ $key }}">{{ $value }}</label>
        @endforeach
        <div class="validation-message">
            {{ $errors->first('visitRoute.journey_type') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.visitRoute.fields.journey_type_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('visitRoute.note') ? 'invalid' : '' }}">
        <label class="form-label" for="note">{{ trans('cruds.visitRoute.fields.note') }}</label>
        <textarea class="form-control" name="note" id="note" wire:model.defer="visitRoute.note" rows="4"></textarea>
        <div class="validation-message">
            {{ $errors->first('visitRoute.note') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.visitRoute.fields.note_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('visitRoute.route_cost') ? 'invalid' : '' }}">
        <label class="form-label" for="route_cost">{{ trans('cruds.visitRoute.fields.route_cost') }}</label>
        <input class="form-control" type="number" name="route_cost" id="route_cost" wire:model.defer="visitRoute.route_cost" step="0.01">
        <div class="validation-message">
            {{ $errors->first('visitRoute.route_cost') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.visitRoute.fields.route_cost_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('visitRoute.user_id') ? 'invalid' : '' }}">
        <label class="form-label" for="user">{{ trans('cruds.visitRoute.fields.user') }}</label>
        <x-select-list class="form-control" id="user" name="user" :options="$this->listsForFields['user']" wire:model="visitRoute.user_id" />
        <div class="validation-message">
            {{ $errors->first('visitRoute.user_id') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.visitRoute.fields.user_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('visitRoute.reimbursement_id') ? 'invalid' : '' }}">
        <label class="form-label" for="reimbursement">{{ trans('cruds.visitRoute.fields.reimbursement') }}</label>
        <x-select-list class="form-control" id="reimbursement" name="reimbursement" :options="$this->listsForFields['reimbursement']" wire:model="visitRoute.reimbursement_id" />
        <div class="validation-message">
            {{ $errors->first('visitRoute.reimbursement_id') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.visitRoute.fields.reimbursement_helper') }}
        </div>
    </div>

    <div class="form-group">
        <button class="btn btn-indigo mr-2" type="submit">
            {{ trans('global.save') }}
        </button>
        <a href="{{ route('admin.visit-routes.index') }}" class="btn btn-secondary">
            {{ trans('global.cancel') }}
        </a>
    </div>
</form>