<form wire:submit.prevent="submit" class="pt-3">
    <div class="grid sm:crid-cols-1 md:grid-cols-2 gap-1">
        <div class="p-1">

            <div class="form-group {{ $errors->has('visitReimbursement.user_id') ? 'invalid' : '' }}">
                <label class="form-label" for="user">{{ trans('cruds.visitReimbursement.fields.user') }}</label>
                <x-select-list class="form-control" id="user" name="user" :options="$this->listsForFields['user']"
                    wire:model="visitReimbursement.user_id" />
                <div class="validation-message">
                    {{ $errors->first('visitReimbursement.user_id') }}
                </div>
                <div class="help-block">
                    {{ trans('cruds.visitReimbursement.fields.user_helper') }}
                </div>
            </div>
            <div class="form-group {{ $errors->has('visitReimbursement.task_id') ? 'invalid' : '' }}">
                <label class="form-label" for="task">{{ trans('cruds.visitReimbursement.fields.task') }}</label>
                <x-select-list class="form-control" id="task" name="task" :options="$this->listsForFields['task']"
                    wire:model="visitReimbursement.task_id" />
                <div class="validation-message">
                    {{ $errors->first('visitReimbursement.task_id') }}
                </div>
                <div class="help-block">
                    {{ trans('cruds.visitReimbursement.fields.task_helper') }}
                </div>
            </div>
            <div class="form-group {{ $errors->has('visitReimbursement.approved_by_id') ? 'invalid' : '' }}">
                <label class="form-label"
                    for="approved_by">{{ trans('cruds.visitReimbursement.fields.approved_by') }}</label>
                <x-select-list class="form-control" id="approved_by" name="approved_by" :options="$this->listsForFields['approved_by']"
                    wire:model="visitReimbursement.approved_by_id" />
                <div class="validation-message">
                    {{ $errors->first('visitReimbursement.approved_by_id') }}
                </div>
                <div class="help-block">
                    {{ trans('cruds.visitReimbursement.fields.approved_by_helper') }}
                </div>
            </div>
            <div class="form-group {{ $errors->has('visitReimbursement.approved_at') ? 'invalid' : '' }}">
                <label class="form-label"
                    for="approved_at">{{ trans('cruds.visitReimbursement.fields.approved_at') }}</label>
                <x-date-picker class="form-control" wire:model="visitReimbursement.approved_at" id="approved_at"
                    name="approved_at" />
                <div class="validation-message">
                    {{ $errors->first('visitReimbursement.approved_at') }}
                </div>
                <div class="help-block">
                    {{ trans('cruds.visitReimbursement.fields.approved_at_helper') }}
                </div>
            </div>
            <div class="form-group {{ $errors->has('visitReimbursement.amount') ? 'invalid' : '' }}">
                <label class="form-label" for="amount">{{ trans('cruds.visitReimbursement.fields.amount') }}</label>
                <input class="form-control" type="number" name="amount" id="amount"
                    wire:model.defer="visitReimbursement.amount" step="0.01">
                <div class="validation-message">
                    {{ $errors->first('visitReimbursement.amount') }}
                </div>
                <div class="help-block">
                    {{ trans('cruds.visitReimbursement.fields.amount_helper') }}
                </div>
            </div>
            <div class="form-group {{ $errors->has('visitReimbursement.visit_id') ? 'invalid' : '' }}">
                <label class="form-label" for="visit">{{ trans('cruds.visitReimbursement.fields.visit') }}</label>
                <x-select-list class="form-control" id="visit" name="visit" :options="$this->listsForFields['visit']"
                    wire:model="visitReimbursement.visit_id" />
                <div class="validation-message">
                    {{ $errors->first('visitReimbursement.visit_id') }}
                </div>
                <div class="help-block">
                    {{ trans('cruds.visitReimbursement.fields.visit_helper') }}
                </div>
            </div>
            <div class="form-group {{ $errors->has('visitReimbursement.status') ? 'invalid' : '' }}">
                <label class="form-label">{{ trans('cruds.visitReimbursement.fields.status') }}</label>
                @foreach ($this->listsForFields['status'] as $key => $value)
                    <label class="radio-label"><input type="radio" name="status"
                            wire:model="visitReimbursement.status"
                            value="{{ $key }}">{{ $value }}</label>
                @endforeach
                <div class="validation-message">
                    {{ $errors->first('visitReimbursement.status') }}
                </div>
                <div class="help-block">
                    {{ trans('cruds.visitReimbursement.fields.status_helper') }}
                </div>
            </div>
        </div>
        <div class="p-1 hidden">

            <table class="table table-bordered w-full table-fixed">
                <caption>Routes</caption>
                <thead>
                    <tr>
                        <th class="!text-center p-1 !bg-gray-300/25">From</th>
                        <th class="!text-center p-1 !bg-gray-300/25">To</th>
                        <th class="!text-center p-1 !bg-gray-300/25">Transport <br>Mode</th>
                        <th class="!text-center p-1 !bg-gray-300/25">Journe <br>Type</th>
                        <th class="!text-center p-1 !bg-gray-300/25">Distance <br>(in Km)</th>
                        <th class="!text-center p-1 !bg-gray-300/25">Rate</th>
                        <th class="!text-center p-1 !bg-gray-300/25">Amount</th>
                        <th class="!text-center p-1 !bg-gray-300/25">Note</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($routesArr as $route)
                        <tr>
                            <td class="capitalize p-1">{{ Arr::get($route, 'from') }}</td>
                            <td class="capitalize p-1">{{ Arr::get($route, 'to') }}</td>
                            <td class="capitalize p-1">{{ Arr::get($route, 'vehicle_type') }}</td>
                            <td class="capitalize p-1">{{ Arr::get($route, 'journey_type') }}</td>
                            <td class="capitalize p-1">{{ Arr::get($route, 'journey_distance') }}</td>
                            <td class="capitalize p-1">{{ Arr::get($route, 'journey_fare') }}</td>
                            <td class="capitalize p-1">{{ Arr::get($route, 'route_cost') }}</td>
                            <td class="capitalize p-1">{{ Arr::get($route, 'note') }}</td>
                        </tr>
                        <tr>
                            <td colspan="8" class="text-center">
                                <button type="button" wire:click="$emit('openModal', 'admin.actions.edit-user')"
                                    class="btn btn-indigo btn-sm">Add Route</button>
                            </td>
                        </tr>
                    @endforeach
            </table>
        </div>
    </div>

    <div class="form-group">
        <button class="btn btn-indigo mr-2" type="submit">
            {{ trans('global.save') }}
        </button>
        <a href="{{ route('admin.visit-reimbursements.index') }}" class="btn btn-secondary">
            {{ trans('global.cancel') }}
        </a>
    </div>
</form>
