<form wire:submit.prevent="submit" class="pt-3">
    @include('components.loading-spinner-full-page')


    <div class="form-group {{ $errors->has('state.name') ? 'invalid' : '' }}">
        <label class="form-label" for="name">{{ trans('cruds.state.fields.name') }}</label>
        <input class="form-control" type="text" name="name" id="name" wire:model.defer="state.name">
        <div class="validation-message">
            {{ $errors->first('state.name') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.state.fields.name_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('state.is_active') ? 'invalid' : '' }}">
        <input class="form-control" type="checkbox" name="is_active" id="is_active" wire:model.defer="state.is_active">
        <label class="form-label inline ml-1" for="is_active">{{ trans('cruds.state.fields.is_active') }}</label>
        <div class="validation-message">
            {{ $errors->first('state.is_active') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.state.fields.is_active_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('state.region_id') ? 'invalid' : '' }}">
        <label class="form-label" for="region">{{ trans('cruds.state.fields.region') }}</label>
        <x-select-list class="form-control" id="region" name="region" :options="$this->listsForFields['regions']" wire:model="state.region_id" />
        <div class="validation-message">
            {{ $errors->first('state.region_id') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.state.fields.region_helper') }}
        </div>
    </div>
    {{--
        <div class="form-group {{ $errors->has('state.zone_id') ? 'invalid' : '' }}">
            <label class="form-label" for="zone">{{ trans('cruds.state.fields.zone') }}</label>
            <x-select-list class="form-control" id="zone" name="zone" :options="$this->listsForFields['zone']" wire:model="state.zone_id" />
            <div class="validation-message">
                {{ $errors->first('state.zone_id') }}
            </div>
            <div class="help-block">
                {{ trans('cruds.state.fields.zone_helper') }}
            </div>
        </div>
    --}}

    <div class="form-group">
        <button class="btn btn-indigo mr-2" type="submit">
            {{ trans('global.save') }}
        </button>
        <a href="{{ route('admin.states.index') }}" class="btn btn-secondary">
            {{ trans('global.cancel') }}
        </a>
    </div>
</form>
