<div>
    <div class="card-controls sm:flex">
        <div class="w-full sm:w-1/2">
            Per page:
            <select wire:model="perPage" class="form-select w-full sm:w-1/6">
                @foreach($paginationOptions as $value)
                    <option value="{{ $value }}">{{ $value }}</option>
                @endforeach
            </select>

            @can('special_planned_day_delete')
                <button class="btn btn-rose ml-3 disabled:opacity-50 disabled:cursor-not-allowed" type="button" wire:click="confirm('deleteSelected')" wire:loading.attr="disabled" {{ $this->selectedCount ? '' : 'disabled' }}>
                    {{ __('Delete Selected') }}
                </button>
            @endcan

            @if(file_exists(app_path('Http/Livewire/ExcelExport.php')))
                <livewire:excel-export model="SpecialPlannedDay" format="csv" />
                <livewire:excel-export model="SpecialPlannedDay" format="xlsx" />
                <livewire:excel-export model="SpecialPlannedDay" format="pdf" />
            @endif


            @can('special_planned_day_create')
                <x-csv-import route="{{ route('admin.special-planned-days.csv.store') }}" />
            @endcan

        </div>
        <div class="w-full sm:w-1/2 sm:text-right">
            Search:
            <input type="text" wire:model.debounce.300ms="search" class="w-full sm:w-1/3 inline-block" />
        </div>
    </div>
    @include('components.loading-spinner-full-page')


    <div class="overflow-hidden">
        <div class="overflow-x-auto">
            <table class="table table-index w-full">
                <thead>
                    <tr>
                        <th class="w-9">
                        </th>
                        <th class="w-28">
                            {{ trans('cruds.specialPlannedDay.fields.id') }}
                            @include('components.table.sort', ['field' => 'id'])
                        </th>
                        <th>
                            {{ trans('cruds.specialPlannedDay.fields.title') }}
                            @include('components.table.sort', ['field' => 'title'])
                        </th>
                        <th>
                            {{ trans('cruds.specialPlannedDay.fields.description') }}
                            @include('components.table.sort', ['field' => 'description'])
                        </th>
                        <th>
                            {{ trans('cruds.specialPlannedDay.fields.leave_type') }}
                            @include('components.table.sort', ['field' => 'leave_type'])
                        </th>
                        <th>
                            {{ trans('cruds.specialPlannedDay.fields.from_date') }}
                            @include('components.table.sort', ['field' => 'from_date'])
                        </th>
                        {{-- <th>
                            {{ trans('cruds.specialPlannedDay.fields.to_date') }}
                            @include('components.table.sort', ['field' => 'to_date'])
                        </th> --}}
                        <th>
                        </th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($specialPlannedDays as $specialPlannedDay)
                        <tr>
                            <td>
                                <input type="checkbox" value="{{ $specialPlannedDay->id }}" wire:model="selected">
                            </td>
                            <td>
                                {{ $specialPlannedDay->id }}
                            </td>
                            <td>
                                {{ $specialPlannedDay->title }}
                            </td>
                            <td>
                                {{ $specialPlannedDay->description }}
                            </td>
                            <td>
                                {{ $specialPlannedDay->leave_type_label }}
                            </td>
                            <td>
                                {{ $specialPlannedDay->from_date }}
                            </td>
                            {{-- <td>
                                {{ $specialPlannedDay->to_date }}
                            </td> --}}
                            <td>
                                <div class="flex justify-end">
                                    @can('special_planned_day_show')
                                        <a class="btn btn-sm btn-info mr-2" href="{{ route('admin.special-planned-days.show', $specialPlannedDay) }}">
                                            {{ trans('global.view') }}
                                        </a>
                                    @endcan
                                    @can('special_planned_day_edit')
                                        <a class="btn btn-sm btn-success mr-2" href="{{ route('admin.special-planned-days.edit', $specialPlannedDay) }}">
                                            {{ trans('global.edit') }}
                                        </a>
                                    @endcan
                                    @can('special_planned_day_delete')
                                        <button class="btn btn-sm btn-rose mr-2" type="button" wire:click="confirm('delete', {{ $specialPlannedDay->id }})" wire:loading.attr="disabled">
                                            {{ trans('global.delete') }}
                                        </button>
                                    @endcan
                                </div>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="10">No entries found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <div class="card-body">
        <div class="pt-3">
            @if($this->selectedCount)
                <p class="text-sm leading-5">
                    <span class="font-medium">
                        {{ $this->selectedCount }}
                    </span>
                    {{ __('Entries selected') }}
                </p>
            @endif
            {{ $specialPlannedDays->links() }}
        </div>
    </div>
</div>

@push('scripts')
    <script>
        Livewire.on('confirm', e => {
    if (!confirm("{{ trans('global.areYouSure') }}")) {
        return
    }
@this[e.callback](...e.argv)
})
    </script>
@endpush
