<div>
    @include('components.loading-spinner-full-page')
    <div class="card-controls sm:flex">
        <div class="w-full sm:w-1/2">
            Per page:
            <select wire:model="perPage" class="form-select w-full sm:w-1/6">
                @foreach ($paginationOptions as $value)
                    <option value="{{ $value }}">{{ $value }}</option>
                @endforeach
            </select>

            @can('service_delete')
                <button class="btn btn-rose ml-3 disabled:opacity-50 disabled:cursor-not-allowed" type="button"
                    wire:click="confirm('deleteSelected')" wire:loading.attr="disabled"
                    {{ $this->selectedCount ? '' : 'disabled' }}>
                    {{ __('Delete Selected') }}
                </button>
            @endcan

            @if (file_exists(app_path('Http/Livewire/ExcelExport.php')))
                <livewire:excel-export model="Service" format="csv" />
                <livewire:excel-export model="Service" format="xlsx" />
                <livewire:excel-export model="Service" format="pdf" />
            @endif




        </div>
        <div class="w-full sm:w-1/2 sm:text-right">
            Search:
            <input type="text" wire:model.debounce.300ms="search" class="w-full sm:w-1/3 inline-block" />
        </div>
    </div>
    <div wire:loading.delay>
        Loading...
    </div>

    <div class="overflow-hidden">
        <div class="overflow-x-auto">
            <table class="table table-index w-full">
                <thead>
                    <tr>
                        <th class="w-9">
                        </th>
                        <th class="w-28">
                            {{ trans('cruds.service.fields.id') }}
                            @include('components.table.sort', ['field' => 'id'])
                        </th>
                        <th>
                            {{ trans('cruds.service.fields.name') }}
                            @include('components.table.sort', ['field' => 'name'])
                        </th>
                        <th>
                            {{ trans('cruds.service.fields.description') }}
                            @include('components.table.sort', ['field' => 'description'])
                        </th>
                        <th>
                            {{ trans('cruds.product.fields.hsn_code') }}
                            @include('components.table.sort', ['field' => 'hsn_code'])
                        </th>
                        <th>
                            {{ trans('cruds.product.fields.taxable_price') }}
                            @include('components.table.sort', ['field' => 'taxable_price'])
                        </th>
                        <th>
                            {{ trans('cruds.service.fields.price') }}
                            @include('components.table.sort', ['field' => 'price'])
                        </th>
                        <th>
                        </th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($services as $service)
                        <tr>
                            <td>
                                <input type="checkbox" value="{{ $service->id }}" wire:model="selected">
                            </td>
                            <td>
                                {{ $service->id }}
                            </td>
                            <td>
                                {{ $service->name }}
                            </td>
                            <td>
                                {{ $service->description }}
                            </td>
                            <td>
                                {{ $service->hsn_code }}
                            </td>
                            <td>
                                {{ $service->taxable_price }}
                            </td>
                            <td>
                                {{ $service->price }}
                            </td>
                            <td>
                                <div class="flex justify-end">
                                    @can('service_show')
                                        <a class="btn btn-sm btn-info mr-2"
                                            href="{{ route('admin.services.show', $service) }}">
                                            {{ trans('global.view') }}
                                        </a>
                                    @endcan
                                    @can('service_edit')
                                        <a class="btn btn-sm btn-success mr-2"
                                            href="{{ route('admin.services.edit', $service) }}">
                                            {{ trans('global.edit') }}
                                        </a>
                                    @endcan
                                    @can('service_delete')
                                        <button class="btn btn-sm btn-rose mr-2" type="button"
                                            wire:click="confirm('delete', {{ $service->id }})"
                                            wire:loading.attr="disabled">
                                            {{ trans('global.delete') }}
                                        </button>
                                    @endcan
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="10">No entries found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <div class="card-body">
        <div class="pt-3">
            @if ($this->selectedCount)
                <p class="text-sm leading-5">
                    <span class="font-medium">
                        {{ $this->selectedCount }}
                    </span>
                    {{ __('Entries selected') }}
                </p>
            @endif
            {{ $services->links() }}
        </div>
    </div>
</div>

@push('scripts')
    <script>
        Livewire.on('confirm', e => {
            if (!confirm("{{ trans('global.areYouSure') }}")) {
                return
            }
            @this[e.callback](...e.argv)
        })
    </script>
@endpush
