<form wire:submit.prevent="submit" class="pt-3">
    @include('components.loading-spinner-full-page')


    <div class="form-group {{ $errors->has('region.name') ? 'invalid' : '' }}">
        <label class="form-label" for="name">{{ trans('cruds.region.fields.name') }}</label>
        <input class="form-control" type="text" name="name" id="name" wire:model.defer="region.name">
        <div class="validation-message">
            {{ $errors->first('region.name') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.region.fields.name_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('region.is_active') ? 'invalid' : '' }}">
        <input class="form-control" type="checkbox" name="is_active" id="is_active" wire:model.defer="region.is_active">
        <label class="form-label inline ml-1" for="is_active">{{ trans('cruds.region.fields.is_active') }}</label>
        <div class="validation-message">
            {{ $errors->first('region.is_active') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.region.fields.is_active_helper') }}
        </div>
    </div>
    {{-- <div class="form-group {{ $errors->has('region.circle_id') ? 'invalid' : '' }}">
        <label class="form-label" for="circle">{{ trans('cruds.region.fields.circle') }}</label>
        <x-select-list class="form-control" id="circle" name="circle" :options="$this->listsForFields['circle']" wire:model="region.circle_id" />
        <div class="validation-message">
            {{ $errors->first('region.circle_id') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.region.fields.circle_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('engineer') ? 'invalid' : '' }}">
        <label class="form-label" for="engineer">{{ trans('cruds.region.fields.engineer') }}</label>
        <x-select-list class="form-control" id="engineer" name="engineer" wire:model="engineer" :options="$this->listsForFields['engineer']" multiple />
        <div class="validation-message">
            {{ $errors->first('engineer') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.region.fields.engineer_helper') }}
        </div>
    </div> --}}

    <div class="form-group">
        <button class="btn btn-indigo mr-2" type="submit">
            {{ trans('global.save') }}
        </button>
        <a href="{{ route('admin.regions.index') }}" class="btn btn-secondary">
            {{ trans('global.cancel') }}
        </a>
    </div>
</form>
