<div>
    <div class="card-controls sm:flex">
        <div class="w-full sm:w-1/2">
            Per page:
            <select wire:model="perPage" class="form-select w-full sm:w-1/6">
                @foreach($paginationOptions as $value)
                    <option value="{{ $value }}">{{ $value }}</option>
                @endforeach
            </select>

            @can('purchase_delete')
                <button class="btn btn-rose ml-3 disabled:opacity-50 disabled:cursor-not-allowed" type="button" wire:click="confirm('deleteSelected')" wire:loading.attr="disabled" {{ $this->selectedCount ? '' : 'disabled' }}>
                    {{ __('Delete Selected') }}
                </button>
            @endcan

            @if(file_exists(app_path('Http/Livewire/ExcelExport.php')))
                <livewire:excel-export model="Purchase" format="csv" />
                <livewire:excel-export model="Purchase" format="xlsx" />
                <livewire:excel-export model="Purchase" format="pdf" />
            @endif


            @can('purchase_create')
                <x-csv-import route="{{ route('admin.purchases.csv.store') }}" />
            @endcan

        </div>
        <div class="w-full sm:w-1/2 sm:text-right">
            Search:
            <input type="text" wire:model.debounce.300ms="search" class="w-full sm:w-1/3 inline-block" />
        </div>
    </div>
    <div wire:loading.delay>
        Loading...
    </div>

    <div class="overflow-hidden">
        <div class="overflow-x-auto">
            <table class="table table-index w-full">
                <thead>
                    <tr>
                        <th class="w-9">
                        </th>
                        <th class="w-28">
                            {{ trans('cruds.purchase.fields.id') }}
                            @include('components.table.sort', ['field' => 'id'])
                        </th>
                        <th>
                            {{ trans('cruds.purchase.fields.suply_invc_no') }}
                            @include('components.table.sort', ['field' => 'suply_invc_no'])
                        </th>
                        <th>
                            {{ trans('cruds.purchase.fields.prchs_date') }}
                            @include('components.table.sort', ['field' => 'prchs_date'])
                        </th>
                        <th>
                            {{ trans('cruds.purchase.fields.party_ac') }}
                            @include('components.table.sort', ['field' => 'party_ac'])
                        </th>
                        <th>
                            {{ trans('cruds.purchase.fields.total_invoic') }}
                            @include('components.table.sort', ['field' => 'total_invoic'])
                        </th>
                        <th>
                            {{ trans('cruds.purchase.fields.csgt_amt') }}
                            @include('components.table.sort', ['field' => 'csgt_amt'])
                        </th>
                        <th>
                            {{ trans('cruds.purchase.fields.sgst_amt') }}
                            @include('components.table.sort', ['field' => 'sgst_amt'])
                        </th>
                        <th>
                            {{ trans('cruds.purchase.fields.igst_amt') }}
                            @include('components.table.sort', ['field' => 'igst_amt'])
                        </th>
                        <th>
                            {{ trans('cruds.purchase.fields.invoice_total_wo_tax') }}
                            @include('components.table.sort', ['field' => 'invoice_total_wo_tax'])
                        </th>
                        <th>
                            {{ trans('cruds.purchase.fields.details') }}
                            @include('components.table.sort', ['field' => 'details'])
                        </th>
                        <th>
                        </th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($purchases as $purchase)
                        <tr>
                            <td>
                                <input type="checkbox" value="{{ $purchase->id }}" wire:model="selected">
                            </td>
                            <td>
                                {{ $purchase->id }}
                            </td>
                            <td>
                                {{ $purchase->suply_invc_no }}
                            </td>
                            <td>
                                {{ $purchase->prchs_date }}
                            </td>
                            <td>
                                {{ $purchase->party_ac_label }}
                            </td>
                            <td>
                                {{ $purchase->total_invoic }}
                            </td>
                            <td>
                                {{ $purchase->csgt_amt }}
                            </td>
                            <td>
                                {{ $purchase->sgst_amt }}
                            </td>
                            <td>
                                {{ $purchase->igst_amt }}
                            </td>
                            <td>
                                {{ $purchase->invoice_total_wo_tax }}
                            </td>
                            <td>
                                {{ $purchase->details }}
                            </td>
                            <td>
                                <div class="flex justify-end">
                                    @can('purchase_show')
                                        <a class="btn btn-sm btn-info mr-2" href="{{ route('admin.purchases.show', $purchase) }}">
                                            {{ trans('global.view') }}
                                        </a>
                                    @endcan
                                    @can('purchase_edit')
                                        <a class="btn btn-sm btn-success mr-2" href="{{ route('admin.purchases.edit', $purchase) }}">
                                            {{ trans('global.edit') }}
                                        </a>
                                    @endcan
                                    @can('purchase_delete')
                                        <button class="btn btn-sm btn-rose mr-2" type="button" wire:click="confirm('delete', {{ $purchase->id }})" wire:loading.attr="disabled">
                                            {{ trans('global.delete') }}
                                        </button>
                                    @endcan
                                </div>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="10">No entries found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <div class="card-body">
        <div class="pt-3">
            @if($this->selectedCount)
                <p class="text-sm leading-5">
                    <span class="font-medium">
                        {{ $this->selectedCount }}
                    </span>
                    {{ __('Entries selected') }}
                </p>
            @endif
            {{ $purchases->links() }}
        </div>
    </div>
</div>

@push('scripts')
    <script>
        Livewire.on('confirm', e => {
    if (!confirm("{{ trans('global.areYouSure') }}")) {
        return
    }
@this[e.callback](...e.argv)
})
    </script>
@endpush