<form wire:submit.prevent="submit" class="pt-3">

    <div class="form-group {{ $errors->has('productZonePivot.product_id') ? 'invalid' : '' }}">
        <label class="form-label" for="product">{{ trans('cruds.productZonePivot.fields.product') }}</label>
        <x-select-list class="form-control" id="product" name="product" :options="$this->listsForFields['product']" wire:model="productZonePivot.product_id" />
        <div class="validation-message">
            {{ $errors->first('productZonePivot.product_id') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.productZonePivot.fields.product_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('productZonePivot.zone_id') ? 'invalid' : '' }}">
        <label class="form-label" for="zone">{{ trans('cruds.productZonePivot.fields.zone') }}</label>
        <x-select-list class="form-control" id="zone" name="zone" :options="$this->listsForFields['zone']" wire:model="productZonePivot.zone_id" />
        <div class="validation-message">
            {{ $errors->first('productZonePivot.zone_id') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.productZonePivot.fields.zone_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('productZonePivot.quantity') ? 'invalid' : '' }}">
        <label class="form-label" for="quantity">{{ trans('cruds.productZonePivot.fields.quantity') }}</label>
        <input class="form-control" type="number" name="quantity" id="quantity" wire:model.defer="productZonePivot.quantity" step="1">
        <div class="validation-message">
            {{ $errors->first('productZonePivot.quantity') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.productZonePivot.fields.quantity_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('productZonePivot.price') ? 'invalid' : '' }}">
        <label class="form-label" for="price">{{ trans('cruds.productZonePivot.fields.price') }}</label>
        <input class="form-control" type="number" name="price" id="price" wire:model.defer="productZonePivot.price" step="0.01">
        <div class="validation-message">
            {{ $errors->first('productZonePivot.price') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.productZonePivot.fields.price_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('productZonePivot.last_updated_by_id') ? 'invalid' : '' }}">
        <label class="form-label" for="last_updated_by">{{ trans('cruds.productZonePivot.fields.last_updated_by') }}</label>
        <x-select-list class="form-control" id="last_updated_by" name="last_updated_by" :options="$this->listsForFields['last_updated_by']" wire:model="productZonePivot.last_updated_by_id" />
        <div class="validation-message">
            {{ $errors->first('productZonePivot.last_updated_by_id') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.productZonePivot.fields.last_updated_by_helper') }}
        </div>
    </div>

    <div class="form-group">
        <button class="btn btn-indigo mr-2" type="submit">
            {{ trans('global.save') }}
        </button>
        <a href="{{ route('admin.product-zone-pivots.index') }}" class="btn btn-secondary">
            {{ trans('global.cancel') }}
        </a>
    </div>
</form>