<form wire:submit.prevent="submit" class="pt-3">

    <div class="form-group {{ $errors->has('productTaskEventLog.task_event_log_id') ? 'invalid' : '' }}">
        <label class="form-label" for="task_event_log">{{ trans('cruds.productTaskEventLog.fields.task_event_log') }}</label>
        <x-select-list class="form-control" id="task_event_log" name="task_event_log" :options="$this->listsForFields['task_event_log']" wire:model="productTaskEventLog.task_event_log_id" />
        <div class="validation-message">
            {{ $errors->first('productTaskEventLog.task_event_log_id') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.productTaskEventLog.fields.task_event_log_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('productTaskEventLog.product_id') ? 'invalid' : '' }}">
        <label class="form-label" for="product">{{ trans('cruds.productTaskEventLog.fields.product') }}</label>
        <x-select-list class="form-control" id="product" name="product" :options="$this->listsForFields['product']" wire:model="productTaskEventLog.product_id" />
        <div class="validation-message">
            {{ $errors->first('productTaskEventLog.product_id') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.productTaskEventLog.fields.product_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('productTaskEventLog.quantity') ? 'invalid' : '' }}">
        <label class="form-label" for="quantity">{{ trans('cruds.productTaskEventLog.fields.quantity') }}</label>
        <input class="form-control" type="number" name="quantity" id="quantity" wire:model.defer="productTaskEventLog.quantity" step="1">
        <div class="validation-message">
            {{ $errors->first('productTaskEventLog.quantity') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.productTaskEventLog.fields.quantity_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('productTaskEventLog.status') ? 'invalid' : '' }}">
        <label class="form-label">{{ trans('cruds.productTaskEventLog.fields.status') }}</label>
        <select class="form-control" wire:model="productTaskEventLog.status">
            <option value="null" disabled>{{ trans('global.pleaseSelect') }}...</option>
            @foreach($this->listsForFields['status'] as $key => $value)
                <option value="{{ $key }}">{{ $value }}</option>
            @endforeach
        </select>
        <div class="validation-message">
            {{ $errors->first('productTaskEventLog.status') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.productTaskEventLog.fields.status_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('productTaskEventLog.approved_by_id') ? 'invalid' : '' }}">
        <label class="form-label" for="approved_by">{{ trans('cruds.productTaskEventLog.fields.approved_by') }}</label>
        <x-select-list class="form-control" id="approved_by" name="approved_by" :options="$this->listsForFields['approved_by']" wire:model="productTaskEventLog.approved_by_id" />
        <div class="validation-message">
            {{ $errors->first('productTaskEventLog.approved_by_id') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.productTaskEventLog.fields.approved_by_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('productTaskEventLog.approved_at') ? 'invalid' : '' }}">
        <label class="form-label" for="approved_at">{{ trans('cruds.productTaskEventLog.fields.approved_at') }}</label>
        <x-date-picker class="form-control" wire:model="productTaskEventLog.approved_at" id="approved_at" name="approved_at" />
        <div class="validation-message">
            {{ $errors->first('productTaskEventLog.approved_at') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.productTaskEventLog.fields.approved_at_helper') }}
        </div>
    </div>

    <div class="form-group">
        <button class="btn btn-indigo mr-2" type="submit">
            {{ trans('global.save') }}
        </button>
        <a href="{{ route('admin.product-task-event-logs.index') }}" class="btn btn-secondary">
            {{ trans('global.cancel') }}
        </a>
    </div>
</form>