<section class="py-12 px-4 text-gray-600 body-font  h-6/5">
    @include('components.loading-spinner-full-page')

    <form wire:submit.prevent="submit" class="pt-3">
        @if ($this->is_create_mode)
            <p class="text-center text-lg font-bold text-indigo">Generate Payslip</p>
        @elseif($this->is_edit_mode)
            <p class="text-center text-lg font-bold text-indigo">Update Payslip</p>
        @elseif($this->is_view_mode)
            <p class="text-center text-lg font-bold text-indigo">View Payslip</p>
        @endif
        {{-- @fjson($monthlyPayslip) --}}

        <div class="grid grid-cols-1 md:grid-cols-4 gap-5 border border-indigo-400 p-2">

            <div class="form-group {{ $errors->has('monthlyPayslip.fin_yr_id') ? 'invalid' : '' }}">
                <label class="form-label" for="fin_yr">{{ trans('cruds.monthlyPayslip.fields.fin_yr') }}</label>
                <x-select-list class="form-control" id="fin_yr" name="fin_yr" :options="$this->listsForFields['fin_yr']"
                    wire:model="monthlyPayslip.fin_yr_id" readonly disabled />
                <div class="validation-message">
                    {{ $errors->first('monthlyPayslip.fin_yr_id') }}
                </div>
                <div class="help-block">
                    {{ trans('cruds.monthlyPayslip.fields.fin_yr_helper') }}
                </div>
            </div>
            <div class="form-group {{ $errors->has('monthlyPayslip.year') ? 'invalid' : '' }}">
                <label class="form-label required">{{ trans('cruds.monthlyPayslip.fields.year') }}</label>
                <x-select-list class="form-control" id="year" name="year" :options="$this->listsForFields['year']"
                    wire:model="monthlyPayslip.year" readonly disabled />
                {{-- <select class="form-control" wire:model="monthlyPayslip.year" readonly>
                    <option value="null" readonly>{{ trans('global.pleaseSelect') }}...</option>
                    @foreach ($this->listsForFields['year'] as $key => $value)
                        <option value="{{ $key }}">{{ $value }}</option>
                    @endforeach
                </select> --}}
                <div class="validation-message">
                    {{ $errors->first('monthlyPayslip.year') }}
                </div>
                <div class="help-block">
                    {{ trans('cruds.monthlyPayslip.fields.year_helper') }}
                </div>
            </div>
            <div class="form-group {{ $errors->has('monthlyPayslip.month') ? 'invalid' : '' }}">
                <label class="form-label required">{{ trans('cruds.monthlyPayslip.fields.month') }}</label>
                <x-select-list class="form-control" id="month" name="month" :options="$this->listsForFields['month']"
                    wire:model="monthlyPayslip.month" readonly disabled />
                {{-- <select class="form-control" wire:model="monthlyPayslip.month" readonly>
                    <option value="null" readonly>{{ trans('global.pleaseSelect') }}...</option>
                    @foreach ($this->listsForFields['month'] as $key => $value)
                        <option value="{{ $key }}">{{ $value }}</option>
                    @endforeach
                </select> --}}
                <div class="validation-message">
                    {{ $errors->first('monthlyPayslip.month') }}
                </div>
                <div class="help-block">
                    {{ trans('cruds.monthlyPayslip.fields.month_helper') }}
                </div>
            </div>
            <div class="form-group {{ $errors->has('monthlyPayslip.user_id') ? 'invalid' : '' }}">
                <label class="form-label" for="user">{{ trans('cruds.monthlyPayslip.fields.user') }}</label>
                <x-select-list class="form-control" id="user" name="user" :options="$this->listsForFields['user']"
                    wire:model="monthlyPayslip.user_id" readonly disabled />
                <div class="validation-message">
                    {{ $errors->first('monthlyPayslip.user_id') }}
                </div>
                <div class="help-block">
                    {{ trans('cruds.monthlyPayslip.fields.user_helper') }}
                </div>
            </div>
        </div>
        {{-- <pre>@json($lastUpdated, JSON_PRETTY_PRINT)</pre> --}}
        {{-- <pre>@json($attribs, JSON_PRETTY_PRINT)</pre> --}}
        {{-- <pre>@json($user, JSON_PRETTY_PRINT)</pre> --}}
        {{-- <pre>@json($monthlyPayslip, JSON_PRETTY_PRINT)</pre> --}}
        @if (!$user->employeeDetails)
            <div class="bg-red-100 rounded-lg py-5 px-6 mb-4 text-base text-red-700 mb-3" role="alert">
                Employee info of this user has not been added.
                {{--  --}}
                <a href="{{ route('admin.user.employee-details', ['user' => $user->id]) }}" class="text-blue-500 "
                    target="_blank">Click here to add employee
                    info for this user</a>
            </div>
        @endif
        <div class="grid grid-cols-1 md:grid-cols-4 gap-5 border border-indigo-400 p-2">

            <div class="form-group {{ $errors->has('monthlyPayslip.emp_code') ? 'invalid' : '' }}">
                <label class="form-label" for="emp_code">{{ trans('cruds.monthlyPayslip.fields.emp_code') }}</label>
                <input class="form-control" type="text" name="emp_code" id="emp_code"
                    wire:model.defer="monthlyPayslip.emp_code">
                <div class="validation-message">
                    {{ $errors->first('monthlyPayslip.emp_code') }}
                </div>
                <div class="help-block">
                    {{ trans('cruds.monthlyPayslip.fields.emp_code_helper') }}
                </div>
            </div>
            <div class="form-group {{ $errors->has('monthlyPayslip.location') ? 'invalid' : '' }}">
                <label class="form-label" for="location">{{ trans('cruds.monthlyPayslip.fields.location') }}</label>
                <input class="form-control" type="text" name="location" id="location"
                    wire:model.defer="monthlyPayslip.location">
                <div class="validation-message">
                    {{ $errors->first('monthlyPayslip.location') }}
                </div>
                <div class="help-block">
                    {{ trans('cruds.monthlyPayslip.fields.location_helper') }}
                </div>
            </div>
            <div class="form-group {{ $errors->has('monthlyPayslip.name') ? 'invalid' : '' }}">
                <label class="form-label" for="name">{{ trans('cruds.monthlyPayslip.fields.name') }}</label>
                <input class="form-control" type="text" name="name" id="name"
                    wire:model.defer="monthlyPayslip.name">
                <div class="validation-message">
                    {{ $errors->first('monthlyPayslip.name') }}
                </div>
                <div class="help-block">
                    {{ trans('cruds.monthlyPayslip.fields.name_helper') }}
                </div>
            </div>
            <div class="form-group {{ $errors->has('monthlyPayslip.payment_mode') ? 'invalid' : '' }}">
                <label class="form-label"
                    for="payment_mode">{{ trans('cruds.monthlyPayslip.fields.payment_mode') }}</label>
                <input class="form-control" type="text" name="payment_mode" id="payment_mode"
                    wire:model.defer="monthlyPayslip.payment_mode">
                <div class="validation-message">
                    {{ $errors->first('monthlyPayslip.payment_mode') }}
                </div>
                <div class="help-block">
                    {{ trans('cruds.monthlyPayslip.fields.payment_mode_helper') }}
                </div>
            </div>
            <div class="form-group {{ $errors->has('monthlyPayslip.bank') ? 'invalid' : '' }}">
                <label class="form-label" for="bank">{{ trans('cruds.monthlyPayslip.fields.bank') }}</label>
                <input class="form-control" type="text" name="bank" id="bank"
                    wire:model.defer="monthlyPayslip.bank">
                <div class="validation-message">
                    {{ $errors->first('monthlyPayslip.bank') }}
                </div>
                <div class="help-block">
                    {{ trans('cruds.monthlyPayslip.fields.bank_helper') }}
                </div>
            </div>
            <div class="form-group {{ $errors->has('monthlyPayslip.bank_ac_no') ? 'invalid' : '' }}">
                <label class="form-label"
                    for="bank_ac_no">{{ trans('cruds.monthlyPayslip.fields.bank_ac_no') }}</label>
                <input class="form-control" type="text" name="bank_ac_no" id="bank_ac_no"
                    wire:model.defer="monthlyPayslip.bank_ac_no">
                <div class="validation-message">
                    {{ $errors->first('monthlyPayslip.bank_ac_no') }}
                </div>
                <div class="help-block">
                    {{ trans('cruds.monthlyPayslip.fields.bank_ac_no_helper') }}
                </div>
            </div>
            <div class="form-group {{ $errors->has('monthlyPayslip.aadhaar') ? 'invalid' : '' }}">
                <label class="form-label" for="aadhaar">{{ trans('cruds.monthlyPayslip.fields.aadhaar') }}</label>
                <input class="form-control" type="text" name="aadhaar" id="aadhaar"
                    wire:model.defer="monthlyPayslip.aadhaar">
                <div class="validation-message">
                    {{ $errors->first('monthlyPayslip.aadhaar') }}
                </div>
                <div class="help-block">
                    {{ trans('cruds.monthlyPayslip.fields.aadhaar_helper') }}
                </div>
            </div>
            <div class="form-group {{ $errors->has('monthlyPayslip.blood_group') ? 'invalid' : '' }}">
                <label class="form-label"
                    for="blood_group">{{ trans('cruds.monthlyPayslip.fields.blood_group') }}</label>
                <input class="form-control" type="text" name="blood_group" id="blood_group"
                    wire:model.defer="monthlyPayslip.blood_group">
                <div class="validation-message">
                    {{ $errors->first('monthlyPayslip.blood_group') }}
                </div>
                <div class="help-block">
                    {{ trans('cruds.monthlyPayslip.fields.blood_group_helper') }}
                </div>
            </div>
            <div class="form-group {{ $errors->has('monthlyPayslip.days_in_month') ? 'invalid' : '' }}">
                <label class="form-label"
                    for="days_in_month">{{ trans('cruds.monthlyPayslip.fields.days_in_month') }}</label>
                <input class="form-control" type="number" name="days_in_month" id="days_in_month"
                    wire:model="monthlyPayslip.days_in_month" step="1" readonly>
                <div class="validation-message">
                    {{ $errors->first('monthlyPayslip.days_in_month') }}
                </div>
                <div class="help-block">
                    {{ trans('cruds.monthlyPayslip.fields.days_in_month_helper') }}
                </div>
            </div>
            <div class="form-group {{ $errors->has('monthlyPayslip.lwp_days') ? 'invalid' : '' }}">
                <label class="form-label" for="lwp_days">{{ trans('cruds.monthlyPayslip.fields.lwp_days') }}</label>
                <input class="form-control" type="number" name="lwp_days" id="lwp_days"
                    wire:model="monthlyPayslip.lwp_days" step="1" max="{{ $monthlyPayslip->days_in_month }}"
                    min="0">
                <div class="validation-message">
                    {{ $errors->first('monthlyPayslip.lwp_days') }}
                </div>
                <div class="help-block">
                    {{ trans('cruds.monthlyPayslip.fields.lwp_days_helper') }}
                </div>
            </div>
            <div class="form-group {{ $errors->has('monthlyPayslip.working_days') ? 'invalid' : '' }}">
                <label class="form-label"
                    for="working_days">{{ trans('cruds.monthlyPayslip.fields.working_days') }}</label>
                <input class="form-control" type="number" name="working_days" id="working_days"
                    wire:model.defer="monthlyPayslip.working_days" step="1" max="31" min="0">
                <div class="validation-message">
                    {{ $errors->first('monthlyPayslip.working_days') }}
                </div>
                <div class="help-block">
                    {{ trans('cruds.monthlyPayslip.fields.working_days_helper') }}
                </div>
            </div>
            <div class="form-group {{ $errors->has('monthlyPayslip.esic_no') ? 'invalid' : '' }}">
                <label class="form-label" for="esic_no">{{ trans('cruds.monthlyPayslip.fields.esic_no') }}</label>
                <input class="form-control" type="text" name="esic_no" id="esic_no"
                    wire:model.defer="monthlyPayslip.esic_no">
                <div class="validation-message">
                    {{ $errors->first('monthlyPayslip.esic_no') }}
                </div>
                <div class="help-block">
                    {{ trans('cruds.monthlyPayslip.fields.esic_no_helper') }}
                </div>
            </div>
            <div class="form-group {{ $errors->has('monthlyPayslip.uan') ? 'invalid' : '' }}">
                <label class="form-label" for="uan">{{ trans('cruds.monthlyPayslip.fields.uan') }}</label>
                <input class="form-control" type="text" name="uan" id="uan"
                    wire:model.defer="monthlyPayslip.uan">
                <div class="validation-message">
                    {{ $errors->first('monthlyPayslip.uan') }}
                </div>
                <div class="help-block">
                    {{ trans('cruds.monthlyPayslip.fields.uan_helper') }}
                </div>
            </div>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 gap-4 border border-indigo-400 p-2">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4 border border-indigo-400 p-2">
                <h3 for="" class="text-xl col-span-2">Earnings</h3>
                <div class="form-group  {{ $errors->has('monthlyPayslip.gross_salary') ? 'invalid' : '' }}">
                    <label class="form-label"
                        for="gross_salary">{{ trans('cruds.monthlyPayslip.fields.gross_salary') }}</label>
                    <input class="form-control" type="number" name="gross_salary" id="gross_salary"
                        wire:model.defer="monthlyPayslip.gross_salary" step="0.01">
                    <div class="validation-message">
                        {{ $errors->first('monthlyPayslip.gross_salary') }}
                    </div>
                    <div class="help-block">
                        {{ trans('cruds.monthlyPayslip.fields.gross_salary_helper') }}
                    </div>
                </div>
                <div class="form-group {{ $errors->has('monthlyPayslip.incentive') ? 'invalid' : '' }}">
                    <label class="form-label"
                        for="incentive">{{ trans('cruds.monthlyPayslip.fields.incentive') }}</label>
                    <input class="form-control" type="number" name="incentive" id="incentive"
                        wire:model.debounce.600ms="monthlyPayslip.incentive" step="0.01">
                    <div class="validation-message">
                        {{ $errors->first('monthlyPayslip.incentive') }}
                    </div>
                    <div class="help-block">
                        {{ trans('cruds.monthlyPayslip.fields.incentive_helper') }}
                    </div>
                </div>

                <div class="text-right col-span-2">
                    <button class="btn btn-primary btn-xs text-2xs" wire:click="generateFromFormula" type="button">
                        Generate From Formula
                    </button>
                </div>
                <div class="form-group {{ $errors->has('monthlyPayslip.basic_salary') ? 'invalid' : '' }}">
                    <label class="form-label"
                        for="basic_salary">{{ trans('cruds.monthlyPayslip.fields.basic_salary') }}</label>
                    <input class="form-control" type="number" name="basic_salary" id="basic_salary"
                        wire:model.debounce.600ms="monthlyPayslip.basic_salary" step="0.01">
                    <div class="validation-message">
                        {{ $errors->first('monthlyPayslip.basic_salary') }}
                    </div>
                    <div class="help-block">
                        {{ trans('cruds.monthlyPayslip.fields.basic_salary_helper') }}
                    </div>
                </div>
                <div class="form-group {{ $errors->has('monthlyPayslip.hra') ? 'invalid' : '' }}">
                    <label class="form-label" for="hra">{{ trans('cruds.monthlyPayslip.fields.hra') }}</label>
                    <input class="form-control" type="number" name="hra" id="hra"
                        wire:model.debounce.600ms="monthlyPayslip.hra" step="0.01">
                    <div class="validation-message">
                        {{ $errors->first('monthlyPayslip.hra') }}
                    </div>
                    <div class="help-block">
                        {{ trans('cruds.monthlyPayslip.fields.hra_helper') }}
                    </div>
                </div>
                <div class="form-group {{ $errors->has('monthlyPayslip.ta') ? 'invalid' : '' }}">
                    <label class="form-label" for="ta">{{ trans('cruds.monthlyPayslip.fields.ta') }}</label>
                    <input class="form-control" type="number" name="ta" id="ta"
                        wire:model.debounce.600ms="monthlyPayslip.ta" step="0.01">
                    <div class="validation-message">
                        {{ $errors->first('monthlyPayslip.ta') }}
                    </div>
                    <div class="help-block">
                        {{ trans('cruds.monthlyPayslip.fields.ta_helper') }}
                    </div>
                </div>
                <div class="form-group {{ $errors->has('monthlyPayslip.total_earning') ? 'invalid' : '' }}">
                    <label class="form-label"
                        for="total_earning">{{ trans('cruds.monthlyPayslip.fields.total_earning') }}</label>
                    <input class="form-control" type="number" name="total_earning" id="total_earning"
                        wire:model.defer="monthlyPayslip.total_earning" step="0.01">
                    <div class="validation-message">
                        {{ $errors->first('monthlyPayslip.total_earning') }}
                    </div>
                    <div class="help-block">
                        {{ trans('cruds.monthlyPayslip.fields.total_earning_helper') }}
                    </div>
                    {{-- <div class="help-block">
                        <button class="btn btn-secondary text-2xs" wire:click="generateFromFormula" type="button">
                            Generate From Formula
                        </button>
                    </div> --}}
                </div>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-4 border border-indigo-400 p-2">
                <h3 for="" class="text-xl col-span-2">Deductions</h3>
                <div class="form-group {{ $errors->has('monthlyPayslip.pf') ? 'invalid' : '' }}">
                    <label class="form-label" for="pf">{{ trans('cruds.monthlyPayslip.fields.pf') }}</label>
                    <input class="form-control" type="number" name="pf" id="pf"
                        wire:model.debounce.600ms="monthlyPayslip.pf" step="0.01">
                    <div class="validation-message">
                        {{ $errors->first('monthlyPayslip.pf') }}
                    </div>
                    <div class="help-block">
                        {{ trans('cruds.monthlyPayslip.fields.pf_helper') }}
                    </div>
                </div>
                <div class="form-group {{ $errors->has('monthlyPayslip.ptax') ? 'invalid' : '' }}">
                    <label class="form-label" for="ptax">{{ trans('cruds.monthlyPayslip.fields.ptax') }}</label>
                    <input class="form-control" type="number" name="ptax" id="ptax"
                        wire:model.debounce.600ms="monthlyPayslip.ptax" step="0.01">
                    <div class="validation-message">
                        {{ $errors->first('monthlyPayslip.ptax') }}
                    </div>
                    <div class="help-block">
                        {{ trans('cruds.monthlyPayslip.fields.ptax_helper') }}
                    </div>
                </div>
                <div class="form-group {{ $errors->has('monthlyPayslip.esic') ? 'invalid' : '' }}">
                    <label class="form-label" for="esic">{{ trans('cruds.monthlyPayslip.fields.esic') }}</label>
                    <input class="form-control" type="number" name="esic" id="esic"
                        wire:model.debounce.600ms="monthlyPayslip.esic" step="0.01">
                    <div class="validation-message">
                        {{ $errors->first('monthlyPayslip.esic') }}
                    </div>
                    <div class="help-block">
                        {{ trans('cruds.monthlyPayslip.fields.esic_helper') }}
                    </div>
                </div>
                <div></div>
                {{-- <div></div> --}}
                <div class="form-group {{ $errors->has('monthlyPayslip.total_deduction') ? 'invalid' : '' }}">
                    <label class="form-label"
                        for="total_deduction">{{ trans('cruds.monthlyPayslip.fields.total_deduction') }}</label>
                    <input class="form-control" type="number" name="total_deduction" id="total_deduction"
                        wire:model.debounce.600ms="monthlyPayslip.total_deduction" step="0.01" readonly>
                    <div class="validation-message">
                        {{ $errors->first('monthlyPayslip.total_deduction') }}
                    </div>
                    <div class="help-block">
                        {{ trans('cruds.monthlyPayslip.fields.total_deduction_helper') }}
                    </div>
                </div>
            </div>
            <div class="grid grid-cols-1 md:grid-cols-4 gap-4 border border-indigo-400 p-2  col-span-2">

                <div class="form-group {{ $errors->has('monthlyPayslip.total_payment') ? 'invalid' : '' }}">
                    <label class="form-label"
                        for="total_payment">{{ trans('cruds.monthlyPayslip.fields.total_payment') }}</label>
                    <input class="form-control" type="text" name="total_payment" id="total_payment" readonly
                        wire:model.defer="monthlyPayslip.total_payment">
                    <div class="validation-message">
                        {{ $errors->first('monthlyPayslip.total_payment') }}
                    </div>
                    <div class="help-block">
                        {{ trans('cruds.monthlyPayslip.fields.total_payment_helper') }}
                    </div>
                </div>
                <div class="form-group {{ $errors->has('monthlyPayslip.payment_status') ? 'invalid' : '' }}">
                    <label class="form-label">{{ trans('cruds.monthlyPayslip.fields.payment_status') }}</label>
                    <select class="form-control" wire:model="monthlyPayslip.payment_status">
                        <option value="null" disabled>{{ trans('global.pleaseSelect') }}...</option>
                        @foreach ($this->listsForFields['payment_status'] as $key => $value)
                            <option value="{{ $key }}">{{ $value }}</option>
                        @endforeach
                    </select>
                    <div class="validation-message">
                        {{ $errors->first('monthlyPayslip.payment_status') }}
                    </div>
                    <div class="help-block">
                        {{ trans('cruds.monthlyPayslip.fields.payment_status_helper') }}
                    </div>
                </div>
            </div>
        </div>

        <div class="form-group">
            @if (!$this->is_view_mode)
                <button class="btn btn-indigo mr-2" type="submit">
                    {{ trans('global.save') }}
                </button>
            @endif
            @if ($this->is_view_mode && !is_null($monthlyPayslip->id))
                <a class="btn btn-indigo mr-2"
                    href="{{ route('monthly-payslip.export', [
                        'user' => $user->id,
                        'payslip' => $monthlyPayslip->id,
                    ]) }}">
                    {{ trans('global.print') }}
                </a>
            @endif
            <button class="btn btn-secondary" wire:click="cancel">
                {{ trans('global.cancel') }}
            </button>
        </div>
    </form>
</section>
