<div>
    <div class="card-controls sm:flex">
        <div class="w-full sm:w-1/2">
            Per page:
            <select wire:model="perPage" class="form-select w-full sm:w-1/6">
                @foreach($paginationOptions as $value)
                    <option value="{{ $value }}">{{ $value }}</option>
                @endforeach
            </select>

            @can('lg_attribute_delete')
                <button class="btn btn-rose ml-3 disabled:opacity-50 disabled:cursor-not-allowed" type="button" wire:click="confirm('deleteSelected')" wire:loading.attr="disabled" {{ $this->selectedCount ? '' : 'disabled' }}>
                    {{ __('Delete Selected') }}
                </button>
            @endcan

            @if(file_exists(app_path('Http/Livewire/ExcelExport.php')))
                <livewire:excel-export model="LgAttribute" format="csv" />
                <livewire:excel-export model="LgAttribute" format="xlsx" />
                <livewire:excel-export model="LgAttribute" format="pdf" />
            @endif




        </div>
        <div class="w-full sm:w-1/2 sm:text-right">
            Search:
            <input type="text" wire:model.debounce.300ms="search" class="w-full sm:w-1/3 inline-block" />
        </div>
    </div>
    <div wire:loading.delay>
        Loading...
    </div>

    <div class="overflow-hidden">
        <div class="overflow-x-auto">
            <table class="table table-index w-full">
                <thead>
                    <tr>
                        <th class="w-9">
                        </th>
                        <th class="w-28">
                            {{ trans('cruds.lgAttribute.fields.id') }}
                            @include('components.table.sort', ['field' => 'id'])
                        </th>
                        <th>
                            {{ trans('cruds.lgAttribute.fields.title') }}
                            @include('components.table.sort', ['field' => 'title'])
                        </th>
                        <th>
                            {{ trans('cruds.lgAttribute.fields.description') }}
                            @include('components.table.sort', ['field' => 'description'])
                        </th>
                        <th>
                            {{ trans('cruds.lgAttribute.fields.is_active') }}
                            @include('components.table.sort', ['field' => 'is_active'])
                        </th>
                        <th>
                            {{ trans('cruds.lgAttribute.fields.type') }}
                            @include('components.table.sort', ['field' => 'type'])
                        </th>
                        <th>
                            {{ trans('cruds.lgAttribute.fields.ledger_group') }}
                            @include('components.table.sort', ['field' => 'ledger_group.name'])
                        </th>
                        <th>
                        </th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($lgAttributes as $lgAttribute)
                        <tr>
                            <td>
                                <input type="checkbox" value="{{ $lgAttribute->id }}" wire:model="selected">
                            </td>
                            <td>
                                {{ $lgAttribute->id }}
                            </td>
                            <td>
                                {{ $lgAttribute->title }}
                            </td>
                            <td>
                                {{ $lgAttribute->description }}
                            </td>
                            <td>
                                <input class="disabled:opacity-50 disabled:cursor-not-allowed" type="checkbox" disabled {{ $lgAttribute->is_active ? 'checked' : '' }}>
                            </td>
                            <td>
                                {{ $lgAttribute->type_label }}
                            </td>
                            <td>
                                @if($lgAttribute->ledgerGroup)
                                    <span class="badge badge-relationship">{{ $lgAttribute->ledgerGroup->name ?? '' }}</span>
                                @endif
                            </td>
                            <td>
                                <div class="flex justify-end">
                                    @can('lg_attribute_show')
                                        <a class="btn btn-sm btn-info mr-2" href="{{ route('admin.lg-attributes.show', $lgAttribute) }}">
                                            {{ trans('global.view') }}
                                        </a>
                                    @endcan
                                    @can('lg_attribute_edit')
                                        <a class="btn btn-sm btn-success mr-2" href="{{ route('admin.lg-attributes.edit', $lgAttribute) }}">
                                            {{ trans('global.edit') }}
                                        </a>
                                    @endcan
                                    @can('lg_attribute_delete')
                                        <button class="btn btn-sm btn-rose mr-2" type="button" wire:click="confirm('delete', {{ $lgAttribute->id }})" wire:loading.attr="disabled">
                                            {{ trans('global.delete') }}
                                        </button>
                                    @endcan
                                </div>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="10">No entries found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <div class="card-body">
        <div class="pt-3">
            @if($this->selectedCount)
                <p class="text-sm leading-5">
                    <span class="font-medium">
                        {{ $this->selectedCount }}
                    </span>
                    {{ __('Entries selected') }}
                </p>
            @endif
            {{ $lgAttributes->links() }}
        </div>
    </div>
</div>

@push('scripts')
    <script>
        Livewire.on('confirm', e => {
    if (!confirm("{{ trans('global.areYouSure') }}")) {
        return
    }
@this[e.callback](...e.argv)
})
    </script>
@endpush