<form wire:submit.prevent="submit" class="pt-3">

    <div class="form-group {{ $errors->has('lgAttributeValue.ledger_group_attribute_id') ? 'invalid' : '' }}">
        <label class="form-label" for="ledger_group_attribute">{{ trans('cruds.lgAttributeValue.fields.ledger_group_attribute') }}</label>
        <x-select-list class="form-control" id="ledger_group_attribute" name="ledger_group_attribute" :options="$this->listsForFields['ledger_group_attribute']" wire:model="lgAttributeValue.ledger_group_attribute_id" />
        <div class="validation-message">
            {{ $errors->first('lgAttributeValue.ledger_group_attribute_id') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.lgAttributeValue.fields.ledger_group_attribute_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('lgAttributeValue.value') ? 'invalid' : '' }}">
        <label class="form-label" for="value">{{ trans('cruds.lgAttributeValue.fields.value') }}</label>
        <input class="form-control" type="text" name="value" id="value" wire:model.defer="lgAttributeValue.value">
        <div class="validation-message">
            {{ $errors->first('lgAttributeValue.value') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.lgAttributeValue.fields.value_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('lgAttributeValue.so') ? 'invalid' : '' }}">
        <label class="form-label" for="so">{{ trans('cruds.lgAttributeValue.fields.so') }}</label>
        <input class="form-control" type="number" name="so" id="so" wire:model.defer="lgAttributeValue.so" step="1">
        <div class="validation-message">
            {{ $errors->first('lgAttributeValue.so') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.lgAttributeValue.fields.so_helper') }}
        </div>
    </div>

    <div class="form-group">
        <button class="btn btn-indigo mr-2" type="submit">
            {{ trans('global.save') }}
        </button>
        <a href="{{ route('admin.lg-attribute-values.index') }}" class="btn btn-secondary">
            {{ trans('global.cancel') }}
        </a>
    </div>
</form>