<form wire:submit.prevent="submit" class="pt-3">

    <div class="form-group {{ $errors->has('ledger.name') ? 'invalid' : '' }}">
        <label class="form-label" for="name">{{ trans('cruds.ledger.fields.name') }}</label>
        <input class="form-control" type="text" name="name" id="name" wire:model.defer="ledger.name">
        <div class="validation-message">
            {{ $errors->first('ledger.name') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.ledger.fields.name_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('ledger.description') ? 'invalid' : '' }}">
        <label class="form-label" for="description">{{ trans('cruds.ledger.fields.description') }}</label>
        <input class="form-control" type="text" name="description" id="description" wire:model.defer="ledger.description">
        <div class="validation-message">
            {{ $errors->first('ledger.description') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.ledger.fields.description_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('ledger.ledger_group_id') ? 'invalid' : '' }}">
        <label class="form-label required" for="ledger_group">{{ trans('cruds.ledger.fields.ledger_group') }}</label>
        <x-select-list class="form-control" required id="ledger_group" name="ledger_group" :options="$this->listsForFields['ledger_group']" wire:model="ledger.ledger_group_id" />
        <div class="validation-message">
            {{ $errors->first('ledger.ledger_group_id') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.ledger.fields.ledger_group_helper') }}
        </div>
    </div>

    <div class="form-group">
        <button class="btn btn-indigo mr-2" type="submit">
            {{ trans('global.save') }}
        </button>
        <a href="{{ route('admin.ledgers.index') }}" class="btn btn-secondary">
            {{ trans('global.cancel') }}
        </a>
    </div>
</form>