<form wire:submit.prevent="submit" class="pt-3">

    <div class="form-group {{ $errors->has('ledger.name') ? 'invalid' : '' }}">
        <label class="form-label" for="name">{{ trans('cruds.ledger.fields.name') }}</label>
        <input class="form-control" type="text" name="name" id="name" wire:model.defer="ledger.name">
        <div class="validation-message">
            {{ $errors->first('ledger.name') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.ledger.fields.name_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('ledger.description') ? 'invalid' : '' }}">
        <label class="form-label" for="description">{{ trans('cruds.ledger.fields.description') }}</label>
        <input class="form-control" type="text" name="description" id="description" wire:model.defer="ledger.description">
        <div class="validation-message">
            {{ $errors->first('ledger.description') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.ledger.fields.description_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('ledger.ledger_group_id') ? 'invalid' : '' }}">
        <label class="form-label required" for="ledger_group">{{ trans('cruds.ledger.fields.ledger_group') }}</label>
        <x-select-list class="form-control" required id="ledger_group" name="ledger_group" :options="$this->listsForFields['ledger_group']" wire:model="ledger.ledger_group_id"  />
        <div class="validation-message">
            {{ $errors->first('ledger.ledger_group_id') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.ledger.fields.ledger_group_helper') }}
        </div>
        {{-- <p>Selected City ID: {{ $city_id }}</p> --}}
        <pre>@json($ledegr_group_attributes,JSON_PRETTY_PRINT)</pre>
        {{-- <p>Selected City ID: {{ $ledger->ledger_group_id }}</p> --}}
    </div>
    @if (isset($lg_attributes))
    <div id="attrbuts_from-{{uniqid()}}">
        @foreach ($lg_attributes->ledgerattres as $index => $attributes)
        {{-- <pre>@json($attributes,JSON_PRETTY_PRINT)</pre> --}}
        {{-- <pre>{{$attributes->title}}</pre> --}}
        @if ($attributes->type=="dropdown")
        <div x-id="from-group-{{$index}}-{{uniqid()}}" class="form-group">
            <label class="form-label required">{{$attributes->title}}</label>
            <select id="countries-{{uniqid()}}" class=" form-control " wire:model="ledegr_group_attributes.{{$attributes->id}}.value_id">
                <option selected>Choose {{$attributes->title}}</option>
                @foreach ($attributes->ledgerattrvalues as $attributevalue)
                <option value="{{$attributevalue->id}}">{{$attributevalue->value}}</option>
                @endforeach


              </select>
        </div>
        @elseif ($attributes->type=="text")
        <div x-id="from-group-{{$index}}-{{uniqid()}}" class="form-group"  >
            <label class="form-label required">{{$attributes->title}}</label>
            <input class="form-control" type="text" name="name" id="name-{{uniqid()}}" wire:model="ledegr_group_attributes.{{$attributes->id}}.value_text">
        </div>
        @endif

        @endforeach
    </div>
        {{-- <pre>@json($lg_attributes->ledgerattres,JSON_PRETTY_PRINT)</pre> --}}
    @endif
    {{-- @foreach ( as )

    @endforeach --}}



    <div class="form-group">
        <button class="btn btn-indigo mr-2" type="submit">
            {{ trans('global.save') }}
        </button>
        <a href="{{ route('admin.ledgers.index') }}" class="btn btn-secondary">
            {{ trans('global.cancel') }}
        </a>
    </div>
</form>
