<div>
    <div class="card-controls sm:flex">
        <div class="w-full sm:w-1/2">
            Per page:
            <select wire:model="perPage" class="form-select w-full sm:w-1/6">
                @foreach($paginationOptions as $value)
                    <option value="{{ $value }}">{{ $value }}</option>
                @endforeach
            </select>

            @can('ledger_transaction_delete')
                <button class="btn btn-rose ml-3 disabled:opacity-50 disabled:cursor-not-allowed" type="button" wire:click="confirm('deleteSelected')" wire:loading.attr="disabled" {{ $this->selectedCount ? '' : 'disabled' }}>
                    {{ __('Delete Selected') }}
                </button>
            @endcan

            @if(file_exists(app_path('Http/Livewire/ExcelExport.php')))
                <livewire:excel-export model="LedgerTransaction" format="csv" />
                <livewire:excel-export model="LedgerTransaction" format="xlsx" />
                <livewire:excel-export model="LedgerTransaction" format="pdf" />
            @endif




        </div>
        <div class="w-full sm:w-1/2 sm:text-right">
            Search:
            <input type="text" wire:model.debounce.300ms="search" class="w-full sm:w-1/3 inline-block" />
        </div>
    </div>
    @include('components.loading-spinner-full-page')


    <div class="overflow-hidden">
        <div class="overflow-x-auto">
            <table class="table table-index w-full">
                <thead>
                    <tr>
                        <th class="w-9">
                        </th>
                        <th class="w-28">
                            {{ trans('cruds.ledgerTransaction.fields.id') }}
                            @include('components.table.sort', ['field' => 'id'])
                        </th>
                        <th>
                            {{ trans('cruds.ledgerTransaction.fields.fin_yr') }}
                            @include('components.table.sort', ['field' => 'fin_yr.title'])
                        </th>
                        <th>
                            {{ trans('cruds.finYr.fields.alias') }}
                            @include('components.table.sort', ['field' => 'fin_yr.alias'])
                        </th>
                        <th>
                            {{ trans('cruds.ledgerTransaction.fields.ledger') }}
                            @include('components.table.sort', ['field' => 'ledger.name'])
                        </th>
                        <th>
                            {{ trans('cruds.ledgerTransaction.fields.date') }}
                            @include('components.table.sort', ['field' => 'date'])
                        </th>
                        <th>
                            {{ trans('cruds.ledgerTransaction.fields.amount') }}
                            @include('components.table.sort', ['field' => 'amount'])
                        </th>
                        <th>
                            {{ trans('cruds.ledgerTransaction.fields.type') }}
                            @include('components.table.sort', ['field' => 'type'])
                        </th>
                        <th>
                            {{ trans('cruds.ledgerTransaction.fields.cr_bal_before') }}
                            @include('components.table.sort', ['field' => 'cr_bal_before'])
                        </th>
                        <th>
                            {{ trans('cruds.ledgerTransaction.fields.dr_bal_before') }}
                            @include('components.table.sort', ['field' => 'dr_bal_before'])
                        </th>
                        <th>
                            {{ trans('cruds.ledgerTransaction.fields.cr_bal_after') }}
                            @include('components.table.sort', ['field' => 'cr_bal_after'])
                        </th>
                        <th>
                            {{ trans('cruds.ledgerTransaction.fields.dr_bal_after') }}
                            @include('components.table.sort', ['field' => 'dr_bal_after'])
                        </th>
                        <th>
                            {{ trans('cruds.ledgerTransaction.fields.description') }}
                            @include('components.table.sort', ['field' => 'description'])
                        </th>
                        <th>
                        </th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($ledgerTransactions as $ledgerTransaction)
                        <tr>
                            <td>
                                <input type="checkbox" value="{{ $ledgerTransaction->id }}" wire:model="selected">
                            </td>
                            <td>
                                {{ $ledgerTransaction->id }}
                            </td>
                            <td>
                                @if($ledgerTransaction->finYr)
                                    <span class="badge badge-relationship">{{ $ledgerTransaction->finYr->title ?? '' }}</span>
                                @endif
                            </td>
                            <td>
                                @if($ledgerTransaction->finYr)
                                    {{ $ledgerTransaction->finYr->alias ?? '' }}
                                @endif
                            </td>
                            <td>
                                @if($ledgerTransaction->ledger)
                                    <span class="badge badge-relationship">{{ $ledgerTransaction->ledger->name ?? '' }}</span>
                                @endif
                            </td>
                            <td>
                                {{ $ledgerTransaction->date }}
                            </td>
                            <td>
                                {{ $ledgerTransaction->amount }}
                            </td>
                            <td>
                                {{ $ledgerTransaction->type_label }}
                            </td>
                            <td>
                                {{ $ledgerTransaction->cr_bal_before }}
                            </td>
                            <td>
                                {{ $ledgerTransaction->dr_bal_before }}
                            </td>
                            <td>
                                {{ $ledgerTransaction->cr_bal_after }}
                            </td>
                            <td>
                                {{ $ledgerTransaction->dr_bal_after }}
                            </td>
                            <td>
                                {{ $ledgerTransaction->description }}
                            </td>
                            <td>
                                <div class="flex justify-end">
                                    @can('ledger_transaction_show')
                                        <a class="btn btn-sm btn-info mr-2" href="{{ route('admin.ledger-transactions.show', $ledgerTransaction) }}">
                                            {{ trans('global.view') }}
                                        </a>
                                    @endcan
                                    @can('ledger_transaction_edit')
                                        <a class="btn btn-sm btn-success mr-2" href="{{ route('admin.ledger-transactions.edit', $ledgerTransaction) }}">
                                            {{ trans('global.edit') }}
                                        </a>
                                    @endcan
                                    @can('ledger_transaction_delete')
                                        <button class="btn btn-sm btn-rose mr-2" type="button" wire:click="confirm('delete', {{ $ledgerTransaction->id }})" wire:loading.attr="disabled">
                                            {{ trans('global.delete') }}
                                        </button>
                                    @endcan
                                </div>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="10">No entries found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <div class="card-body">
        <div class="pt-3">
            @if($this->selectedCount)
                <p class="text-sm leading-5">
                    <span class="font-medium">
                        {{ $this->selectedCount }}
                    </span>
                    {{ __('Entries selected') }}
                </p>
            @endif
            {{ $ledgerTransactions->links() }}
        </div>
    </div>
</div>

@push('scripts')
    <script>
        Livewire.on('confirm', e => {
    if (!confirm("{{ trans('global.areYouSure') }}")) {
        return
    }
@this[e.callback](...e.argv)
})
    </script>
@endpush
