<form wire:submit.prevent="submit" class="pt-3">
    @include('components.loading-spinner-full-page')


    <div class="form-group {{ $errors->has('ledgerTransaction.fin_yr_id') ? 'invalid' : '' }}">
        <label class="form-label required" for="fin_yr">{{ trans('cruds.ledgerTransaction.fields.fin_yr') }}</label>
        <x-select-list class="form-control" required id="fin_yr" name="fin_yr" :options="$this->listsForFields['fin_yr']" wire:model="ledgerTransaction.fin_yr_id" />
        <div class="validation-message">
            {{ $errors->first('ledgerTransaction.fin_yr_id') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.ledgerTransaction.fields.fin_yr_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('ledgerTransaction.ledger_id') ? 'invalid' : '' }}">
        <label class="form-label required" for="ledger">{{ trans('cruds.ledgerTransaction.fields.ledger') }}</label>
        <x-select-list class="form-control" required id="ledger" name="ledger" :options="$this->listsForFields['ledger']" wire:model="ledgerTransaction.ledger_id" />
        <div class="validation-message">
            {{ $errors->first('ledgerTransaction.ledger_id') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.ledgerTransaction.fields.ledger_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('ledgerTransaction.date') ? 'invalid' : '' }}">
        <label class="form-label" for="date">{{ trans('cruds.ledgerTransaction.fields.date') }}</label>
        <x-date-picker class="form-control" wire:model="ledgerTransaction.date" id="date" name="date" />
        <div class="validation-message">
            {{ $errors->first('ledgerTransaction.date') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.ledgerTransaction.fields.date_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('ledgerTransaction.amount') ? 'invalid' : '' }}">
        <label class="form-label" for="amount">{{ trans('cruds.ledgerTransaction.fields.amount') }}</label>
        <input class="form-control" type="number" name="amount" id="amount" wire:model.defer="ledgerTransaction.amount" step="0.01">
        <div class="validation-message">
            {{ $errors->first('ledgerTransaction.amount') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.ledgerTransaction.fields.amount_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('ledgerTransaction.type') ? 'invalid' : '' }}">
        <label class="form-label required">{{ trans('cruds.ledgerTransaction.fields.type') }}</label>
        @foreach($this->listsForFields['type'] as $key => $value)
            <label class="radio-label"><input type="radio" name="type" wire:model="ledgerTransaction.type" value="{{ $key }}">{{ $value }}</label>
        @endforeach
        <div class="validation-message">
            {{ $errors->first('ledgerTransaction.type') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.ledgerTransaction.fields.type_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('ledgerTransaction.cr_bal_before') ? 'invalid' : '' }}">
        <label class="form-label" for="cr_bal_before">{{ trans('cruds.ledgerTransaction.fields.cr_bal_before') }}</label>
        <input class="form-control" type="number" name="cr_bal_before" id="cr_bal_before" wire:model.defer="ledgerTransaction.cr_bal_before" step="0.01">
        <div class="validation-message">
            {{ $errors->first('ledgerTransaction.cr_bal_before') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.ledgerTransaction.fields.cr_bal_before_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('ledgerTransaction.dr_bal_before') ? 'invalid' : '' }}">
        <label class="form-label" for="dr_bal_before">{{ trans('cruds.ledgerTransaction.fields.dr_bal_before') }}</label>
        <input class="form-control" type="number" name="dr_bal_before" id="dr_bal_before" wire:model.defer="ledgerTransaction.dr_bal_before" step="0.01">
        <div class="validation-message">
            {{ $errors->first('ledgerTransaction.dr_bal_before') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.ledgerTransaction.fields.dr_bal_before_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('ledgerTransaction.cr_bal_after') ? 'invalid' : '' }}">
        <label class="form-label" for="cr_bal_after">{{ trans('cruds.ledgerTransaction.fields.cr_bal_after') }}</label>
        <input class="form-control" type="number" name="cr_bal_after" id="cr_bal_after" wire:model.defer="ledgerTransaction.cr_bal_after" step="0.01">
        <div class="validation-message">
            {{ $errors->first('ledgerTransaction.cr_bal_after') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.ledgerTransaction.fields.cr_bal_after_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('ledgerTransaction.dr_bal_after') ? 'invalid' : '' }}">
        <label class="form-label" for="dr_bal_after">{{ trans('cruds.ledgerTransaction.fields.dr_bal_after') }}</label>
        <input class="form-control" type="number" name="dr_bal_after" id="dr_bal_after" wire:model.defer="ledgerTransaction.dr_bal_after" step="0.01">
        <div class="validation-message">
            {{ $errors->first('ledgerTransaction.dr_bal_after') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.ledgerTransaction.fields.dr_bal_after_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('ledgerTransaction.description') ? 'invalid' : '' }}">
        <label class="form-label" for="description">{{ trans('cruds.ledgerTransaction.fields.description') }}</label>
        <textarea class="form-control" name="description" id="description" wire:model.defer="ledgerTransaction.description" rows="4"></textarea>
        <div class="validation-message">
            {{ $errors->first('ledgerTransaction.description') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.ledgerTransaction.fields.description_helper') }}
        </div>
    </div>

    <div class="form-group">
        <button class="btn btn-indigo mr-2" type="submit">
            {{ trans('global.save') }}
        </button>
        <a href="{{ route('admin.ledger-transactions.index') }}" class="btn btn-secondary">
            {{ trans('global.cancel') }}
        </a>
    </div>
</form>
