<form wire:submit.prevent="submit" class="pt-3">

    <div class="form-group {{ $errors->has('ledgerLgAttributeValue.ledger_id') ? 'invalid' : '' }}">
        <label class="form-label" for="ledger">{{ trans('cruds.ledgerLgAttributeValue.fields.ledger') }}</label>
        <x-select-list class="form-control" id="ledger" name="ledger" :options="$this->listsForFields['ledger']" wire:model="ledgerLgAttributeValue.ledger_id" />
        <div class="validation-message">
            {{ $errors->first('ledgerLgAttributeValue.ledger_id') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.ledgerLgAttributeValue.fields.ledger_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('ledgerLgAttributeValue.lg_attribute_id') ? 'invalid' : '' }}">
        <label class="form-label" for="lg_attribute">{{ trans('cruds.ledgerLgAttributeValue.fields.lg_attribute') }}</label>
        <x-select-list class="form-control" id="lg_attribute" name="lg_attribute" :options="$this->listsForFields['lg_attribute']" wire:model="ledgerLgAttributeValue.lg_attribute_id" />
        <div class="validation-message">
            {{ $errors->first('ledgerLgAttributeValue.lg_attribute_id') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.ledgerLgAttributeValue.fields.lg_attribute_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('ledgerLgAttributeValue.lg_attribute_value_id') ? 'invalid' : '' }}">
        <label class="form-label" for="lg_attribute_value">{{ trans('cruds.ledgerLgAttributeValue.fields.lg_attribute_value') }}</label>
        <x-select-list class="form-control" id="lg_attribute_value" name="lg_attribute_value" :options="$this->listsForFields['lg_attribute_value']" wire:model="ledgerLgAttributeValue.lg_attribute_value_id" />
        <div class="validation-message">
            {{ $errors->first('ledgerLgAttributeValue.lg_attribute_value_id') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.ledgerLgAttributeValue.fields.lg_attribute_value_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('ledgerLgAttributeValue.value_text') ? 'invalid' : '' }}">
        <label class="form-label" for="value_text">{{ trans('cruds.ledgerLgAttributeValue.fields.value_text') }}</label>
        <input class="form-control" type="text" name="value_text" id="value_text" wire:model.defer="ledgerLgAttributeValue.value_text">
        <div class="validation-message">
            {{ $errors->first('ledgerLgAttributeValue.value_text') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.ledgerLgAttributeValue.fields.value_text_helper') }}
        </div>
    </div>

    <div class="form-group">
        <button class="btn btn-indigo mr-2" type="submit">
            {{ trans('global.save') }}
        </button>
        <a href="{{ route('admin.ledger-lg-attribute-values.index') }}" class="btn btn-secondary">
            {{ trans('global.cancel') }}
        </a>
    </div>
</form>