<form wire:submit.prevent="submit" class="pt-3">

    <div class="form-group {{ $errors->has('ledgerGroup.name') ? 'invalid' : '' }}">
        <label class="form-label" for="name">{{ trans('cruds.ledgerGroup.fields.name') }}</label>
        <input class="form-control" type="text" name="name" id="name" wire:model.defer="ledgerGroup.name">
        <div class="validation-message">
            {{ $errors->first('ledgerGroup.name') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.ledgerGroup.fields.name_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('ledgerGroup.purpose') ? 'invalid' : '' }}">
        <label class="form-label" for="purpose">{{ trans('cruds.ledgerGroup.fields.purpose') }}</label>
        <input class="form-control" type="text" name="purpose" id="purpose" wire:model.defer="ledgerGroup.purpose">
        <div class="validation-message">
            {{ $errors->first('ledgerGroup.purpose') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.ledgerGroup.fields.purpose_helper') }}
        </div>
    </div>

    <div class="form-group">
        <button class="btn btn-indigo mr-2" type="submit">
            {{ trans('global.save') }}
        </button>
        <a href="{{ route('admin.ledger-groups.index') }}" class="btn btn-secondary">
            {{ trans('global.cancel') }}
        </a>
    </div>
</form>