<form wire:submit.prevent="submit" class="pt-3">
    @include('components.loading-spinner-full-page')


    <div class="form-group {{ $errors->has('finYr.title') ? 'invalid' : '' }}">
        <label class="form-label required" for="title">{{ trans('cruds.finYr.fields.title') }}</label>
        <input class="form-control" type="text" name="title" id="title" required wire:model.defer="finYr.title">
        <div class="validation-message">
            {{ $errors->first('finYr.title') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.finYr.fields.title_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('finYr.alias') ? 'invalid' : '' }}">
        <label class="form-label" for="alias">{{ trans('cruds.finYr.fields.alias') }}</label>
        <input class="form-control" type="text" name="alias" id="alias" wire:model.defer="finYr.alias">
        <div class="validation-message">
            {{ $errors->first('finYr.alias') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.finYr.fields.alias_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('finYr.date_from') ? 'invalid' : '' }}">
        <label class="form-label" for="date_from">{{ trans('cruds.finYr.fields.date_from') }}</label>
        <x-date-picker class="form-control" wire:model="finYr.date_from" id="date_from" name="date_from" picker="date" />
        <div class="validation-message">
            {{ $errors->first('finYr.date_from') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.finYr.fields.date_from_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('finYr.date_to') ? 'invalid' : '' }}">
        <label class="form-label" for="date_to">{{ trans('cruds.finYr.fields.date_to') }}</label>
        <x-date-picker class="form-control" wire:model="finYr.date_to" id="date_to" name="date_to" picker="date" />
        <div class="validation-message">
            {{ $errors->first('finYr.date_to') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.finYr.fields.date_to_helper') }}
        </div>
    </div>

    <div class="form-group">
        <button class="btn btn-indigo mr-2" type="submit">
            {{ trans('global.save') }}
        </button>
        <a href="{{ route('admin.fin-yrs.index') }}" class="btn btn-secondary">
            {{ trans('global.cancel') }}
        </a>
    </div>
</form>
