<form wire:submit.prevent="submit" class="pt-3">

    <div class="form-group {{ $errors->has('employeeInfo.user_id') ? 'invalid' : '' }}">
        <label class="form-label" for="user">{{ trans('cruds.employeeInfo.fields.user') }}</label>
        <x-select-list class="form-control" id="user" name="user" :options="$this->listsForFields['user']" wire:model="employeeInfo.user_id" />
        <div class="validation-message">
            {{ $errors->first('employeeInfo.user_id') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeInfo.fields.user_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeInfo.first_name') ? 'invalid' : '' }}">
        <label class="form-label" for="first_name">{{ trans('cruds.employeeInfo.fields.first_name') }}</label>
        <input class="form-control" type="text" name="first_name" id="first_name" wire:model.defer="employeeInfo.first_name">
        <div class="validation-message">
            {{ $errors->first('employeeInfo.first_name') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeInfo.fields.first_name_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeInfo.middle_name') ? 'invalid' : '' }}">
        <label class="form-label" for="middle_name">{{ trans('cruds.employeeInfo.fields.middle_name') }}</label>
        <input class="form-control" type="text" name="middle_name" id="middle_name" wire:model.defer="employeeInfo.middle_name">
        <div class="validation-message">
            {{ $errors->first('employeeInfo.middle_name') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeInfo.fields.middle_name_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeInfo.last_name') ? 'invalid' : '' }}">
        <label class="form-label" for="last_name">{{ trans('cruds.employeeInfo.fields.last_name') }}</label>
        <input class="form-control" type="text" name="last_name" id="last_name" wire:model.defer="employeeInfo.last_name">
        <div class="validation-message">
            {{ $errors->first('employeeInfo.last_name') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeInfo.fields.last_name_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeInfo.gender') ? 'invalid' : '' }}">
        <label class="form-label">{{ trans('cruds.employeeInfo.fields.gender') }}</label>
        @foreach($this->listsForFields['gender'] as $key => $value)
            <label class="radio-label"><input type="radio" name="gender" wire:model="employeeInfo.gender" value="{{ $key }}">{{ $value }}</label>
        @endforeach
        <div class="validation-message">
            {{ $errors->first('employeeInfo.gender') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeInfo.fields.gender_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeInfo.dob') ? 'invalid' : '' }}">
        <label class="form-label" for="dob">{{ trans('cruds.employeeInfo.fields.dob') }}</label>
        <x-date-picker class="form-control" wire:model="employeeInfo.dob" id="dob" name="dob" picker="date" />
        <div class="validation-message">
            {{ $errors->first('employeeInfo.dob') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeInfo.fields.dob_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeInfo.citizenship') ? 'invalid' : '' }}">
        <label class="form-label" for="citizenship">{{ trans('cruds.employeeInfo.fields.citizenship') }}</label>
        <input class="form-control" type="text" name="citizenship" id="citizenship" wire:model.defer="employeeInfo.citizenship">
        <div class="validation-message">
            {{ $errors->first('employeeInfo.citizenship') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeInfo.fields.citizenship_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeInfo.age') ? 'invalid' : '' }}">
        <label class="form-label" for="age">{{ trans('cruds.employeeInfo.fields.age') }}</label>
        <input class="form-control" type="number" name="age" id="age" wire:model.defer="employeeInfo.age" step="0.01">
        <div class="validation-message">
            {{ $errors->first('employeeInfo.age') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeInfo.fields.age_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeInfo.religion') ? 'invalid' : '' }}">
        <label class="form-label" for="religion">{{ trans('cruds.employeeInfo.fields.religion') }}</label>
        <input class="form-control" type="text" name="religion" id="religion" wire:model.defer="employeeInfo.religion">
        <div class="validation-message">
            {{ $errors->first('employeeInfo.religion') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeInfo.fields.religion_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeInfo.maritial_status') ? 'invalid' : '' }}">
        <label class="form-label">{{ trans('cruds.employeeInfo.fields.maritial_status') }}</label>
        <select class="form-control" wire:model="employeeInfo.maritial_status">
            <option value="null" disabled>{{ trans('global.pleaseSelect') }}...</option>
            @foreach($this->listsForFields['maritial_status'] as $key => $value)
                <option value="{{ $key }}">{{ $value }}</option>
            @endforeach
        </select>
        <div class="validation-message">
            {{ $errors->first('employeeInfo.maritial_status') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeInfo.fields.maritial_status_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeInfo.blood_group') ? 'invalid' : '' }}">
        <label class="form-label" for="blood_group">{{ trans('cruds.employeeInfo.fields.blood_group') }}</label>
        <input class="form-control" type="text" name="blood_group" id="blood_group" wire:model.defer="employeeInfo.blood_group">
        <div class="validation-message">
            {{ $errors->first('employeeInfo.blood_group') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeInfo.fields.blood_group_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeInfo.email') ? 'invalid' : '' }}">
        <label class="form-label" for="email">{{ trans('cruds.employeeInfo.fields.email') }}</label>
        <input class="form-control" type="email" name="email" id="email" wire:model.defer="employeeInfo.email">
        <div class="validation-message">
            {{ $errors->first('employeeInfo.email') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeInfo.fields.email_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeInfo.present_address_line_1') ? 'invalid' : '' }}">
        <label class="form-label" for="present_address_line_1">{{ trans('cruds.employeeInfo.fields.present_address_line_1') }}</label>
        <input class="form-control" type="text" name="present_address_line_1" id="present_address_line_1" wire:model.defer="employeeInfo.present_address_line_1">
        <div class="validation-message">
            {{ $errors->first('employeeInfo.present_address_line_1') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeInfo.fields.present_address_line_1_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeInfo.present_address_line_2') ? 'invalid' : '' }}">
        <label class="form-label" for="present_address_line_2">{{ trans('cruds.employeeInfo.fields.present_address_line_2') }}</label>
        <input class="form-control" type="text" name="present_address_line_2" id="present_address_line_2" wire:model.defer="employeeInfo.present_address_line_2">
        <div class="validation-message">
            {{ $errors->first('employeeInfo.present_address_line_2') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeInfo.fields.present_address_line_2_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeInfo.present_address_line_3') ? 'invalid' : '' }}">
        <label class="form-label" for="present_address_line_3">{{ trans('cruds.employeeInfo.fields.present_address_line_3') }}</label>
        <input class="form-control" type="text" name="present_address_line_3" id="present_address_line_3" wire:model.defer="employeeInfo.present_address_line_3">
        <div class="validation-message">
            {{ $errors->first('employeeInfo.present_address_line_3') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeInfo.fields.present_address_line_3_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeInfo.present_address_line_4') ? 'invalid' : '' }}">
        <label class="form-label" for="present_address_line_4">{{ trans('cruds.employeeInfo.fields.present_address_line_4') }}</label>
        <input class="form-control" type="text" name="present_address_line_4" id="present_address_line_4" wire:model.defer="employeeInfo.present_address_line_4">
        <div class="validation-message">
            {{ $errors->first('employeeInfo.present_address_line_4') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeInfo.fields.present_address_line_4_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeInfo.present_address_district') ? 'invalid' : '' }}">
        <label class="form-label" for="present_address_district">{{ trans('cruds.employeeInfo.fields.present_address_district') }}</label>
        <input class="form-control" type="text" name="present_address_district" id="present_address_district" wire:model.defer="employeeInfo.present_address_district">
        <div class="validation-message">
            {{ $errors->first('employeeInfo.present_address_district') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeInfo.fields.present_address_district_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeInfo.present_address_pin') ? 'invalid' : '' }}">
        <label class="form-label" for="present_address_pin">{{ trans('cruds.employeeInfo.fields.present_address_pin') }}</label>
        <input class="form-control" type="text" name="present_address_pin" id="present_address_pin" wire:model.defer="employeeInfo.present_address_pin">
        <div class="validation-message">
            {{ $errors->first('employeeInfo.present_address_pin') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeInfo.fields.present_address_pin_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeInfo.present_address_state') ? 'invalid' : '' }}">
        <label class="form-label" for="present_address_state">{{ trans('cruds.employeeInfo.fields.present_address_state') }}</label>
        <input class="form-control" type="text" name="present_address_state" id="present_address_state" wire:model.defer="employeeInfo.present_address_state">
        <div class="validation-message">
            {{ $errors->first('employeeInfo.present_address_state') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeInfo.fields.present_address_state_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeInfo.present_address_landmark') ? 'invalid' : '' }}">
        <label class="form-label" for="present_address_landmark">{{ trans('cruds.employeeInfo.fields.present_address_landmark') }}</label>
        <input class="form-control" type="text" name="present_address_landmark" id="present_address_landmark" wire:model.defer="employeeInfo.present_address_landmark">
        <div class="validation-message">
            {{ $errors->first('employeeInfo.present_address_landmark') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeInfo.fields.present_address_landmark_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeInfo.permanent_address_line_1') ? 'invalid' : '' }}">
        <label class="form-label" for="permanent_address_line_1">{{ trans('cruds.employeeInfo.fields.permanent_address_line_1') }}</label>
        <input class="form-control" type="text" name="permanent_address_line_1" id="permanent_address_line_1" wire:model.defer="employeeInfo.permanent_address_line_1">
        <div class="validation-message">
            {{ $errors->first('employeeInfo.permanent_address_line_1') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeInfo.fields.permanent_address_line_1_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeInfo.permanent_address_line_2') ? 'invalid' : '' }}">
        <label class="form-label" for="permanent_address_line_2">{{ trans('cruds.employeeInfo.fields.permanent_address_line_2') }}</label>
        <input class="form-control" type="text" name="permanent_address_line_2" id="permanent_address_line_2" wire:model.defer="employeeInfo.permanent_address_line_2">
        <div class="validation-message">
            {{ $errors->first('employeeInfo.permanent_address_line_2') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeInfo.fields.permanent_address_line_2_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeInfo.permanent_address_line_3') ? 'invalid' : '' }}">
        <label class="form-label" for="permanent_address_line_3">{{ trans('cruds.employeeInfo.fields.permanent_address_line_3') }}</label>
        <input class="form-control" type="text" name="permanent_address_line_3" id="permanent_address_line_3" wire:model.defer="employeeInfo.permanent_address_line_3">
        <div class="validation-message">
            {{ $errors->first('employeeInfo.permanent_address_line_3') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeInfo.fields.permanent_address_line_3_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeInfo.permanent_address_line_4') ? 'invalid' : '' }}">
        <label class="form-label" for="permanent_address_line_4">{{ trans('cruds.employeeInfo.fields.permanent_address_line_4') }}</label>
        <input class="form-control" type="text" name="permanent_address_line_4" id="permanent_address_line_4" wire:model.defer="employeeInfo.permanent_address_line_4">
        <div class="validation-message">
            {{ $errors->first('employeeInfo.permanent_address_line_4') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeInfo.fields.permanent_address_line_4_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeInfo.permanent_address_district') ? 'invalid' : '' }}">
        <label class="form-label" for="permanent_address_district">{{ trans('cruds.employeeInfo.fields.permanent_address_district') }}</label>
        <input class="form-control" type="text" name="permanent_address_district" id="permanent_address_district" wire:model.defer="employeeInfo.permanent_address_district">
        <div class="validation-message">
            {{ $errors->first('employeeInfo.permanent_address_district') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeInfo.fields.permanent_address_district_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeInfo.permanent_address_pin') ? 'invalid' : '' }}">
        <label class="form-label" for="permanent_address_pin">{{ trans('cruds.employeeInfo.fields.permanent_address_pin') }}</label>
        <input class="form-control" type="text" name="permanent_address_pin" id="permanent_address_pin" wire:model.defer="employeeInfo.permanent_address_pin">
        <div class="validation-message">
            {{ $errors->first('employeeInfo.permanent_address_pin') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeInfo.fields.permanent_address_pin_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeInfo.permanent_address_state') ? 'invalid' : '' }}">
        <label class="form-label" for="permanent_address_state">{{ trans('cruds.employeeInfo.fields.permanent_address_state') }}</label>
        <input class="form-control" type="text" name="permanent_address_state" id="permanent_address_state" wire:model.defer="employeeInfo.permanent_address_state">
        <div class="validation-message">
            {{ $errors->first('employeeInfo.permanent_address_state') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeInfo.fields.permanent_address_state_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeInfo.permanent_address_landmark') ? 'invalid' : '' }}">
        <label class="form-label" for="permanent_address_landmark">{{ trans('cruds.employeeInfo.fields.permanent_address_landmark') }}</label>
        <input class="form-control" type="text" name="permanent_address_landmark" id="permanent_address_landmark" wire:model.defer="employeeInfo.permanent_address_landmark">
        <div class="validation-message">
            {{ $errors->first('employeeInfo.permanent_address_landmark') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeInfo.fields.permanent_address_landmark_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeInfo.personal_phone') ? 'invalid' : '' }}">
        <label class="form-label" for="personal_phone">{{ trans('cruds.employeeInfo.fields.personal_phone') }}</label>
        <input class="form-control" type="text" name="personal_phone" id="personal_phone" wire:model.defer="employeeInfo.personal_phone">
        <div class="validation-message">
            {{ $errors->first('employeeInfo.personal_phone') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeInfo.fields.personal_phone_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeInfo.present_residence_phone') ? 'invalid' : '' }}">
        <label class="form-label" for="present_residence_phone">{{ trans('cruds.employeeInfo.fields.present_residence_phone') }}</label>
        <input class="form-control" type="text" name="present_residence_phone" id="present_residence_phone" wire:model.defer="employeeInfo.present_residence_phone">
        <div class="validation-message">
            {{ $errors->first('employeeInfo.present_residence_phone') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeInfo.fields.present_residence_phone_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeInfo.permanent_residence_phone') ? 'invalid' : '' }}">
        <label class="form-label" for="permanent_residence_phone">{{ trans('cruds.employeeInfo.fields.permanent_residence_phone') }}</label>
        <input class="form-control" type="text" name="permanent_residence_phone" id="permanent_residence_phone" wire:model.defer="employeeInfo.permanent_residence_phone">
        <div class="validation-message">
            {{ $errors->first('employeeInfo.permanent_residence_phone') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeInfo.fields.permanent_residence_phone_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeInfo.emergency_contact_1_name') ? 'invalid' : '' }}">
        <label class="form-label" for="emergency_contact_1_name">{{ trans('cruds.employeeInfo.fields.emergency_contact_1_name') }}</label>
        <input class="form-control" type="text" name="emergency_contact_1_name" id="emergency_contact_1_name" wire:model.defer="employeeInfo.emergency_contact_1_name">
        <div class="validation-message">
            {{ $errors->first('employeeInfo.emergency_contact_1_name') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeInfo.fields.emergency_contact_1_name_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeInfo.emergency_contact_1_relation') ? 'invalid' : '' }}">
        <label class="form-label" for="emergency_contact_1_relation">{{ trans('cruds.employeeInfo.fields.emergency_contact_1_relation') }}</label>
        <input class="form-control" type="text" name="emergency_contact_1_relation" id="emergency_contact_1_relation" wire:model.defer="employeeInfo.emergency_contact_1_relation">
        <div class="validation-message">
            {{ $errors->first('employeeInfo.emergency_contact_1_relation') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeInfo.fields.emergency_contact_1_relation_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeInfo.emergency_contact_1_phone') ? 'invalid' : '' }}">
        <label class="form-label" for="emergency_contact_1_phone">{{ trans('cruds.employeeInfo.fields.emergency_contact_1_phone') }}</label>
        <input class="form-control" type="text" name="emergency_contact_1_phone" id="emergency_contact_1_phone" wire:model.defer="employeeInfo.emergency_contact_1_phone">
        <div class="validation-message">
            {{ $errors->first('employeeInfo.emergency_contact_1_phone') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeInfo.fields.emergency_contact_1_phone_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeInfo.emergency_contact_2_name') ? 'invalid' : '' }}">
        <label class="form-label" for="emergency_contact_2_name">{{ trans('cruds.employeeInfo.fields.emergency_contact_2_name') }}</label>
        <input class="form-control" type="text" name="emergency_contact_2_name" id="emergency_contact_2_name" wire:model.defer="employeeInfo.emergency_contact_2_name">
        <div class="validation-message">
            {{ $errors->first('employeeInfo.emergency_contact_2_name') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeInfo.fields.emergency_contact_2_name_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeInfo.emergency_contact_2_relation') ? 'invalid' : '' }}">
        <label class="form-label" for="emergency_contact_2_relation">{{ trans('cruds.employeeInfo.fields.emergency_contact_2_relation') }}</label>
        <input class="form-control" type="text" name="emergency_contact_2_relation" id="emergency_contact_2_relation" wire:model.defer="employeeInfo.emergency_contact_2_relation">
        <div class="validation-message">
            {{ $errors->first('employeeInfo.emergency_contact_2_relation') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeInfo.fields.emergency_contact_2_relation_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeInfo.emergency_contact_2_phone') ? 'invalid' : '' }}">
        <label class="form-label" for="emergency_contact_2_phone">{{ trans('cruds.employeeInfo.fields.emergency_contact_2_phone') }}</label>
        <input class="form-control" type="text" name="emergency_contact_2_phone" id="emergency_contact_2_phone" wire:model.defer="employeeInfo.emergency_contact_2_phone">
        <div class="validation-message">
            {{ $errors->first('employeeInfo.emergency_contact_2_phone') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeInfo.fields.emergency_contact_2_phone_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeInfo.doj') ? 'invalid' : '' }}">
        <label class="form-label" for="doj">{{ trans('cruds.employeeInfo.fields.doj') }}</label>
        <x-date-picker class="form-control" wire:model="employeeInfo.doj" id="doj" name="doj" picker="date" />
        <div class="validation-message">
            {{ $errors->first('employeeInfo.doj') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeInfo.fields.doj_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeInfo.department') ? 'invalid' : '' }}">
        <label class="form-label" for="department">{{ trans('cruds.employeeInfo.fields.department') }}</label>
        <input class="form-control" type="text" name="department" id="department" wire:model.defer="employeeInfo.department">
        <div class="validation-message">
            {{ $errors->first('employeeInfo.department') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeInfo.fields.department_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeInfo.job_desgination_id') ? 'invalid' : '' }}">
        <label class="form-label" for="job_desgination">{{ trans('cruds.employeeInfo.fields.job_desgination') }}</label>
        <x-select-list class="form-control" id="job_desgination" name="job_desgination" :options="$this->listsForFields['job_desgination']" wire:model="employeeInfo.job_desgination_id" />
        <div class="validation-message">
            {{ $errors->first('employeeInfo.job_desgination_id') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeInfo.fields.job_desgination_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeInfo.esic') ? 'invalid' : '' }}">
        <label class="form-label" for="esic">{{ trans('cruds.employeeInfo.fields.esic') }}</label>
        <input class="form-control" type="text" name="esic" id="esic" wire:model.defer="employeeInfo.esic">
        <div class="validation-message">
            {{ $errors->first('employeeInfo.esic') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeInfo.fields.esic_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeInfo.uan') ? 'invalid' : '' }}">
        <label class="form-label" for="uan">{{ trans('cruds.employeeInfo.fields.uan') }}</label>
        <input class="form-control" type="text" name="uan" id="uan" wire:model.defer="employeeInfo.uan">
        <div class="validation-message">
            {{ $errors->first('employeeInfo.uan') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeInfo.fields.uan_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeInfo.aadhaar') ? 'invalid' : '' }}">
        <label class="form-label" for="aadhaar">{{ trans('cruds.employeeInfo.fields.aadhaar') }}</label>
        <input class="form-control" type="text" name="aadhaar" id="aadhaar" wire:model.defer="employeeInfo.aadhaar">
        <div class="validation-message">
            {{ $errors->first('employeeInfo.aadhaar') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeInfo.fields.aadhaar_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeInfo.salary_ac_no') ? 'invalid' : '' }}">
        <label class="form-label" for="salary_ac_no">{{ trans('cruds.employeeInfo.fields.salary_ac_no') }}</label>
        <input class="form-control" type="text" name="salary_ac_no" id="salary_ac_no" wire:model.defer="employeeInfo.salary_ac_no">
        <div class="validation-message">
            {{ $errors->first('employeeInfo.salary_ac_no') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeInfo.fields.salary_ac_no_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeInfo.salary_ac_bank') ? 'invalid' : '' }}">
        <label class="form-label" for="salary_ac_bank">{{ trans('cruds.employeeInfo.fields.salary_ac_bank') }}</label>
        <input class="form-control" type="text" name="salary_ac_bank" id="salary_ac_bank" wire:model.defer="employeeInfo.salary_ac_bank">
        <div class="validation-message">
            {{ $errors->first('employeeInfo.salary_ac_bank') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeInfo.fields.salary_ac_bank_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeInfo.salary_ac_ifsc') ? 'invalid' : '' }}">
        <label class="form-label" for="salary_ac_ifsc">{{ trans('cruds.employeeInfo.fields.salary_ac_ifsc') }}</label>
        <input class="form-control" type="text" name="salary_ac_ifsc" id="salary_ac_ifsc" wire:model.defer="employeeInfo.salary_ac_ifsc">
        <div class="validation-message">
            {{ $errors->first('employeeInfo.salary_ac_ifsc') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeInfo.fields.salary_ac_ifsc_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeInfo.pm_basic_salary') ? 'invalid' : '' }}">
        <label class="form-label" for="pm_basic_salary">{{ trans('cruds.employeeInfo.fields.pm_basic_salary') }}</label>
        <input class="form-control" type="number" name="pm_basic_salary" id="pm_basic_salary" wire:model.defer="employeeInfo.pm_basic_salary" step="0.01">
        <div class="validation-message">
            {{ $errors->first('employeeInfo.pm_basic_salary') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeInfo.fields.pm_basic_salary_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeInfo.pm_hra') ? 'invalid' : '' }}">
        <label class="form-label" for="pm_hra">{{ trans('cruds.employeeInfo.fields.pm_hra') }}</label>
        <input class="form-control" type="number" name="pm_hra" id="pm_hra" wire:model.defer="employeeInfo.pm_hra" step="0.01">
        <div class="validation-message">
            {{ $errors->first('employeeInfo.pm_hra') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeInfo.fields.pm_hra_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeInfo.pm_pf') ? 'invalid' : '' }}">
        <label class="form-label" for="pm_pf">{{ trans('cruds.employeeInfo.fields.pm_pf') }}</label>
        <input class="form-control" type="number" name="pm_pf" id="pm_pf" wire:model.defer="employeeInfo.pm_pf" step="0.01">
        <div class="validation-message">
            {{ $errors->first('employeeInfo.pm_pf') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeInfo.fields.pm_pf_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeInfo.pm_esic') ? 'invalid' : '' }}">
        <label class="form-label" for="pm_esic">{{ trans('cruds.employeeInfo.fields.pm_esic') }}</label>
        <input class="form-control" type="number" name="pm_esic" id="pm_esic" wire:model.defer="employeeInfo.pm_esic" step="0.01">
        <div class="validation-message">
            {{ $errors->first('employeeInfo.pm_esic') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeInfo.fields.pm_esic_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeInfo.pm_ptax') ? 'invalid' : '' }}">
        <label class="form-label" for="pm_ptax">{{ trans('cruds.employeeInfo.fields.pm_ptax') }}</label>
        <input class="form-control" type="number" name="pm_ptax" id="pm_ptax" wire:model.defer="employeeInfo.pm_ptax" step="0.01">
        <div class="validation-message">
            {{ $errors->first('employeeInfo.pm_ptax') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeInfo.fields.pm_ptax_helper') }}
        </div>
    </div>

    <div class="form-group">
        <button class="btn btn-indigo mr-2" type="submit">
            {{ trans('global.save') }}
        </button>
        <a href="{{ route('admin.employee-infos.index') }}" class="btn btn-secondary">
            {{ trans('global.cancel') }}
        </a>
    </div>
</form>