<form wire:submit.prevent="submit" class="pt-3">

    <div class="form-group {{ $errors->has('employeeFamilyDetail.employee_info_id') ? 'invalid' : '' }}">
        <label class="form-label" for="employee_info">{{ trans('cruds.employeeFamilyDetail.fields.employee_info') }}</label>
        <x-select-list class="form-control" id="employee_info" name="employee_info" :options="$this->listsForFields['employee_info']" wire:model="employeeFamilyDetail.employee_info_id" />
        <div class="validation-message">
            {{ $errors->first('employeeFamilyDetail.employee_info_id') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeFamilyDetail.fields.employee_info_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeFamilyDetail.relation') ? 'invalid' : '' }}">
        <label class="form-label">{{ trans('cruds.employeeFamilyDetail.fields.relation') }}</label>
        @foreach($this->listsForFields['relation'] as $key => $value)
            <label class="radio-label"><input type="radio" name="relation" wire:model="employeeFamilyDetail.relation" value="{{ $key }}">{{ $value }}</label>
        @endforeach
        <div class="validation-message">
            {{ $errors->first('employeeFamilyDetail.relation') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeFamilyDetail.fields.relation_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeFamilyDetail.name') ? 'invalid' : '' }}">
        <label class="form-label" for="name">{{ trans('cruds.employeeFamilyDetail.fields.name') }}</label>
        <input class="form-control" type="text" name="name" id="name" wire:model.defer="employeeFamilyDetail.name">
        <div class="validation-message">
            {{ $errors->first('employeeFamilyDetail.name') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeFamilyDetail.fields.name_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeFamilyDetail.is_dependent') ? 'invalid' : '' }}">
        <input class="form-control" type="checkbox" name="is_dependent" id="is_dependent" wire:model.defer="employeeFamilyDetail.is_dependent">
        <label class="form-label inline ml-1" for="is_dependent">{{ trans('cruds.employeeFamilyDetail.fields.is_dependent') }}</label>
        <div class="validation-message">
            {{ $errors->first('employeeFamilyDetail.is_dependent') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeFamilyDetail.fields.is_dependent_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeFamilyDetail.profession') ? 'invalid' : '' }}">
        <label class="form-label" for="profession">{{ trans('cruds.employeeFamilyDetail.fields.profession') }}</label>
        <input class="form-control" type="text" name="profession" id="profession" wire:model.defer="employeeFamilyDetail.profession">
        <div class="validation-message">
            {{ $errors->first('employeeFamilyDetail.profession') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeFamilyDetail.fields.profession_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeFamilyDetail.office_name_address') ? 'invalid' : '' }}">
        <label class="form-label" for="office_name_address">{{ trans('cruds.employeeFamilyDetail.fields.office_name_address') }}</label>
        <textarea class="form-control" name="office_name_address" id="office_name_address" wire:model.defer="employeeFamilyDetail.office_name_address" rows="4"></textarea>
        <div class="validation-message">
            {{ $errors->first('employeeFamilyDetail.office_name_address') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeFamilyDetail.fields.office_name_address_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeFamilyDetail.office_contact') ? 'invalid' : '' }}">
        <label class="form-label" for="office_contact">{{ trans('cruds.employeeFamilyDetail.fields.office_contact') }}</label>
        <input class="form-control" type="text" name="office_contact" id="office_contact" wire:model.defer="employeeFamilyDetail.office_contact">
        <div class="validation-message">
            {{ $errors->first('employeeFamilyDetail.office_contact') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeFamilyDetail.fields.office_contact_helper') }}
        </div>
    </div>

    <div class="form-group">
        <button class="btn btn-indigo mr-2" type="submit">
            {{ trans('global.save') }}
        </button>
        <a href="{{ route('admin.employee-family-details.index') }}" class="btn btn-secondary">
            {{ trans('global.cancel') }}
        </a>
    </div>
</form>