<div>
    <div class="card-controls sm:flex">
        <div class="w-full sm:w-1/2">
            Per page:
            <select wire:model="perPage" class="form-select w-full sm:w-1/6">
                @foreach($paginationOptions as $value)
                    <option value="{{ $value }}">{{ $value }}</option>
                @endforeach
            </select>

            @can('employee_educational_info_delete')
                <button class="btn btn-rose ml-3 disabled:opacity-50 disabled:cursor-not-allowed" type="button" wire:click="confirm('deleteSelected')" wire:loading.attr="disabled" {{ $this->selectedCount ? '' : 'disabled' }}>
                    {{ __('Delete Selected') }}
                </button>
            @endcan

            @if(file_exists(app_path('Http/Livewire/ExcelExport.php')))
                <livewire:excel-export model="EmployeeEducationalInfo" format="csv" />
                <livewire:excel-export model="EmployeeEducationalInfo" format="xlsx" />
                <livewire:excel-export model="EmployeeEducationalInfo" format="pdf" />
            @endif




        </div>
        <div class="w-full sm:w-1/2 sm:text-right">
            Search:
            <input type="text" wire:model.debounce.300ms="search" class="w-full sm:w-1/3 inline-block" />
        </div>
    </div>
    <div wire:loading.delay>
        Loading...
    </div>

    <div class="overflow-hidden">
        <div class="overflow-x-auto">
            <table class="table table-index w-full">
                <thead>
                    <tr>
                        <th class="w-9">
                        </th>
                        <th class="w-28">
                            {{ trans('cruds.employeeEducationalInfo.fields.id') }}
                            @include('components.table.sort', ['field' => 'id'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeEducationalInfo.fields.employee_info') }}
                            @include('components.table.sort', ['field' => 'employee_info.first_name'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeEducationalInfo.fields.degree_name') }}
                            @include('components.table.sort', ['field' => 'degree_name'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeEducationalInfo.fields.year') }}
                            @include('components.table.sort', ['field' => 'year'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeEducationalInfo.fields.board_name') }}
                            @include('components.table.sort', ['field' => 'board_name'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeEducationalInfo.fields.subjects') }}
                            @include('components.table.sort', ['field' => 'subjects'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeEducationalInfo.fields.grade') }}
                            @include('components.table.sort', ['field' => 'grade'])
                        </th>
                        <th>
                            {{ trans('cruds.employeeEducationalInfo.fields.course_type') }}
                            @include('components.table.sort', ['field' => 'course_type'])
                        </th>
                        <th>
                        </th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($employeeEducationalInfos as $employeeEducationalInfo)
                        <tr>
                            <td>
                                <input type="checkbox" value="{{ $employeeEducationalInfo->id }}" wire:model="selected">
                            </td>
                            <td>
                                {{ $employeeEducationalInfo->id }}
                            </td>
                            <td>
                                @if($employeeEducationalInfo->employeeInfo)
                                    <span class="badge badge-relationship">{{ $employeeEducationalInfo->employeeInfo->first_name ?? '' }}</span>
                                @endif
                            </td>
                            <td>
                                {{ $employeeEducationalInfo->degree_name }}
                            </td>
                            <td>
                                {{ $employeeEducationalInfo->year }}
                            </td>
                            <td>
                                {{ $employeeEducationalInfo->board_name }}
                            </td>
                            <td>
                                {{ $employeeEducationalInfo->subjects }}
                            </td>
                            <td>
                                {{ $employeeEducationalInfo->grade }}
                            </td>
                            <td>
                                {{ $employeeEducationalInfo->course_type_label }}
                            </td>
                            <td>
                                <div class="flex justify-end">
                                    @can('employee_educational_info_show')
                                        <a class="btn btn-sm btn-info mr-2" href="{{ route('admin.employee-educational-infos.show', $employeeEducationalInfo) }}">
                                            {{ trans('global.view') }}
                                        </a>
                                    @endcan
                                    @can('employee_educational_info_edit')
                                        <a class="btn btn-sm btn-success mr-2" href="{{ route('admin.employee-educational-infos.edit', $employeeEducationalInfo) }}">
                                            {{ trans('global.edit') }}
                                        </a>
                                    @endcan
                                    @can('employee_educational_info_delete')
                                        <button class="btn btn-sm btn-rose mr-2" type="button" wire:click="confirm('delete', {{ $employeeEducationalInfo->id }})" wire:loading.attr="disabled">
                                            {{ trans('global.delete') }}
                                        </button>
                                    @endcan
                                </div>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="10">No entries found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <div class="card-body">
        <div class="pt-3">
            @if($this->selectedCount)
                <p class="text-sm leading-5">
                    <span class="font-medium">
                        {{ $this->selectedCount }}
                    </span>
                    {{ __('Entries selected') }}
                </p>
            @endif
            {{ $employeeEducationalInfos->links() }}
        </div>
    </div>
</div>

@push('scripts')
    <script>
        Livewire.on('confirm', e => {
    if (!confirm("{{ trans('global.areYouSure') }}")) {
        return
    }
@this[e.callback](...e.argv)
})
    </script>
@endpush