<form wire:submit.prevent="submit" class="pt-3">

    <div class="form-group {{ $errors->has('employeeEducationalInfo.employee_info_id') ? 'invalid' : '' }}">
        <label class="form-label" for="employee_info">{{ trans('cruds.employeeEducationalInfo.fields.employee_info') }}</label>
        <x-select-list class="form-control" id="employee_info" name="employee_info" :options="$this->listsForFields['employee_info']" wire:model="employeeEducationalInfo.employee_info_id" />
        <div class="validation-message">
            {{ $errors->first('employeeEducationalInfo.employee_info_id') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeEducationalInfo.fields.employee_info_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeEducationalInfo.degree_name') ? 'invalid' : '' }}">
        <label class="form-label" for="degree_name">{{ trans('cruds.employeeEducationalInfo.fields.degree_name') }}</label>
        <input class="form-control" type="text" name="degree_name" id="degree_name" wire:model.defer="employeeEducationalInfo.degree_name">
        <div class="validation-message">
            {{ $errors->first('employeeEducationalInfo.degree_name') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeEducationalInfo.fields.degree_name_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeEducationalInfo.year') ? 'invalid' : '' }}">
        <label class="form-label" for="year">{{ trans('cruds.employeeEducationalInfo.fields.year') }}</label>
        <input class="form-control" type="text" name="year" id="year" wire:model.defer="employeeEducationalInfo.year">
        <div class="validation-message">
            {{ $errors->first('employeeEducationalInfo.year') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeEducationalInfo.fields.year_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeEducationalInfo.board_name') ? 'invalid' : '' }}">
        <label class="form-label" for="board_name">{{ trans('cruds.employeeEducationalInfo.fields.board_name') }}</label>
        <input class="form-control" type="text" name="board_name" id="board_name" wire:model.defer="employeeEducationalInfo.board_name">
        <div class="validation-message">
            {{ $errors->first('employeeEducationalInfo.board_name') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeEducationalInfo.fields.board_name_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeEducationalInfo.subjects') ? 'invalid' : '' }}">
        <label class="form-label" for="subjects">{{ trans('cruds.employeeEducationalInfo.fields.subjects') }}</label>
        <input class="form-control" type="text" name="subjects" id="subjects" wire:model.defer="employeeEducationalInfo.subjects">
        <div class="validation-message">
            {{ $errors->first('employeeEducationalInfo.subjects') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeEducationalInfo.fields.subjects_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeEducationalInfo.grade') ? 'invalid' : '' }}">
        <label class="form-label" for="grade">{{ trans('cruds.employeeEducationalInfo.fields.grade') }}</label>
        <input class="form-control" type="text" name="grade" id="grade" wire:model.defer="employeeEducationalInfo.grade">
        <div class="validation-message">
            {{ $errors->first('employeeEducationalInfo.grade') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeEducationalInfo.fields.grade_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeEducationalInfo.course_type') ? 'invalid' : '' }}">
        <label class="form-label">{{ trans('cruds.employeeEducationalInfo.fields.course_type') }}</label>
        @foreach($this->listsForFields['course_type'] as $key => $value)
            <label class="radio-label"><input type="radio" name="course_type" wire:model="employeeEducationalInfo.course_type" value="{{ $key }}">{{ $value }}</label>
        @endforeach
        <div class="validation-message">
            {{ $errors->first('employeeEducationalInfo.course_type') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeEducationalInfo.fields.course_type_helper') }}
        </div>
    </div>

    <div class="form-group">
        <button class="btn btn-indigo mr-2" type="submit">
            {{ trans('global.save') }}
        </button>
        <a href="{{ route('admin.employee-educational-infos.index') }}" class="btn btn-secondary">
            {{ trans('global.cancel') }}
        </a>
    </div>
</form>