<form wire:submit.prevent="submit" class="pt-3">

    <div class="form-group {{ $errors->has('employeeAttendanceLog.date') ? 'invalid' : '' }}">
        <label class="form-label required" for="date">{{ trans('cruds.employeeAttendanceLog.fields.date') }}</label>
        <x-date-picker class="form-control" required wire:model="employeeAttendanceLog.date" id="date" name="date" picker="date" />
        <div class="validation-message">
            {{ $errors->first('employeeAttendanceLog.date') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeAttendanceLog.fields.date_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeAttendanceLog.user_id') ? 'invalid' : '' }}">
        <label class="form-label" for="user">{{ trans('cruds.employeeAttendanceLog.fields.user') }}</label>
        <x-select-list class="form-control" id="user" name="user" :options="$this->listsForFields['user']" wire:model="employeeAttendanceLog.user_id" />
        <div class="validation-message">
            {{ $errors->first('employeeAttendanceLog.user_id') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeAttendanceLog.fields.user_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeAttendanceLog.type') ? 'invalid' : '' }}">
        <label class="form-label">{{ trans('cruds.employeeAttendanceLog.fields.type') }}</label>
        @foreach($this->listsForFields['type'] as $key => $value)
            <label class="radio-label"><input type="radio" name="type" wire:model="employeeAttendanceLog.type" value="{{ $key }}">{{ $value }}</label>
        @endforeach
        <div class="validation-message">
            {{ $errors->first('employeeAttendanceLog.type') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeAttendanceLog.fields.type_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeAttendanceLog.coord_lat') ? 'invalid' : '' }}">
        <label class="form-label" for="coord_lat">{{ trans('cruds.employeeAttendanceLog.fields.coord_lat') }}</label>
        <input class="form-control" type="text" name="coord_lat" id="coord_lat" wire:model.defer="employeeAttendanceLog.coord_lat">
        <div class="validation-message">
            {{ $errors->first('employeeAttendanceLog.coord_lat') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeAttendanceLog.fields.coord_lat_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeAttendanceLog.coord_long') ? 'invalid' : '' }}">
        <label class="form-label" for="coord_long">{{ trans('cruds.employeeAttendanceLog.fields.coord_long') }}</label>
        <input class="form-control" type="text" name="coord_long" id="coord_long" wire:model.defer="employeeAttendanceLog.coord_long">
        <div class="validation-message">
            {{ $errors->first('employeeAttendanceLog.coord_long') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeAttendanceLog.fields.coord_long_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeAttendanceLog.coord_accu') ? 'invalid' : '' }}">
        <label class="form-label" for="coord_accu">{{ trans('cruds.employeeAttendanceLog.fields.coord_accu') }}</label>
        <input class="form-control" type="text" name="coord_accu" id="coord_accu" wire:model.defer="employeeAttendanceLog.coord_accu">
        <div class="validation-message">
            {{ $errors->first('employeeAttendanceLog.coord_accu') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeAttendanceLog.fields.coord_accu_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeAttendanceLog.location') ? 'invalid' : '' }}">
        <label class="form-label" for="location">{{ trans('cruds.employeeAttendanceLog.fields.location') }}</label>
        <textarea class="form-control" name="location" id="location" wire:model.defer="employeeAttendanceLog.location" rows="4"></textarea>
        <div class="validation-message">
            {{ $errors->first('employeeAttendanceLog.location') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeAttendanceLog.fields.location_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeAttendanceLog.signed_in_at') ? 'invalid' : '' }}">
        <label class="form-label" for="signed_in_at">{{ trans('cruds.employeeAttendanceLog.fields.signed_in_at') }}</label>
        <x-date-picker class="form-control" wire:model="employeeAttendanceLog.signed_in_at" id="signed_in_at" name="signed_in_at" />
        <div class="validation-message">
            {{ $errors->first('employeeAttendanceLog.signed_in_at') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeAttendanceLog.fields.signed_in_at_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeAttendanceLog.signed_out_at') ? 'invalid' : '' }}">
        <label class="form-label" for="signed_out_at">{{ trans('cruds.employeeAttendanceLog.fields.signed_out_at') }}</label>
        <x-date-picker class="form-control" wire:model="employeeAttendanceLog.signed_out_at" id="signed_out_at" name="signed_out_at" />
        <div class="validation-message">
            {{ $errors->first('employeeAttendanceLog.signed_out_at') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeAttendanceLog.fields.signed_out_at_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('mediaCollections.employee_attendance_log_sign_in_photo') ? 'invalid' : '' }}">
        <label class="form-label" for="sign_in_photo">{{ trans('cruds.employeeAttendanceLog.fields.sign_in_photo') }}</label>
        <x-dropzone id="sign_in_photo" name="sign_in_photo" action="{{ route('admin.employee-attendance-logs.storeMedia') }}" collection-name="employee_attendance_log_sign_in_photo" max-file-size="2" max-width="4096" max-height="4096" max-files="1" />
        <div class="validation-message">
            {{ $errors->first('mediaCollections.employee_attendance_log_sign_in_photo') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeAttendanceLog.fields.sign_in_photo_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('mediaCollections.employee_attendance_log_sign_out_photo') ? 'invalid' : '' }}">
        <label class="form-label" for="sign_out_photo">{{ trans('cruds.employeeAttendanceLog.fields.sign_out_photo') }}</label>
        <x-dropzone id="sign_out_photo" name="sign_out_photo" action="{{ route('admin.employee-attendance-logs.storeMedia') }}" collection-name="employee_attendance_log_sign_out_photo" max-file-size="2" max-width="4096" max-height="4096" max-files="1" />
        <div class="validation-message">
            {{ $errors->first('mediaCollections.employee_attendance_log_sign_out_photo') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeAttendanceLog.fields.sign_out_photo_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeAttendanceLog.device') ? 'invalid' : '' }}">
        <label class="form-label" for="device">{{ trans('cruds.employeeAttendanceLog.fields.device') }}</label>
        <input class="form-control" type="text" name="device" id="device" wire:model.defer="employeeAttendanceLog.device">
        <div class="validation-message">
            {{ $errors->first('employeeAttendanceLog.device') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeAttendanceLog.fields.device_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('employeeAttendanceLog.attendance_from') ? 'invalid' : '' }}">
        <label class="form-label">{{ trans('cruds.employeeAttendanceLog.fields.attendance_from') }}</label>
        <select class="form-control" wire:model="employeeAttendanceLog.attendance_from">
            <option value="null" disabled>{{ trans('global.pleaseSelect') }}...</option>
            @foreach($this->listsForFields['attendance_from'] as $key => $value)
                <option value="{{ $key }}">{{ $value }}</option>
            @endforeach
        </select>
        <div class="validation-message">
            {{ $errors->first('employeeAttendanceLog.attendance_from') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeAttendanceLog.fields.attendance_from_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('task') ? 'invalid' : '' }}">
        <label class="form-label" for="task">{{ trans('cruds.employeeAttendanceLog.fields.task') }}</label>
        <x-select-list class="form-control" id="task" name="task" wire:model="task" :options="$this->listsForFields['task']" multiple />
        <div class="validation-message">
            {{ $errors->first('task') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.employeeAttendanceLog.fields.task_helper') }}
        </div>
    </div>

    <div class="form-group">
        <button class="btn btn-indigo mr-2" type="submit">
            {{ trans('global.save') }}
        </button>
        <a href="{{ route('admin.employee-attendance-logs.index') }}" class="btn btn-secondary">
            {{ trans('global.cancel') }}
        </a>
    </div>
</form>
