<div>

    @include('components.loading-spinner-full-page')
    <div>

        <div class="min-w-screen min-h-screen bg-gray-200 flex justify-center items-start px-5 py-5">
            <div class="rounded shadow-xl w-full bg-white p-5 text-gray-700" style="max-width:900px">
                <h1 class="text-3xl font-semibold leading-tight text-indigo-500">Zones</h1>
                <span class="text-sm text-gray">
                    Zones > Circles > Branches
                </span>
                <hr class="my-5 -mx-5">
                <div class="-mx-5" x-data="fileTree()">
                    <ul>
                        @foreach ($zones2 as $zone)
                            @php
                                $l1Ref = 'ref' . uniqid();
                                $l1HasChildren = $zone->circles->count() > 0;
                            @endphp
                            <li class="" id="{{ uniqid() }}">
                                <a href="#" x-class="block px-5 py-1 hover:text-gray-900 has-children"
                                    id="{{ uniqid() }}" @class([
                                        'block px-5 py-1 hover:text-gray-900',
                                        'has-children' => $l1HasChildren,
                                    ])
                                    @click.prevent="toggleLevel($refs.{{ $l1Ref }})"><i
                                        @class([
                                            'mdi text-orange-500 ',
                                            'mdi-folder-outline' => $l1HasChildren,
                                            'mdi-file-outline' => !$l1HasChildren,
                                        ])></i> {{ $zone->name }}</a>
                                @if ($l1HasChildren)
                                    <ul x-ref="{{ $l1Ref }}" style="display: none;" id="{{ uniqid() }}"
                                        class="pl-5 pb-1 transition-all duration-1000 opacity-0 opacity-100">
                                        @foreach ($zone->circles as $circle)
                                            @php
                                                $l2Ref = 'ref' . uniqid();
                                                $l2HasChildren = $circle->client_branches->count() > 0;
                                            @endphp
                                            <li id="{{ uniqid() }}">
                                                <a href="#" --x-class="block px-5 py-1 hover:text-gray-900"
                                                    @class([
                                                        'block px-5 py-1 hover:text-gray-900',
                                                        'has-children' => $l2HasChildren,
                                                    ]) id="{{ uniqid() }}"
                                                    @click.prevent="toggleLevel($refs.{{ $l2Ref }})">
                                                    <i @class([
                                                        'mdi text-orange-500 ',
                                                        'mdi-folder-outline' => $l2HasChildren,
                                                        'mdi-file-outline' => !$l2HasChildren,
                                                    ])></i>{{ $circle->name }}</a>
                                                @if ($l2HasChildren)
                                                    <ul x-ref="{{ $l2Ref }}" id="{{ uniqid() }}"
                                                        class="pl-5 pb-1 transition-all duration-1000 opacity-0 opacity-100"
                                                        style="display: none;">
                                                        @foreach ($circle->client_branches as $branch)
                                                            @php
                                                                $l3Ref = 'ref' . uniqid();
                                                            @endphp
                                                            <li id="{{ uniqid() }}">
                                                                {{-- <a href="#"
                                                                    class="block px-5 py-1 hover:text-gray-900"
                                                                    id="{{ uniqid() }}"
                                                                    @click.prevent="toggleLevel($refs.{{ $l3Ref }})">
                                                                    <i
                                                                        class="mdi mdi-file-outline text-gray-600"></i>{{ $branch->name }}</a> --}}
                                                                <p class="px-2 py-2 ">
                                                                    <span
                                                                        class="px-2 py-2 text-blue-400">#{{ $branch->id }}&nbsp;{{ $branch->name }} ({{$branch->client->name}})</span> &nbsp;
                                                                    <a href="#"
                                                                        class="block px-5 py-1 hover:text-indigo-600 text-xs">
                                                                        View Tickets</a>
                                                                </p>
                                                            </li>
                                                        @endforeach
                                                    </ul>
                                                @endif

                                            </li>
                                        @endforeach
                                    </ul>
                                @endif
                            </li>
                        @endforeach
                    </ul>
                </div>
            </div>
        </div>

    </div>
</div>

@push('scripts')
    <script>
        // const levels = @json($zonesJson);
        let fileTree = function() {
            return {
                // levels: levels,
                renderLevel: function(obj, i) {
                    let ref = "l" + Math.random().toString(36).substring(7);
                    let html = `<a href="#" class="block px-5 py-1 hover:text-gray-900" :class="{'has-children':level.children}" x-html="(level.children?'<i class=\\'mdi mdi-folder-outline text-orange-500\\'></i>':'<i class=\\'mdi mdi-file-outline text-gray-600\\'></i>')+' '+level.title" ${
        obj.children ? `@click.prevent="toggleLevel($refs.${ref})"` : ""
      }></a>`;

                    if (obj.children) {
                        html += `<ul style="display:none;" x-ref="${ref}" class="pl-5 pb-1 transition-all duration-1000 opacity-0">
                            <template x-for='(level,i) in level.children'>
                                <li x-html="renderLevel(level,i)"></li>
                            </template>
                        </ul>`;
                    }

                    return html;
                },
                showLevel: function(el) {
                    if (el) {
                        if (el.style.length === 1 && el.style.display === "none") {
                            el.removeAttribute("style");
                        } else {
                            el.style.removeProperty("display");
                        }
                    }
                    setTimeout(() => {
                        el.previousElementSibling
                            .querySelector("i.mdi")
                            .classList.add("mdi-folder-open-outline");
                        el.previousElementSibling
                            .querySelector("i.mdi")
                            .classList.remove("mdi-folder-outline");
                        el.classList.add("opacity-100");
                    }, 10);
                },
                hideLevel: function(el) {
                    if (el) {
                        el.style.display = "none";
                        el.classList.remove("opacity-100");
                        el.previousElementSibling
                            .querySelector("i.mdi")
                            .classList.remove("mdi-folder-open-outline");
                        el.previousElementSibling
                            .querySelector("i.mdi")
                            .classList.add("mdi-folder-outline");

                        let refs = el.querySelectorAll("ul[x-ref]");
                        for (var i = 0; i < refs.length; i++) {
                            this.hideLevel(refs[i]);
                        }
                    }
                },
                toggleLevel: function(el) {
                    console.log(el)
                    if (el && el.style.length && el.style.display === "none") {
                        this.showLevel(el);
                    } else {
                        this.hideLevel(el);
                    }
                }
            };
        };
    </script>
@endpush
