<div>
    <div class="card-controls sm:flex">
        <div class="w-full sm:w-1/2">
            Per page:
            <select wire:model="perPage" class="form-select w-full sm:w-1/6">
                @foreach($paginationOptions as $value)
                    <option value="{{ $value }}">{{ $value }}</option>
                @endforeach
            </select>

            @can('company_delete')
                <button class="btn btn-rose ml-3 disabled:opacity-50 disabled:cursor-not-allowed" type="button" wire:click="confirm('deleteSelected')" wire:loading.attr="disabled" {{ $this->selectedCount ? '' : 'disabled' }}>
                    {{ __('Delete Selected') }}
                </button>
            @endcan

            @if(file_exists(app_path('Http/Livewire/ExcelExport.php')))
                <livewire:excel-export model="Company" format="csv" />
                <livewire:excel-export model="Company" format="xlsx" />
                <livewire:excel-export model="Company" format="pdf" />
            @endif


            @can('company_create')
                <x-csv-import route="{{ route('admin.companies.csv.store') }}" />
            @endcan

        </div>
        <div class="w-full sm:w-1/2 sm:text-right">
            Search:
            <input type="text" wire:model.debounce.300ms="search" class="w-full sm:w-1/3 inline-block" />
        </div>
    </div>
    @include('components.loading-spinner-full-page')


    <div class="overflow-hidden">
        <div class="overflow-x-auto">
            <table class="table table-index w-full">
                <thead>
                    <tr>
                        <th class="w-9">
                        </th>
                        <th class="w-28">
                            {{ trans('cruds.company.fields.id') }}
                            @include('components.table.sort', ['field' => 'id'])
                        </th>
                        <th>
                            {{ trans('cruds.company.fields.name') }}
                            @include('components.table.sort', ['field' => 'name'])
                        </th>
                        <th>
                            {{ trans('cruds.company.fields.mailing_name') }}
                            @include('components.table.sort', ['field' => 'mailing_name'])
                        </th>
                        <th>
                            {{ trans('cruds.company.fields.address_line_one') }}
                            @include('components.table.sort', ['field' => 'address_line_one'])
                        </th>
                        <th>
                            {{ trans('cruds.company.fields.address_line_two') }}
                            @include('components.table.sort', ['field' => 'address_line_two'])
                        </th>
                        <th>
                            {{ trans('cruds.company.fields.state') }}
                            @include('components.table.sort', ['field' => 'state'])
                        </th>
                        <th>
                            {{ trans('cruds.company.fields.city') }}
                            @include('components.table.sort', ['field' => 'city'])
                        </th>
                        <th>
                            {{ trans('cruds.company.fields.pin') }}
                            @include('components.table.sort', ['field' => 'pin'])
                        </th>
                        <th>
                            {{ trans('cruds.company.fields.phone') }}
                            @include('components.table.sort', ['field' => 'phone'])
                        </th>
                        <th>
                            {{ trans('cruds.company.fields.email') }}
                            @include('components.table.sort', ['field' => 'email'])
                        </th>
                        <th>
                            {{ trans('cruds.company.fields.mobile') }}
                            @include('components.table.sort', ['field' => 'mobile'])
                        </th>
                        <th>
                            {{ trans('cruds.company.fields.fax_no') }}
                            @include('components.table.sort', ['field' => 'fax_no'])
                        </th>
                        <th>
                            {{ trans('cruds.company.fields.website') }}
                            @include('components.table.sort', ['field' => 'website'])
                        </th>
                        <th>
                            {{ trans('cruds.company.fields.gst_state') }}
                            @include('components.table.sort', ['field' => 'gst_state'])
                        </th>
                        <th>
                            {{ trans('cruds.company.fields.registration_type') }}
                            @include('components.table.sort', ['field' => 'registration_type'])
                        </th>
                        <th>
                            {{ trans('cruds.company.fields.gstin') }}
                            @include('components.table.sort', ['field' => 'gstin'])
                        </th>
                        <th>
                            {{ trans('cruds.company.fields.period_gstr_one') }}
                            @include('components.table.sort', ['field' => 'period_gstr_one'])
                        </th>
                        <th>
                            {{ trans('cruds.company.fields.eway_bill_is_applicable') }}
                            @include('components.table.sort', ['field' => 'eway_bill_is_applicable'])
                        </th>
                        <th>
                            {{ trans('cruds.company.fields.threshold_limit') }}
                            @include('components.table.sort', ['field' => 'threshold_limit'])
                        </th>
                        <th>
                            {{ trans('cruds.company.fields.apply_for_inter_state') }}
                            @include('components.table.sort', ['field' => 'apply_for_inter_state'])
                        </th>
                        <th>
                            {{ trans('cruds.company.fields.inter_threshold_limit') }}
                            @include('components.table.sort', ['field' => 'inter_threshold_limit'])
                        </th>
                        <th>
                        </th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($companies as $company)
                        <tr>
                            <td>
                                <input type="checkbox" value="{{ $company->id }}" wire:model="selected">
                            </td>
                            <td>
                                {{ $company->id }}
                            </td>
                            <td>
                                {{ $company->name }}
                            </td>
                            <td>
                                {{ $company->mailing_name }}
                            </td>
                            <td>
                                {{ $company->address_line_one }}
                            </td>
                            <td>
                                {{ $company->address_line_two }}
                            </td>
                            <td>
                                {{ $company->state }}
                            </td>
                            <td>
                                {{ $company->city }}
                            </td>
                            <td>
                                {{ $company->pin }}
                            </td>
                            <td>
                                {{ $company->phone }}
                            </td>
                            <td>
                                {{ $company->email }}
                            </td>
                            <td>
                                {{ $company->mobile }}
                            </td>
                            <td>
                                {{ $company->fax_no }}
                            </td>
                            <td>
                                {{ $company->website }}
                            </td>
                            <td>
                                {{ $company->gst_state }}
                            </td>
                            <td>
                                {{ $company->registration_type }}
                            </td>
                            <td>
                                {{ $company->gstin }}
                            </td>
                            <td>
                                {{ $company->period_gstr_one }}
                            </td>
                            <td>
                                {{ $company->eway_bill_is_applicable }}
                            </td>
                            <td>
                                {{ $company->threshold_limit }}
                            </td>
                            <td>
                                {{ $company->apply_for_inter_state }}
                            </td>
                            <td>
                                {{ $company->inter_threshold_limit }}
                            </td>
                            <td>
                                <div class="flex justify-end">
                                    @can('company_show')
                                        <a class="btn btn-sm btn-info mr-2" href="{{ route('admin.companies.show', $company) }}">
                                            {{ trans('global.view') }}
                                        </a>
                                    @endcan
                                    @can('company_edit')
                                        <a class="btn btn-sm btn-success mr-2" href="{{ route('admin.companies.edit', $company) }}">
                                            {{ trans('global.edit') }}
                                        </a>
                                    @endcan
                                    @can('company_delete')
                                        <button class="btn btn-sm btn-rose mr-2" type="button" wire:click="confirm('delete', {{ $company->id }})" wire:loading.attr="disabled">
                                            {{ trans('global.delete') }}
                                        </button>
                                    @endcan
                                </div>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="10">No entries found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <div class="card-body">
        <div class="pt-3">
            @if($this->selectedCount)
                <p class="text-sm leading-5">
                    <span class="font-medium">
                        {{ $this->selectedCount }}
                    </span>
                    {{ __('Entries selected') }}
                </p>
            @endif
            {{ $companies->links() }}
        </div>
    </div>
</div>

@push('scripts')
    <script>
        Livewire.on('confirm', e => {
    if (!confirm("{{ trans('global.areYouSure') }}")) {
        return
    }
@this[e.callback](...e.argv)
})
    </script>
@endpush
