<div>
    <div class="min-h-[340px] py-3 px-2 relative">
        @include('components.loading-spinner-full-page')

        <label for="">Products</label>
        <div class="relative">

            <div class="flex items-center w-full mb-2">
                <label for="simple-search" class="sr-only">Search</label>
                <div class="relative  w-full">
                    <div class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none">
                        <svg aria-hidden="true" class="w-5 h-5 text-gray-500 dark:text-gray-400" fill="currentColor"
                            viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd"
                                d="M8 4a4 4 0 100 8 4 4 0 000-8zM2 8a6 6 0 1110.89 3.476l4.817 4.817a1 1 0 01-1.414 1.414l-4.816-4.816A6 6 0 012 8z"
                                clip-rule="evenodd"></path>
                        </svg>
                    </div>
                    <input type="text" id="simpleSearchInput"
                        class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full pl-10 p-2.5  dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500"
                        wire:model.debounce.700ms="search" placeholder="Search" required>
                </div>
            </div>
        </div>

        <div class=" px-2 ">
            <label class="form-label required" for="roles">Filter by roles</label>
            <x-tags-list class="form-control" required id="roles" name="roles" wire:model="categoryIds"
                :options="$this->listsForFields['categories']" multiple />

        </div>
        {{-- @fjson($productIds) --}}
        <div class="overflow-x-auto mb-3">
            <table class="table table-index w-full">
                <thead>
                    <tr>
                        <th>Check</th>
                        <th>Product Name/Description</th>
                        <th>Price</th>
                        <th></th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($products as $p)
                        <tr class="" id="{{ uniqid() }}">
                            <td>
                                <input type="checkbox" wire:model="productIds" value="{{ $p->id }}">

                            </td>
                            <td>
                                <code>#{{ $p->id }}</code>
                                <span> {{ $p->name }} </span>
                                <span class="text-2xs block"> {{ $p->description }} </span>
                            </td>
                            <td>
                                ₹{{ $p->price }}
                            </td>
                            <td>
                            </td>
                            <td>
                            </td>
                        </tr>
                    @endforeach
                    @if ($products->count() == 0)
                        <tr>
                            <td class="text-center py-2" colspan="4">
                                No products found
                            </td>
                        </tr>
                    @endif
                </tbody>
            </table>
        </div>
        <div class="bg-gray-100 text-3xl text-white text-right sticky inset-x-0 bottom-5 p-4 shadow-lg drop-shadow-lg">
            @if (count($productIds) > 0)
                <button class="btn btn-indigo mr-2" wire:click="addProducts" type="button">
                    Add Products
                </button>
            @endif
            <button class="btn btn-danger mr-2" wire:click="closeModal" type="button">
                Cancel
            </button>
        </div>
    </div>
</div>
