<form wire:submit.prevent="submit" class="pt-3">
    @include('components.loading-spinner-full-page')


    <div class="form-group {{ $errors->has('client.client_group_id') ? 'invalid' : '' }}">
        <label class="form-label" for="client_group">{{ trans('cruds.client.fields.client_group') }}</label>
        <x-select-list class="form-control" id="client_group" name="client_group" :options="$this->listsForFields['client_group']" wire:model="client.client_group_id" />
        <div class="validation-message">
            {{ $errors->first('client.client_group_id') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.client.fields.client_group_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('client.state_id') ? 'invalid' : '' }}">
        <label class="form-label" for="state">{{ trans('cruds.client.fields.state') }}</label>
        <x-select-list class="form-control" id="state" name="state" :options="$this->listsForFields['state']" wire:model="client.state_id" />
        <div class="validation-message">
            {{ $errors->first('client.state_id') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.client.fields.state_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('client.name') ? 'invalid' : '' }}">
        <label class="form-label" for="name">{{ trans('cruds.client.fields.name') }}</label>
        <input class="form-control" type="text" name="name" id="name" wire:model.defer="client.name">
        <div class="validation-message">
            {{ $errors->first('client.name') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.client.fields.name_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('client.rhq_address') ? 'invalid' : '' }}">
        <label class="form-label" for="rhq_address">{{ trans('cruds.client.fields.rhq_address') }}</label>
        <input class="form-control" type="text" name="rhq_address" id="rhq_address" wire:model.defer="client.rhq_address">
        <div class="validation-message">
            {{ $errors->first('client.rhq_address') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.client.fields.rhq_address_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('client.rhq_phone') ? 'invalid' : '' }}">
        <label class="form-label" for="rhq_phone">{{ trans('cruds.client.fields.rhq_phone') }}</label>
        <input class="form-control" type="text" name="rhq_phone" id="rhq_phone" wire:model.defer="client.rhq_phone">
        <div class="validation-message">
            {{ $errors->first('client.rhq_phone') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.client.fields.rhq_phone_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('client.rhq_email') ? 'invalid' : '' }}">
        <label class="form-label" for="rhq_email">{{ trans('cruds.client.fields.rhq_email') }}</label>
        <input class="form-control" type="text" name="rhq_email" id="rhq_email" wire:model.defer="client.rhq_email">
        <div class="validation-message">
            {{ $errors->first('client.rhq_email') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.client.fields.rhq_email_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('client.gstin') ? 'invalid' : '' }}">
        <label class="form-label" for="gstin">{{ trans('cruds.client.fields.gstin') }}</label>
        <input class="form-control" type="text" name="gstin" id="gstin" wire:model.defer="client.gstin">
        <div class="validation-message">
            {{ $errors->first('client.gstin') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.client.fields.gstin_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('client.gst_reg_type') ? 'invalid' : '' }}">
        <label class="form-label">{{ trans('cruds.client.fields.gst_reg_type') }}</label>
        <select class="form-control" wire:model="client.gst_reg_type">
            <option value="null" disabled>{{ trans('global.pleaseSelect') }}...</option>
            @foreach($this->listsForFields['gst_reg_type'] as $key => $value)
                <option value="{{ $key }}">{{ $value }}</option>
            @endforeach
        </select>
        <div class="validation-message">
            {{ $errors->first('client.gst_reg_type') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.client.fields.gst_reg_type_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('client.is_active') ? 'invalid' : '' }}">
        <input class="form-control" type="checkbox" name="is_active" id="is_active" wire:model.defer="client.is_active">
        <label class="form-label inline ml-1" for="is_active">{{ trans('cruds.client.fields.is_active') }}</label>
        <div class="validation-message">
            {{ $errors->first('client.is_active') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.client.fields.is_active_helper') }}
        </div>
    </div>

    <div class="form-group">
        <button class="btn btn-indigo mr-2" type="submit">
            {{ trans('global.save') }}
        </button>
        <a href="{{ route('admin.clients.index') }}" class="btn btn-secondary">
            {{ trans('global.cancel') }}
        </a>
    </div>
</form>
