<div>
    <div class="card-controls sm:flex">
        <div class="w-full sm:w-1/2">
            Per page:
            <select wire:model="perPage" class="form-select w-full sm:w-1/6">
                @foreach($paginationOptions as $value)
                    <option value="{{ $value }}">{{ $value }}</option>
                @endforeach
            </select>

            @can('client_group_delete')
                <button class="btn btn-rose ml-3 disabled:opacity-50 disabled:cursor-not-allowed" type="button" wire:click="confirm('deleteSelected')" wire:loading.attr="disabled" {{ $this->selectedCount ? '' : 'disabled' }}>
                    {{ __('Delete Selected') }}
                </button>
            @endcan

            @if(file_exists(app_path('Http/Livewire/ExcelExport.php')))
                <livewire:excel-export model="ClientGroup" format="csv" />
                <livewire:excel-export model="ClientGroup" format="xlsx" />
                <livewire:excel-export model="ClientGroup" format="pdf" />
            @endif


            @can('client_group_create')
                <x-csv-import route="{{ route('admin.client-groups.csv.store') }}" />
            @endcan

        </div>
        <div class="w-full sm:w-1/2 sm:text-right">
            Search:
            <input type="text" wire:model.debounce.300ms="search" class="w-full sm:w-1/3 inline-block" />
        </div>
    </div>
    @include('components.loading-spinner-full-page')


    <div class="overflow-hidden">
        <div class="overflow-x-auto">
            <table class="table table-index w-full">
                <thead>
                    <tr>
                        <th class="w-9">
                        </th>
                        <th class="w-28">
                            {{ trans('cruds.clientGroup.fields.id') }}
                            @include('components.table.sort', ['field' => 'id'])
                        </th>
                        <th>
                            {{ trans('cruds.clientGroup.fields.name') }}
                            @include('components.table.sort', ['field' => 'name'])
                        </th>
                        <th>
                            {{ trans('cruds.clientGroup.fields.business_name') }}
                            @include('components.table.sort', ['field' => 'business_name'])
                        </th>
                        <th>
                            {{ trans('cruds.clientGroup.fields.address') }}
                            @include('components.table.sort', ['field' => 'address'])
                        </th>
                        <th>
                            {{ trans('cruds.clientGroup.fields.phone_1') }}
                            @include('components.table.sort', ['field' => 'phone_1'])
                        </th>
                        <th>
                            {{ trans('cruds.clientGroup.fields.phone_2') }}
                            @include('components.table.sort', ['field' => 'phone_2'])
                        </th>
                        <th>
                            {{ trans('cruds.clientGroup.fields.email_1') }}
                            @include('components.table.sort', ['field' => 'email_1'])
                        </th>
                        <th>
                            {{ trans('cruds.clientGroup.fields.email_2') }}
                            @include('components.table.sort', ['field' => 'email_2'])
                        </th>
                        <th>
                            {{ trans('cruds.clientGroup.fields.is_active') }}
                            @include('components.table.sort', ['field' => 'is_active'])
                        </th>
                        <th>
                            {{ trans('cruds.clientGroup.fields.has_multi_state_business') }}
                            @include('components.table.sort', ['field' => 'has_multi_state_business'])
                        </th>
                        <th>
                            {{ trans('cruds.clientGroup.fields.zone') }}
                        </th>
                        <th>
                            {{ trans('cruds.clientGroup.fields.state') }}
                        </th>
                        <th>
                            {{ trans('cruds.clientGroup.fields.circle') }}
                        </th>
                        <th>
                        </th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($clientGroups as $clientGroup)
                        <tr>
                            <td>
                                <input type="checkbox" value="{{ $clientGroup->id }}" wire:model="selected">
                            </td>
                            <td>
                                {{ $clientGroup->id }}
                            </td>
                            <td>
                                {{ $clientGroup->name }}
                            </td>
                            <td>
                                {{ $clientGroup->business_name }}
                            </td>
                            <td>
                                {{ $clientGroup->address }}
                            </td>
                            <td>
                                {{ $clientGroup->phone_1 }}
                            </td>
                            <td>
                                {{ $clientGroup->phone_2 }}
                            </td>
                            <td>
                                {{ $clientGroup->email_1 }}
                            </td>
                            <td>
                                {{ $clientGroup->email_2 }}
                            </td>
                            <td>
                                <input class="disabled:opacity-50 disabled:cursor-not-allowed" type="checkbox" disabled {{ $clientGroup->is_active ? 'checked' : '' }}>
                            </td>
                            <td>
                                <input class="disabled:opacity-50 disabled:cursor-not-allowed" type="checkbox" disabled {{ $clientGroup->has_multi_state_business ? 'checked' : '' }}>
                            </td>
                            <td>
                                @foreach($clientGroup->zone as $key => $entry)
                                    <span class="badge badge-relationship">{{ $entry->name }}</span>
                                @endforeach
                            </td>
                            <td>
                                @foreach($clientGroup->state as $key => $entry)
                                    <span class="badge badge-relationship">{{ $entry->name }}</span>
                                @endforeach
                            </td>
                            <td>
                                @foreach($clientGroup->circle as $key => $entry)
                                    <span class="badge badge-relationship">{{ $entry->name }}</span>
                                @endforeach
                            </td>
                            <td>
                                <div class="flex justify-end">
                                    @can('client_group_show')
                                        <a class="btn btn-sm btn-info mr-2" href="{{ route('admin.client-groups.show', $clientGroup) }}">
                                            {{ trans('global.view') }}
                                        </a>
                                    @endcan
                                    @can('client_group_edit')
                                        <a class="btn btn-sm btn-success mr-2" href="{{ route('admin.client-groups.edit', $clientGroup) }}">
                                            {{ trans('global.edit') }}
                                        </a>
                                    @endcan
                                    @can('client_group_delete')
                                        <button class="btn btn-sm btn-rose mr-2" type="button" wire:click="confirm('delete', {{ $clientGroup->id }})" wire:loading.attr="disabled">
                                            {{ trans('global.delete') }}
                                        </button>
                                    @endcan
                                </div>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="10">No entries found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <div class="card-body">
        <div class="pt-3">
            @if($this->selectedCount)
                <p class="text-sm leading-5">
                    <span class="font-medium">
                        {{ $this->selectedCount }}
                    </span>
                    {{ __('Entries selected') }}
                </p>
            @endif
            {{ $clientGroups->links() }}
        </div>
    </div>
</div>

@push('scripts')
    <script>
        Livewire.on('confirm', e => {
    if (!confirm("{{ trans('global.areYouSure') }}")) {
        return
    }
@this[e.callback](...e.argv)
})
    </script>
@endpush
