<form wire:submit.prevent="submit" class="pt-3">
    @include('components.loading-spinner-full-page')


    <div class="form-group {{ $errors->has('clientBranch.solid_code') ? 'invalid' : '' }}">
        <label class="form-label" for="solid_code">{{ trans('cruds.clientBranch.fields.solid_code') }}</label>
        <input class="form-control" type="text" name="solid_code" id="solid_code" wire:model.debounce.600ms="clientBranch.solid_code">
        <div class="validation-message">
            {{ $errors->first('clientBranch.solid_code') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.clientBranch.fields.solid_code_helper') }}
        </div>
    </div>

    <div class="form-group {{ $errors->has('clientBranch.name') ? 'invalid' : '' }}">
        <label class="form-label" for="name">{{ trans('cruds.clientBranch.fields.name') }}</label>
        <input class="form-control" type="text" name="name" id="name" wire:model.defer="clientBranch.name">
        <div class="validation-message">
            {{ $errors->first('clientBranch.name') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.clientBranch.fields.name_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('clientBranch.address') ? 'invalid' : '' }}">
        <label class="form-label" for="address">{{ trans('cruds.clientBranch.fields.address') }}</label>
        <textarea class="form-control" name="address" id="address" wire:model.defer="clientBranch.address" rows="4"></textarea>
        <div class="validation-message">
            {{ $errors->first('clientBranch.address') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.clientBranch.fields.address_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('clientBranch.email') ? 'invalid' : '' }}">
        <label class="form-label" for="email">{{ trans('cruds.clientBranch.fields.email') }}</label>
        <input class="form-control" type="text" name="email" id="email" wire:model.defer="clientBranch.email">
        <div class="validation-message">
            {{ $errors->first('clientBranch.email') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.clientBranch.fields.email_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('clientBranch.phone') ? 'invalid' : '' }}">
        <label class="form-label" for="phone">{{ trans('cruds.clientBranch.fields.phone') }}</label>
        <input class="form-control" type="text" name="phone" id="phone" wire:model.defer="clientBranch.phone">
        <div class="validation-message">
            {{ $errors->first('clientBranch.phone') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.clientBranch.fields.phone_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('clientBranch.phone_2') ? 'invalid' : '' }}">
        <label class="form-label" for="phone_2">{{ trans('cruds.clientBranch.fields.phone_2') }}</label>
        <input class="form-control" type="text" name="phone_2" id="phone_2" wire:model.defer="clientBranch.phone_2">
        <div class="validation-message">
            {{ $errors->first('clientBranch.phone_2') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.clientBranch.fields.phone_2_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('clientBranch.circle_id') ? 'invalid' : '' }}">
        <label class="form-label" for="circle">{{ trans('cruds.clientBranch.fields.circle') }}</label>
        <x-select-list class="form-control" id="circle" name="circle" :options="$this->listsForFields['circle']" wire:model="clientBranch.circle_id" />
        <div class="validation-message">
            {{ $errors->first('clientBranch.circle_id') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.clientBranch.fields.circle_helper') }}
        </div>
    </div>
    {{-- <div class="form-group {{ $errors->has('clientBranch.region_id') ? 'invalid' : '' }}">
        <label class="form-label" for="region">{{ trans('cruds.clientBranch.fields.region') }}</label>
        <x-select-list class="form-control" id="region" name="region" :options="$this->listsForFields['region']" wire:model="clientBranch.region_id" />
        <div class="validation-message">
            {{ $errors->first('clientBranch.region_id') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.clientBranch.fields.region_helper') }}
        </div>
    </div> --}}
    <div class="form-group {{ $errors->has('clientBranch.full_name') ? 'invalid' : '' }}">
        <label class="form-label" for="full_name">{{ trans('cruds.clientBranch.fields.full_name') }}</label>
        <input class="form-control" type="text" name="full_name" id="full_name" wire:model.defer="clientBranch.full_name">
        <div class="validation-message">
            {{ $errors->first('clientBranch.full_name') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.clientBranch.fields.full_name_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('clientBranch.latitude') ? 'invalid' : '' }}">
        <label class="form-label" for="latitude">{{ trans('cruds.clientBranch.fields.latitude') }}</label>
        <input class="form-control" type="text" name="latitude" id="latitude" wire:model.defer="clientBranch.latitude">
        <div class="validation-message">
            {{ $errors->first('clientBranch.latitude') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.clientBranch.fields.latitude_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('clientBranch.longitude') ? 'invalid' : '' }}">
        <label class="form-label" for="longitude">{{ trans('cruds.clientBranch.fields.longitude') }}</label>
        <input class="form-control" type="text" name="longitude" id="longitude" wire:model.defer="clientBranch.longitude">
        <div class="validation-message">
            {{ $errors->first('clientBranch.longitude') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.clientBranch.fields.longitude_helper') }}
        </div>
    </div>
    <div class="form-group {{ $errors->has('clientBranch.client_id') ? 'invalid' : '' }}">
        <label class="form-label" for="client">{{ trans('cruds.clientBranch.fields.client') }}</label>
        <x-select-list class="form-control" id="client" name="client" :options="$this->listsForFields['client']" wire:model="clientBranch.client_id" />
        <div class="validation-message">
            {{ $errors->first('clientBranch.client_id') }}
        </div>
        <div class="help-block">
            {{ trans('cruds.clientBranch.fields.client_helper') }}
        </div>
    </div>

    <div class="form-group">
        <button class="btn btn-indigo mr-2" type="submit">
            {{ trans('global.save') }}
        </button>
        <a href="{{ route('admin.client-branches.index') }}" class="btn btn-secondary">
            {{ trans('global.cancel') }}
        </a>
    </div>
</form>
